/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.SpanFilter;
import org.apache.lucene.search.SpanFilterResult;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.OpenBitSet;

public class SpanQueryFilter
extends SpanFilter {
    protected SpanQuery query;

    protected SpanQueryFilter() {
    }

    public SpanQueryFilter(SpanQuery query2) {
        this.query = query2;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        SpanFilterResult result = this.bitSpans(reader);
        return result.getDocIdSet();
    }

    public SpanFilterResult bitSpans(IndexReader reader) throws IOException {
        OpenBitSet bits = new OpenBitSet(reader.maxDoc());
        Spans spans = this.query.getSpans(reader);
        ArrayList<SpanFilterResult.PositionInfo> tmp = new ArrayList<SpanFilterResult.PositionInfo>(20);
        int currentDoc = -1;
        SpanFilterResult.PositionInfo currentInfo = null;
        while (spans.next()) {
            int doc = spans.doc();
            bits.set(doc);
            if (currentDoc != doc) {
                currentInfo = new SpanFilterResult.PositionInfo(doc);
                tmp.add(currentInfo);
                currentDoc = doc;
            }
            currentInfo.addPosition(spans.start(), spans.end());
        }
        return new SpanFilterResult(bits, tmp);
    }

    public SpanQuery getQuery() {
        return this.query;
    }

    public String toString() {
        return "SpanQueryFilter(" + this.query + ")";
    }

    public boolean equals(Object o) {
        return o instanceof SpanQueryFilter && this.query.equals(((SpanQueryFilter)o).query);
    }

    public int hashCode() {
        return this.query.hashCode() ^ 0x923F64B9;
    }
}

