/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.common.lexical.lucene;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public abstract class InMemoryIndex {
    private Analyzer indexAnalyzer;
    private QueryParser parser;
    private final Directory directory = new RAMDirectory();
    private IndexSearcher searcher;

    public InMemoryIndex(Analyzer analyzer) {
        this.indexAnalyzer = analyzer;
        this.parser = this.createQueryParser(analyzer);
    }

    public InMemoryIndex(Analyzer queryAnalyzer, Analyzer indexAnalyzer) {
        this.indexAnalyzer = indexAnalyzer;
        this.parser = this.createQueryParser(queryAnalyzer);
    }

    public Analyzer getIndexAnalyzer() {
        return this.indexAnalyzer;
    }

    public void setQueryParser(QueryParser parser) {
        assert (parser != null);
        this.parser = parser;
    }

    public QueryParser getQueryParser() {
        return this.parser;
    }

    protected abstract QueryParser createQueryParser(Analyzer var1);

    public Searcher getSearcher() {
        return this.searcher;
    }

    public void index() throws IOException {
        IndexWriter iwriter = new IndexWriter(this.directory, this.indexAnalyzer, true, IndexWriter.MaxFieldLength.LIMITED);
        this.addDocuments(iwriter);
        iwriter.optimize();
        iwriter.close();
        this.createSearcher();
    }

    protected void createSearcher() throws IOException {
        this.searcher = new IndexSearcher(this.directory, true);
        this.searcher.setDefaultFieldSortScoring(true, true);
    }

    public Query parser(String queryString) throws ParseException {
        return this.escapeIfInvalid(this.parser, queryString);
    }

    public TopFieldDocs search(Query query2, int maxMatches) throws IOException, ParseException {
        assert (this.searcher != null);
        return this.searcher.search(query2, null, maxMatches, Sort.RELEVANCE);
    }

    private Query escapeIfInvalid(QueryParser parser, String query2) throws ParseException {
        try {
            return parser.parse(query2);
        }
        catch (ParseException pe) {
            return parser.parse(QueryParser.escape(query2));
        }
    }

    protected abstract void addDocuments(IndexWriter var1) throws IOException;
}

