/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.common.lexical.model;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Property;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.common.lexical.lucene.PorterStemAnalyzer;
import org.eaglei.common.lexical.model.ModelEntityExtractor;
import org.eaglei.common.lexical.model.ModelEntitySource;
import org.eaglei.model.EIClass;
import org.eaglei.model.jena.JenaEIOntModel;

public final class EIModelEntityExtractorFactory {
    public static Map<String, ModelEntitySource> createSourcesForEachTopLevel() throws IOException {
        HashMap<String, ModelEntitySource> idToProvider = new HashMap<String, ModelEntitySource>();
        OntModel model = JenaEIOntModel.INSTANCE.getOntModel();
        List<String> topURIs = EIModelEntityExtractorFactory.getTopLevelClasses();
        for (String uri : topURIs) {
            ModelEntitySource source = new ModelEntitySource(model, Collections.singletonList(uri), EIModelEntityExtractorFactory.getProps());
            idToProvider.put(uri, source);
        }
        return idToProvider;
    }

    public static ModelEntitySource createSourceForAllRoots() throws IOException {
        OntModel model = JenaEIOntModel.INSTANCE.getOntModel();
        List<String> rootURIs = EIModelEntityExtractorFactory.getAllRoots();
        ModelEntitySource source = new ModelEntitySource(model, rootURIs, EIModelEntityExtractorFactory.getProps());
        return source;
    }

    public static ModelEntityExtractor createExtractorForAllRoots() throws IOException {
        PorterStemAnalyzer analyzer = new PorterStemAnalyzer();
        ModelEntitySource source = EIModelEntityExtractorFactory.createSourceForAllRoots();
        ModelEntityExtractor extractor = new ModelEntityExtractor(analyzer, analyzer, source);
        return extractor;
    }

    public static ModelEntityExtractor createExtractorForSubtree(String uri) throws IOException {
        PorterStemAnalyzer analyzer = new PorterStemAnalyzer();
        OntModel model = JenaEIOntModel.INSTANCE.getOntModel();
        ModelEntitySource source = new ModelEntitySource(model, Collections.singletonList(uri), EIModelEntityExtractorFactory.getProps());
        ModelEntityExtractor extractor = new ModelEntityExtractor(analyzer, analyzer, source);
        return extractor;
    }

    private static List<String> getTopLevelClasses() {
        ArrayList<String> topURIs = new ArrayList<String>();
        List<EIClass> topClasses = JenaEIOntModel.INSTANCE.getTopLevelClasses();
        for (EIClass c : topClasses) {
            String uri = c.getEntity().getURI().toString();
            topURIs.add(uri);
        }
        return topURIs;
    }

    private static List<String> getNonResourceRoots() {
        ArrayList<String> uris = new ArrayList<String>();
        List<EIClass> nonResourceBase = JenaEIOntModel.INSTANCE.getNonResourceBaseClasses();
        for (EIClass c : nonResourceBase) {
            String uri = c.getEntity().getURI().toString();
            uris.add(uri);
        }
        return uris;
    }

    private static List<String> getAllRoots() {
        ArrayList<String> uris = new ArrayList<String>();
        for (String uri : EIModelEntityExtractorFactory.getTopLevelClasses()) {
            uris.add(uri);
        }
        for (String uri : EIModelEntityExtractorFactory.getNonResourceRoots()) {
            uris.add(uri);
        }
        return uris;
    }

    private static List<String> getProps() {
        List<Property> labelProps = JenaEIOntModel.INSTANCE.getLabelProperties();
        ArrayList<String> uris = new ArrayList<String>();
        for (Property prop : labelProps) {
            uris.add(prop.getURI());
        }
        return uris;
    }
}

