/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.common.lexical.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.eaglei.common.lexical.EntityExtractor;
import org.eaglei.common.lexical.EntityMatch;
import org.eaglei.common.lexical.model.ModelEntityMatch;
import org.eaglei.common.lexical.model.ModelEntitySource;
import org.eaglei.common.lexical.model.ModelLuceneIndex;

public class ModelEntityExtractor
implements EntityExtractor {
    private static final Log logger = LogFactory.getLog(ModelEntityExtractor.class);
    public static final float DEFAULT_SCORE_THRESHHOLD = 0.2f;
    public static final int MAX_FRAGMENTS = 4;
    protected ModelLuceneIndex luceneIndex;
    private float scoreThreshold = 0.2f;
    private boolean fuzzyRewrite = false;

    protected ModelEntityExtractor() {
    }

    public ModelEntityExtractor(Analyzer queryAnalyzer, Analyzer indexAnalyzer, ModelEntitySource source) throws IOException {
        this.luceneIndex = new ModelLuceneIndex(queryAnalyzer, indexAnalyzer, source.getURIs(), source.getModel(), source.getProps());
        this.luceneIndex.index();
    }

    public void setFuzzyRewrite(boolean fuzzyRewrite) {
        this.fuzzyRewrite = fuzzyRewrite;
    }

    public ModelLuceneIndex getLuceneIndex() {
        return this.luceneIndex;
    }

    public void setScoreThreshold(float threshold) {
        this.scoreThreshold = threshold;
    }

    @Override
    public List<EntityMatch> match(String text, int maxMatches) throws IOException {
        ArrayList<EntityMatch> matches2 = new ArrayList<EntityMatch>();
        if (text == null || text.length() == 0) {
            return matches2;
        }
        try {
            Query query2 = this.luceneIndex.parser(text);
            TopFieldDocs docs = this.luceneIndex.search(query2, maxMatches);
            if (docs.totalHits == 0 && this.fuzzyRewrite) {
                query2 = ModelEntityExtractor.rewriteToFuzzy(query2);
                docs = this.luceneIndex.search(query2, maxMatches);
            }
            Highlighter highlighter = new Highlighter(new QueryScorer(query2));
            for (int i = 0; i < docs.scoreDocs.length && i < maxMatches; ++i) {
                Field[] labels;
                ScoreDoc scoreDoc = docs.scoreDocs[i];
                Document document = this.luceneIndex.getSearcher().doc(scoreDoc.doc);
                float score = scoreDoc.score;
                if (!(this.scoreThreshold <= 0.0f) && !(score >= this.scoreThreshold)) continue;
                String label = null;
                String highlight = null;
                String prefLabel = document.get("pref_label");
                for (Field field : labels = document.getFields("label")) {
                    label = field.stringValue();
                    try {
                        highlight = highlighter.getBestFragment(this.luceneIndex.getIndexAnalyzer(), "label", label);
                        if (highlight == null) continue;
                        break;
                    }
                    catch (InvalidTokenOffsetsException itoe) {
                        logger.error(itoe);
                    }
                    catch (IOException ioe) {
                        logger.error(ioe);
                    }
                }
                if (highlight == null) {
                    logger.warn("Could not find highlight for " + label);
                    highlight = label = document.get("pref_label");
                }
                ModelEntityMatch match = new ModelEntityMatch(prefLabel, label, highlight, document.get("uri"), score);
                matches2.add(match);
            }
        }
        catch (ParseException pe) {
            throw new IOException(pe);
        }
        return matches2;
    }

    private static Query rewriteToFuzzy(Query originalQuery) {
        if (originalQuery instanceof BooleanQuery) {
            BooleanClause[] clauses;
            BooleanQuery bq = (BooleanQuery)originalQuery;
            for (BooleanClause clause : clauses = bq.getClauses()) {
                Query q = clause.getQuery();
                if (!(clause.getQuery() instanceof TermQuery) && !(clause.getQuery() instanceof PhraseQuery) || clause.getOccur().equals((Object)BooleanClause.Occur.MUST_NOT) || !(clause.getQuery() instanceof TermQuery)) continue;
                TermQuery tq = (TermQuery)q;
                FuzzyQuery fq = new FuzzyQuery(tq.getTerm());
                clause.setQuery(fq);
            }
            return bq;
        }
        if (originalQuery instanceof TermQuery) {
            TermQuery tq = (TermQuery)originalQuery;
            FuzzyQuery fq = new FuzzyQuery(tq.getTerm());
            return fq;
        }
        return originalQuery;
    }
}

