/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.common.lexical.model;

import org.eaglei.common.lexical.EntityMatch;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

public final class ModelEntityMatch
implements EntityMatch {
    private String highlight;
    private String matchLabel;
    private EIEntity entity;
    private float score;

    public ModelEntityMatch(String prefLabel, String matchLabel, String highlight, String URI2, float score) {
        assert (prefLabel != null);
        assert (highlight != null);
        assert (matchLabel != null);
        assert (URI2 != null);
        assert (score >= 0.0f);
        this.entity = EIEntity.create(EIURI.create(URI2), prefLabel);
        this.highlight = highlight;
        this.matchLabel = matchLabel;
        this.score = score;
    }

    @Override
    public EIEntity getEntity() {
        return this.entity;
    }

    @Override
    public float getScore() {
        return this.score;
    }

    @Override
    public String getHighlight() {
        return this.highlight;
    }

    @Override
    public String getMatchLabel() {
        return this.matchLabel;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.highlight);
        sb.append(" (");
        sb.append(this.entity);
        sb.append(", ");
        sb.append(this.score);
        sb.append(")");
        return sb.toString();
    }

    public int hashCode() {
        return this.entity.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ModelEntityMatch)) {
            return false;
        }
        return ((ModelEntityMatch)other).entity.equals(this.entity);
    }
}

