/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.common.lexical.model;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.vocabulary.OWL;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.util.Version;
import org.eaglei.common.lexical.lucene.InMemoryIndex;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIOntModel;

public class ModelLuceneIndex
extends InMemoryIndex {
    private static final Log logger = LogFactory.getLog(ModelLuceneIndex.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    public static final String URI = "uri";
    public static final String LABEL = "label";
    public static final String PREF_LABEL = "pref_label";
    private final List<String> classURIs;
    private final OntModel model;
    private final List<String> props;

    public ModelLuceneIndex(Analyzer queryAnalyzer, Analyzer indexAnalyzer, String classURI, OntModel model, List<String> props) {
        this(queryAnalyzer, indexAnalyzer, Collections.singletonList(classURI), model, props);
    }

    public ModelLuceneIndex(Analyzer queryAnalyzer, Analyzer indexAnalyzer, List<String> classURIs, OntModel model, List<String> props) {
        super(queryAnalyzer, indexAnalyzer);
        assert (classURIs != null);
        assert (!classURIs.isEmpty());
        assert (model != null);
        assert (props != null);
        assert (!props.isEmpty());
        this.classURIs = classURIs;
        this.model = model;
        this.props = props;
    }

    @Override
    protected QueryParser createQueryParser(Analyzer analyzer) {
        return new QueryParser(Version.LUCENE_30, LABEL, analyzer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addDocuments(IndexWriter iwriter) throws IOException {
        this.model.enterCriticalSection(true);
        try {
            ArrayList<Property> properties = new ArrayList<Property>();
            for (String prop : this.props) {
                Property property = this.model.getProperty(prop);
                if (property != null) {
                    properties.add(property);
                    continue;
                }
                logger.warn("Property " + prop + " does not exist");
            }
            HashSet<String> processedURIs = new HashSet<String>();
            for (String classURI : this.classURIs) {
                this.processSubTree(classURI, this.model, properties, iwriter, processedURIs);
            }
        }
        finally {
            this.model.leaveCriticalSection();
        }
    }

    private void processSubTree(String classURI, OntModel ontModel, List<Property> properties, IndexWriter iwriter, Set<String> processedURIs) throws IOException {
        OntClass parentClass = ontModel.getOntClass(classURI);
        List<OntClass> subClasses = parentClass.listSubClasses().toList();
        this.processClass(parentClass, properties, iwriter, processedURIs);
        for (OntClass ontClass : subClasses) {
            this.processClass(ontClass, properties, iwriter, processedURIs);
        }
    }

    private void processClass(OntClass ontClass, List<Property> properties, IndexWriter iwriter, Set<String> processedURIs) throws IOException {
        if (OWL.Nothing.getURI().equals(ontClass.getURI())) {
            logger.warn("OWL Nothing, skipping");
            return;
        }
        String uri = ontClass.getURI();
        if (uri == null) {
            return;
        }
        if (processedURIs.contains(uri)) {
            return;
        }
        processedURIs.add(uri);
        String label = JenaEIOntModel.INSTANCE.getPreferredLabel(EIURI.create(uri));
        Document doc = new Document();
        doc.add(new Field(URI, uri, Field.Store.YES, Field.Index.NO));
        doc.add(new Field(PREF_LABEL, label, Field.Store.YES, Field.Index.NO));
        ArrayList<String> props = new ArrayList<String>();
        for (Property p : properties) {
            JenaEIOntModel.getLiteralsForProperty(ontClass, p, props);
        }
        for (String prop : props) {
            doc.add(new Field(LABEL, prop, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.WITH_POSITIONS_OFFSETS));
        }
        iwriter.addDocument(doc);
    }
}

