/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.actions;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.eaglei.network.actions.DummyDataQueryActionConfig;
import org.eaglei.network.actions.EagleIConfigTool;
import org.eaglei.network.actions.SearchProviderQueryAction;
import org.eaglei.search.datagen.DataGenParams;
import org.eaglei.search.provider.lucene.LuceneProviderFactory;
import org.spin.tools.config.ConfigException;

public final class DummyDataQueryAction
extends SearchProviderQueryAction {
    private static final Logger log = Logger.getLogger(DummyDataQueryAction.class);
    private static final boolean INFO = log.isInfoEnabled();

    public DummyDataQueryAction() throws IOException, ConfigException {
        this(EagleIConfigTool.loadDummyDataQueryActionConfig());
    }

    public DummyDataQueryAction(DummyDataQueryActionConfig config) throws IOException {
        super(LuceneProviderFactory.createInMemoryRepo(DummyDataQueryAction.makeDataGenParams(config)));
    }

    private static DataGenParams makeDataGenParams(DummyDataQueryActionConfig config) {
        DataGenParams params;
        assert (config != null);
        if (config.getInstitutionLabel() != null && config.getInstitutionURI() != null) {
            if (INFO) {
                log.info("Creating dummy data for '" + config.getInstitutionLabel() + "' (" + config.getInstitutionURI() + ")");
            }
            params = DataGenParams.createForOneInstitution(config.getInstitutionURI(), config.getInstitutionLabel());
        } else {
            if (INFO) {
                log.info("Creating dummy data for one institution");
            }
            params = DataGenParams.createForOneInstitution();
        }
        params.setMaterializeHierarchy(true);
        return params;
    }
}

