/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.actions;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.eaglei.network.actions.WithSerializerQueryAction;
import org.eaglei.search.common.SerializationException;
import org.eaglei.search.common.Serializer;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.request.SearchRequest;
import org.eaglei.search.request.SearchResultSet;
import org.spin.node.QueryContext;
import org.spin.node.actions.QueryException;

public abstract class SearchProviderQueryAction
extends WithSerializerQueryAction<SearchRequest> {
    private static final Logger log = Logger.getLogger(SearchProviderQueryAction.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();
    private final SearchProvider searchProvider;
    private final Lock lock = new ReentrantLock();
    volatile boolean isProviderInitialized = false;

    protected SearchProviderQueryAction(SearchProvider searchProvider) throws IOException {
        super(Serializer.SearchRequestSerializer);
        assert (searchProvider != null);
        this.searchProvider = searchProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeProviderIfNecessary() throws IOException {
        this.lock.lock();
        try {
            if (!this.isProviderInitialized) {
                if (INFO) {
                    log.info("Initializing SearchProvider");
                }
                this.searchProvider.init();
                this.isProviderInitialized = true;
                if (INFO) {
                    log.info("Done initializing SearchProvider");
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public final String perform(QueryContext context, SearchRequest request) throws QueryException {
        String jsonResults;
        SearchResultSet results;
        if (INFO) {
            log.info("Querying repository");
        }
        if (DEBUG) {
            try {
                log.debug("Raw SearchRequest JSON: '" + Serializer.SearchRequestSerializer.serialize(request) + "'");
            }
            catch (SerializationException e2) {
                log.error("Error serializing SearchRequest to JSON for debug output", e2);
            }
        }
        try {
            this.initializeProviderIfNecessary();
            results = this.searchProvider.query(request);
        }
        catch (IOException e3) {
            throw new QueryException("Error querying repository", (Throwable)e3);
        }
        if (INFO) {
            log.info("Queried repository.  Got " + results.getTotalCount() + " results.");
        }
        try {
            jsonResults = Serializer.SearchResultSetSerializer.serialize(results);
        }
        catch (SerializationException e4) {
            throw new QueryException("Error serializing results: ", (Throwable)e4);
        }
        if (DEBUG) {
            log.debug("Raw JSON results '" + jsonResults + "'");
        }
        return jsonResults;
    }
}

