/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.datagen;

import com.hp.hpl.jena.ontology.OntResource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eaglei.model.jena.EagleIOntUtils;

public final class DataGenParams {
    private static final int DEFAULT_MIN_CORES = 5;
    private static final int DEFAULT_MAX_CORES = 10;
    private static final int DEFAULT_MIN_RESEARCH = 5;
    private static final int DEFAULT_MAX_RESEARCH = 10;
    private static final int DEFAULT_MIN_RESOURCES = 1;
    private static final int DEFAULT_MAX_RESOURCES = 2;
    public static final int MAX_RESOURCES = 25;
    private Map<String, String> institutionURIToName = new HashMap<String, String>();
    private int coreMin = 5;
    private int coreMax = 10;
    private int researchMin = 5;
    private int researchMax = 10;
    private int resourcePerClassMin = 1;
    private int resourcePerClassMax = 2;
    private boolean materializeHierarchy = false;

    public static DataGenParams createForAllInstitutions() {
        DataGenParams params = new DataGenParams();
        List<? extends OntResource> universities = EagleIOntUtils.getUniversities();
        Iterator<? extends OntResource> i$ = universities.iterator();
        while (i$.hasNext()) {
            OntResource o;
            OntResource institution = o = i$.next();
            params.addInstitution(institution.getURI(), institution.getLabel(null));
        }
        return params;
    }

    public static DataGenParams createForOneInstitution() {
        List<? extends OntResource> universities = EagleIOntUtils.getUniversities();
        return DataGenParams.createForOneInstitution(universities.get(0).getURI(), universities.get(0).getLabel(null));
    }

    public static DataGenParams createForOneInstitution(String uri, String label) {
        DataGenParams params = new DataGenParams();
        params.addInstitution(uri, label);
        return params;
    }

    private DataGenParams() {
    }

    public void addInstitution(String institutionURI, String institutionName) {
        this.institutionURIToName.put(institutionURI, institutionName);
    }

    public void clearInstitutions() {
        this.institutionURIToName.clear();
    }

    public boolean getMaterializeHierarchy() {
        return this.materializeHierarchy;
    }

    public void setMaterializeHierarchy(boolean materializeHierarchy) {
        this.materializeHierarchy = materializeHierarchy;
    }

    public Set<String> getInstitutionURIs() {
        return this.institutionURIToName.keySet();
    }

    public String getInstitutionName(String uri) {
        return this.institutionURIToName.get(uri);
    }

    public void setCoreFacilityRange(int min2, int max2) {
        DataGenParams.checkRange(min2, max2);
        this.coreMin = min2;
        this.coreMax = max2;
    }

    public int getNumCoreFacilities() {
        return DataGenParams.getRandom(this.coreMin, this.coreMax);
    }

    public void setResearchFacilityRange(int min2, int max2) {
        DataGenParams.checkRange(min2, max2);
        this.researchMin = min2;
        this.researchMax = max2;
    }

    public int getNumResearchFacilities() {
        return DataGenParams.getRandom(this.researchMin, this.researchMax);
    }

    public void setResourceRange(int min2, int max2) {
        DataGenParams.checkRange(min2, max2);
        this.resourcePerClassMin = min2;
        this.resourcePerClassMax = max2;
    }

    public int getNumResourcesPerClass() {
        return DataGenParams.getRandom(this.resourcePerClassMin, this.resourcePerClassMax);
    }

    private static void checkRange(int lowerBound, int upperBound) {
        assert (lowerBound >= 0);
        assert (lowerBound <= upperBound);
    }

    public static int getRandom(int lowerBound, int upperBound) {
        int delta = (int)Math.floor(Math.random() * (double)(upperBound - lowerBound));
        return lowerBound + delta;
    }
}

