/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.MultiNodeSearchProvider;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.request.SearchRequest;
import org.eaglei.search.request.SearchResult;
import org.eaglei.search.request.SearchResultSet;

public class SearchProviderUtil {
    public static Collection<EIEntity> getInstitutions(SearchProvider provider) throws IOException {
        assert (provider != null);
        SearchRequest institutionRequest = new SearchRequest(EIURI.create("http://purl.obolibrary.org/obo/ERO_0000065"));
        SearchResultSet results = provider.query(institutionRequest);
        HashSet<EIEntity> institutions = new HashSet<EIEntity>();
        for (SearchResult result : results.getResults()) {
            institutions.add(result.getEntity());
        }
        return institutions;
    }

    public static Collection<EIEntity> getInstitutions(MultiNodeSearchProvider provider) throws IOException {
        assert (provider != null);
        SearchRequest institutionRequest = new SearchRequest(EIURI.create("http://purl.obolibrary.org/obo/ERO_0000065"));
        Collection<SearchResultSet> results = provider.query(institutionRequest);
        HashSet<EIEntity> institutions = new HashSet<EIEntity>();
        for (SearchResultSet resultSet : results) {
            for (SearchResult result : resultSet.getResults()) {
                institutions.add(result.getEntity());
            }
        }
        return institutions;
    }

    public static EIURI getType(SearchRequest request) {
        EIURI type = null;
        SearchRequest.Term term = request.getTerm();
        if (term != null && term.getURI() != null) {
            type = term.getURI();
        } else {
            SearchRequest.TypeBinding binding = request.getBinding();
            if (binding != null) {
                type = binding.getType();
            }
        }
        return type;
    }
}

