/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider;

import java.io.IOException;
import org.eaglei.search.config.SearchConfiguration;
import org.eaglei.search.provider.MultiNodeSearchProvider;
import org.eaglei.search.provider.MultiNodeSearchProviderFactory;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchProviderFactory;
import org.eaglei.search.provider.SearchResultRankMerger;

public class SearchResultRankMergerFactory
implements SearchProviderFactory {
    public static final String NESTED_PROVIDER_FACTORY_PROP = "search.provider.merger.nested.provider.factory.class";
    public static final String TRIM_TO_RANGE_PROP = "search.provider.merger.trim.to.range";
    public static final String DEFAULT_TRIM_TO_RANGE_PROP = "true";

    @Override
    public SearchProvider createSearchProvider(SearchConfiguration config) throws IOException {
        String nestedProviderFactoryClass = config.getProperties().getProperty(NESTED_PROVIDER_FACTORY_PROP);
        if (nestedProviderFactoryClass == null) {
            throw new IOException("Nested provider factory class property not set");
        }
        try {
            Class<?> factoryClass = Class.forName(nestedProviderFactoryClass);
            MultiNodeSearchProviderFactory factory = (MultiNodeSearchProviderFactory)factoryClass.newInstance();
            MultiNodeSearchProvider nestedProvider = factory.createMultiNodeSearchProvider(config);
            SearchResultRankMerger merger = new SearchResultRankMerger(nestedProvider);
            String trimToRange = config.getProperties().getProperty(TRIM_TO_RANGE_PROP, DEFAULT_TRIM_TO_RANGE_PROP);
            merger.setTrimToRange(Boolean.parseBoolean(trimToRange));
            return merger;
        }
        catch (Exception e2) {
            throw new IOException(e2);
        }
    }
}

