/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene;

import java.io.IOException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.store.RAMDirectory;
import org.eaglei.common.lexical.lucene.PorterStemAnalyzer;
import org.eaglei.model.EIEntity;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.lucene.LuceneIndexer;
import org.eaglei.search.provider.lucene.LuceneProvider;
import org.eaglei.search.request.SearchRequest;
import org.eaglei.search.request.SearchResult;
import org.eaglei.search.request.SearchResultSet;

public class CompositeLuceneProvider
implements SearchProvider {
    private static final Log logger = LogFactory.getLog(CompositeLuceneProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    public static final String UPDATE_FREQUENCY = "search.provider.lucene.composite.update.freq";
    private static final long DEFAULT_UPDATE_FREQ = 1800000L;
    private static final int MAX_RESULTS_TO_INDEX_FROM_EACH_NODE = 25000;
    private SearchProvider nestedProvider;
    private SearchProvider luceneWrapper;
    private long updateFrequency = 1800000L;

    public CompositeLuceneProvider(SearchProvider provider) throws IOException {
        this.nestedProvider = provider;
    }

    public void setUpdateFrequency(long updateFrequency) {
        if (updateFrequency < 60000L) {
            this.updateFrequency = 60000L;
        }
    }

    public long getUpdateFrequency() {
        return this.updateFrequency;
    }

    @Override
    public synchronized void init() throws IOException {
        if (DEBUG) {
            logger.debug("Initializing nested provider for CompositeLuceneProvider");
        }
        this.nestedProvider.init();
        if (DEBUG) {
            logger.debug("Nested provider initialized");
        }
        Thread initThread = new Thread((Runnable)new IndexUpdater(this), "CompositeLuceneProviderIndexUpater");
        initThread.setPriority(1);
        initThread.setDaemon(true);
        initThread.start();
    }

    @Override
    public synchronized Collection<EIEntity> getInstitutions() {
        return this.nestedProvider.getInstitutions();
    }

    @Override
    public synchronized SearchResultSet query(SearchRequest request) throws IOException {
        if (this.luceneWrapper == null) {
            return new SearchResultSet(request);
        }
        return this.luceneWrapper.query(request);
    }

    private synchronized void buildLuceneIndex() throws IOException {
        RAMDirectory dir = new RAMDirectory();
        PorterStemAnalyzer analyzer = new PorterStemAnalyzer();
        LuceneIndexer indexer = new LuceneIndexer(analyzer, dir);
        indexer.initializeStorage();
        SearchRequest request = new SearchRequest();
        request.setMaxResults(25000);
        SearchResultSet resultSet = this.nestedProvider.query(request);
        for (SearchResult result : resultSet.getResults()) {
            indexer.indexSearchResult(result, true);
        }
        indexer.closeStorage();
        this.luceneWrapper = new LuceneProvider(dir, analyzer);
    }

    private static class IndexUpdater
    implements Runnable {
        private final CompositeLuceneProvider provider;

        public IndexUpdater(CompositeLuceneProvider provider) {
            this.provider = provider;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    if (DEBUG) {
                        logger.debug("Building Lucene index using query results from nested provider");
                    }
                    this.provider.buildLuceneIndex();
                    if (DEBUG) {
                        logger.debug("Finished building Lucene index using query results from nested provider");
                    }
                }
                catch (Throwable t) {
                    logger.error("Failed to rebuild lucene index", t);
                }
                try {
                    Thread.sleep(this.provider.getUpdateFrequency());
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

