/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.Directory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIOntModel;
import org.eaglei.search.datagen.AbstractGenerator;
import org.eaglei.search.datagen.DataGenParams;
import org.eaglei.search.provider.lucene.LuceneIndexer;
import org.eaglei.search.request.SearchResult;

public class LuceneGenerator
extends AbstractGenerator {
    private static final Log logger = LogFactory.getLog(LuceneGenerator.class);
    private LuceneIndexer indexer;

    public LuceneGenerator(Analyzer analyzer, Directory directory) {
        this.indexer = new LuceneIndexer(analyzer, directory);
    }

    @Override
    public void initializeStorage() throws IOException {
        this.indexer.initializeStorage();
    }

    @Override
    public void closeStorage() throws IOException {
        this.indexer.closeStorage();
    }

    @Override
    public int generateForInstitution(String uri, String label, DataGenParams genParams) throws IOException {
        int total = super.generateForInstitution(uri, label, genParams);
        EIEntity institutionEntity = EIEntity.create(EIURI.create(uri), label);
        EIClass typeClass = JenaEIOntModel.INSTANCE.getClass(EIURI.create("http://purl.obolibrary.org/obo/ERO_0000065"));
        EIEntity typeEntity = typeClass.getEntity();
        SearchResult result = new SearchResult(institutionEntity, typeEntity, null, institutionEntity);
        result.addDataTypeProperty(EIURI.create(RDFS.label.getURI()), label);
        this.indexer.indexSearchResult(result, genParams.getMaterializeHierarchy());
        return total + 1;
    }

    @Override
    public int generateLab(String institutionURI, String institutionLabel, String labLabel, String labURI, String labURL, String labTypeURI, DataGenParams genParams) throws IOException {
        int total = super.generateLab(institutionURI, institutionLabel, labLabel, labURI, labURL, labTypeURI, genParams);
        EIEntity labEntity = EIEntity.create(EIURI.create(labURI), labLabel);
        EIEntity institutionEntity = EIEntity.create(EIURI.create(institutionURI), institutionLabel);
        EIClass typeClass = JenaEIOntModel.INSTANCE.getClass(EIURI.create(labTypeURI));
        EIEntity typeEntity = typeClass.getEntity();
        SearchResult result = new SearchResult(labEntity, typeEntity, labEntity, institutionEntity);
        result.addDataTypeProperty(EIURI.create(RDFS.label.getURI()), labLabel);
        this.indexer.indexSearchResult(result, genParams.getMaterializeHierarchy());
        return total + 1;
    }

    @Override
    public void generateResource(String institutionURI, String institutionLabel, String resourceLabel, String resourceURI, OntClass resourceClass, String resourceURL, String labName, String labURI, DataGenParams genParams) throws IOException {
        EIEntity resourceEntity = EIEntity.create(EIURI.create(resourceURI), resourceLabel);
        EIEntity labEntity = EIEntity.create(EIURI.create(labURI), labName);
        EIEntity institutionEntity = EIEntity.create(EIURI.create(institutionURI), institutionLabel);
        EIClass typeClass = JenaEIOntModel.INSTANCE.getClass(EIURI.create(resourceClass.getURI()));
        EIEntity typeEntity = typeClass.getEntity();
        SearchResult result = new SearchResult(resourceEntity, typeEntity, labEntity, institutionEntity);
        this.indexer.indexSearchResult(result, genParams.getMaterializeHierarchy());
    }
}

