/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.rdf;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIOntModel;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchProviderUtil;
import org.eaglei.search.request.SearchRequest;
import org.eaglei.search.request.SearchResult;
import org.eaglei.search.request.SearchResultSet;

public abstract class AbstractRDFProvider
implements SearchProvider {
    private static final Log logger = LogFactory.getLog(AbstractRDFProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    protected static final String RESOURCE = "resource";
    protected static final String PROPERTY = "prop";
    protected static final String PROPERTY_VALUE = "propValue";
    private String defaultGraphURI = null;
    private List<EIClass> labSubClasses;
    private List<EIURI> prefLabelProperties = new ArrayList<EIURI>();
    private EIEntity institution;

    public AbstractRDFProvider() {
        this.retrieveOntologyMetadata();
    }

    @Override
    public synchronized void init() throws IOException {
        Collection<EIEntity> institutions = SearchProviderUtil.getInstitutions(this);
        if (institutions.size() == 0) {
            throw new IOException("No institutions found");
        }
        if (institutions.size() != 1) {
            logger.error("RDFProvider can only have a single institution");
        }
        this.institution = institutions.iterator().next();
    }

    @Override
    public synchronized Collection<EIEntity> getInstitutions() {
        return Collections.singletonList(this.institution);
    }

    private void retrieveOntologyMetadata() {
        List<Property> props = JenaEIOntModel.INSTANCE.getPrefLabelProperties();
        for (Property prop : props) {
            this.prefLabelProperties.add(EIURI.create(prop.getURI()));
        }
        EIClass labClass = JenaEIOntModel.INSTANCE.getClass(EIURI.create("http://purl.obolibrary.org/obo/ERO_0000001"));
        this.labSubClasses = JenaEIOntModel.INSTANCE.getSubClasses(labClass.getEntity().getURI());
        this.labSubClasses.add(labClass);
    }

    public void setDefaultGraphURI(String defaultGraphURI) {
        this.defaultGraphURI = defaultGraphURI;
    }

    public String getDefaultGraphURI() {
        return this.defaultGraphURI;
    }

    @Override
    public synchronized SearchResultSet query(SearchRequest request) throws IOException {
        assert (request != null);
        if (request.getInstitution() != null && this.institution != null && !this.institution.getURI().equals(request.getInstitution())) {
            if (DEBUG) {
                logger.debug("SearchRequest for different institution, returning empty SearchResultSet");
            }
            return new SearchResultSet(request);
        }
        Query query2 = AbstractRDFProvider.createSPARQLQuery(request);
        logger.info("Executing query: " + query2.toString(Syntax.syntaxSPARQL));
        QueryExecution qe = this.getQueryExecution(query2);
        ResultSet rs = qe.execSelect();
        Map<String, SearchResult> uriToResult = this.getSearchResultsFromSPARQLResultSet(rs, request);
        SearchResultSet results = this.createSearchResultSet(uriToResult, request);
        logger.info("Query executed, found " + results.getTotalCount() + " results");
        return results;
    }

    public static Query createSPARQLQuery(SearchRequest request) {
        EIURI type = SearchProviderUtil.getType(request);
        Query query2 = new Query();
        query2.setQuerySelectType();
        query2.setDistinct(true);
        query2.addResultVar(RESOURCE);
        query2.addResultVar(PROPERTY);
        query2.addResultVar(PROPERTY_VALUE);
        Var resourceNode = Var.alloc(RESOURCE);
        Var propertyNode = Var.alloc(PROPERTY);
        Var propertyValueNode = Var.alloc(PROPERTY_VALUE);
        Node typeNode = null;
        if (type != null) {
            typeNode = Node.createURI(type.toString());
        }
        ElementGroup topGroup = new ElementGroup();
        ElementTriplesBlock triplePattern = new ElementTriplesBlock();
        topGroup.addElement(triplePattern);
        topGroup.addTriplePattern(new Triple(resourceNode, propertyNode, propertyValueNode));
        if (type != null) {
            topGroup.addTriplePattern(new Triple(resourceNode, RDF.type.asNode(), typeNode));
        }
        query2.setQueryPattern(topGroup);
        if (DEBUG) {
            logger.debug(query2.toString(Syntax.syntaxSPARQL));
        }
        return query2;
    }

    protected abstract QueryExecution getQueryExecution(Query var1);

    protected Map<String, SearchResult> getSearchResultsFromSPARQLResultSet(ResultSet rs, SearchRequest request) {
        LinkedHashMap<String, SearchResult> uriToResult = new LinkedHashMap<String, SearchResult>();
        while (rs.hasNext()) {
            QuerySolution soln = rs.nextSolution();
            String resource = soln.getResource(RESOURCE).getURI();
            SearchResult result = (SearchResult)uriToResult.get(resource);
            if (result != null) {
                this.updateResultFromQuerySolution(request, result, soln);
                continue;
            }
            result = this.createResultFromQuerySolution(request, soln);
            uriToResult.put(resource, result);
        }
        return uriToResult;
    }

    protected SearchResult createResultFromQuerySolution(SearchRequest request, QuerySolution soln) {
        Resource resource = soln.getResource(RESOURCE);
        String resourceURI = resource.getURI();
        EIEntity resourceEntity = EIEntity.create(EIURI.create(resourceURI), resource.getLocalName());
        EIURI type = SearchProviderUtil.getType(request);
        EIEntity typeEntity = null;
        typeEntity = type != null ? AbstractRDFProvider.getTypeEntity(type.toString()) : AbstractRDFProvider.getTypeEntity("http://purl.obolibrary.org/obo/ERO_0000065");
        SearchResult result = new SearchResult(resourceEntity, typeEntity, null, this.institution);
        this.updateResultFromQuerySolution(request, result, soln);
        return result;
    }

    protected void updateResultFromQuerySolution(SearchRequest request, SearchResult result, QuerySolution soln) {
        String propertyURI = soln.getResource(PROPERTY).getURI();
        EIURI eiURI = EIURI.create(propertyURI);
        RDFNode propValueResource = soln.get(PROPERTY_VALUE);
        if (propValueResource.isLiteral()) {
            result.addDataTypeProperty(eiURI, ((Literal)propValueResource).getLexicalForm());
        } else if (propertyURI.equals(RDF.type.getURI())) {
            String typeURI = ((Resource)propValueResource).getURI();
            EIEntity typeEntity = AbstractRDFProvider.getTypeEntity(typeURI);
            result.setType(typeEntity);
        } else if (propValueResource.isResource()) {
            Resource resource = (Resource)propValueResource;
            result.addObjectProperty(eiURI, EIURI.create(resource.getURI()));
        }
    }

    protected void setLabel(SearchResult result) {
        for (EIURI prop : this.prefLabelProperties) {
            Set<String> values = result.getDataTypeProperty(prop);
            if (values == null) continue;
            EIEntity newEntity = EIEntity.create(result.getEntity().getURI(), values.iterator().next());
            result.setEntity(newEntity);
            break;
        }
    }

    private static EIEntity getTypeEntity(String typeURI) {
        String label = JenaEIOntModel.INSTANCE.getPreferredLabel(EIURI.create(typeURI));
        return EIEntity.create(typeURI, label);
    }

    protected SearchResultSet createSearchResultSet(Map<String, SearchResult> uriToResult, SearchRequest request) {
        int i = 0;
        int start = request.getStartIndex();
        int max2 = request.getMaxResults();
        SearchResultSet results = new SearchResultSet(request);
        for (SearchResult result : uriToResult.values()) {
            if (i >= start && i < start + max2) {
                this.setLabel(result);
                if (this.validResult(result)) {
                    results.getResults().add(result);
                }
            }
            ++i;
        }
        results.setStartIndex(start);
        results.setTotalCount(i);
        return results;
    }

    private boolean validResult(SearchResult result) {
        boolean valid = true;
        EIEntity type = result.getType();
        if (JenaEIOntModel.INSTANCE.getClass(type.getURI()) == null) {
            valid = false;
        }
        return valid;
    }
}

