/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.rdf;

import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.Model;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.jena.EagleIOntUtils;
import org.eaglei.search.datagen.DataGenParams;
import org.eaglei.search.provider.rdf.RDFGenerator;

public class RDFFileGenerator {
    private static final Log logger = LogFactory.getLog(RDFFileGenerator.class);

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].length() == 0) {
            logger.error("RDFFileGenerator <output RDF path>");
            return;
        }
        RDFFileGenerator.generate(args[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generate(String outputPath) throws IOException {
        assert (outputPath != null);
        File outputDir = new File(outputPath);
        logger.debug("Generating test RDF data to directory: " + outputDir.getAbsolutePath());
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            logger.error("Failed to create output directory " + outputDir.getAbsolutePath());
            return;
        }
        List<? extends OntResource> universities = EagleIOntUtils.getUniversities();
        Iterator<? extends OntResource> i$ = universities.iterator();
        while (i$.hasNext()) {
            OntResource o;
            OntResource institution = o = i$.next();
            String uri = institution.getURI();
            String label = institution.getLabel(null);
            DataGenParams genParams = DataGenParams.createForOneInstitution(uri, label);
            RDFGenerator generator = new RDFGenerator();
            logger.debug("Generating for institution: " + label);
            generator.generate(genParams);
            Model rdf = generator.getModel();
            logger.debug("Generated " + rdf.listStatements().toList().size() + " triples for " + label);
            File rdfFile = new File(outputDir, label + ".rdf");
            logger.debug("Serializing RDF to " + rdfFile.getAbsolutePath() + "...");
            FileWriter writer = new FileWriter(rdfFile);
            try {
                rdf.write(writer, "RDF/XML");
                ((Writer)writer).flush();
            }
            finally {
                ((Writer)writer).close();
            }
            logger.debug("...finished writing RDF to " + rdfFile.getAbsolutePath());
        }
    }
}

