/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.rdf;

import com.hp.hpl.jena.rdf.model.Model;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.search.config.SearchConfiguration;
import org.eaglei.search.datagen.DataGenParams;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchProviderFactory;
import org.eaglei.search.provider.rdf.RDFGenerator;
import org.eaglei.search.provider.rdf.RDFModelProvider;
import org.eaglei.search.provider.rdf.SPARQLProtocolProvider;

public final class RDFProviderFactory
implements SearchProviderFactory {
    private static final Log logger = LogFactory.getLog(RDFProviderFactory.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    public static final String SPARQL_URL = "search.provider.sparql.url";
    public static final String SPARQL_HTTP_USERNAME = "search.provider.sparql.http.username";
    public static final String SPARQL_HTTP_PASSWORD = "search.provider.sparql.http.password";

    @Override
    public SearchProvider createSearchProvider(SearchConfiguration config) throws IOException {
        assert (config != null);
        if (DEBUG) {
            logger.debug("Initializing RDF repo");
        }
        String url = config.getFromConfigOrSystem(SPARQL_URL);
        String username = config.getFromConfigOrSystem(SPARQL_HTTP_USERNAME);
        String password = config.getFromConfigOrSystem(SPARQL_HTTP_PASSWORD);
        if (url == null) {
            throw new IOException("SPARQL endpoint URL property not set");
        }
        if (username != null && password != null) {
            return RDFProviderFactory.createSearchProvider(url, username, password);
        }
        return RDFProviderFactory.createSearchProvider(url);
    }

    public static SearchProvider createSearchProvider(DataGenParams genParams) throws IOException {
        assert (genParams != null);
        RDFGenerator generator = new RDFGenerator();
        generator.generate(genParams);
        return new RDFModelProvider(generator.getModel());
    }

    public static SearchProvider createSearchProvider(Model model) throws IOException {
        assert (model != null);
        return new RDFModelProvider(model);
    }

    public static SearchProvider createSearchProvider(String url) throws IOException {
        assert (url != null);
        return new SPARQLProtocolProvider(url);
    }

    public static SearchProvider createSearchProvider(String url, String username, String password) throws IOException {
        assert (url != null);
        return new SPARQLProtocolProvider(url, username, password);
    }
}

