/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.rdf;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.search.provider.rdf.AbstractRDFProvider;
import org.eaglei.search.request.SearchRequest;
import org.eaglei.search.request.SearchResult;

public class SPARQLProtocolProvider
extends AbstractRDFProvider {
    public static final String PUBLISHED_NG = "http://eagle-i.org/ont/repo/1.0/NG_Published";
    public static final String DEFAULT_NG = "http://eagle-i.org/ont/repo/1.0/NG_DefaultWorkspace";
    private static final Log logger = LogFactory.getLog(SPARQLProtocolProvider.class);
    private final String url;
    private String username = null;
    private String password = null;

    public SPARQLProtocolProvider(String url) throws IOException {
        assert (url != null);
        this.url = url;
        this.setDefaultGraphURI(PUBLISHED_NG);
    }

    public SPARQLProtocolProvider(String url, String username, String password) throws IOException {
        this(url);
        this.setBasicAuth(username, password);
    }

    public void setBasicAuth(String username, String password) {
        assert (username != null);
        assert (password != null);
        this.username = username;
        this.password = password;
    }

    @Override
    public SearchResult createResultFromQuerySolution(SearchRequest request, QuerySolution soln) {
        SearchResult result = super.createResultFromQuerySolution(request, soln);
        if (result != null) {
            result.setURL(result.getEntity().toString());
        }
        return result;
    }

    @Override
    protected QueryExecution getQueryExecution(Query query2) {
        logger.info(query2.toString(Syntax.syntaxSPARQL));
        QueryEngineHTTP qe = (QueryEngineHTTP)QueryExecutionFactory.sparqlService(this.url, query2);
        if (this.username != null && this.password != null) {
            qe.setBasicAuthentication(this.username, this.password.toCharArray());
            if (this.getDefaultGraphURI() != null) {
                qe.addDefaultGraph(this.getDefaultGraphURI());
            }
        }
        return qe;
    }
}

