/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.request;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eaglei.model.EIURI;

public class SearchRequest
implements Serializable {
    public static final long serialVersionUID = 1L;
    public static final int DEFAULT_PAGE_SIZE = 10;
    private static final String PARAM_DELIMITER = "&";
    private static final String QUERY_KEY = "q";
    private static final String URI_KEY = "uri";
    private static final String INSTITUTION_KEY = "inst";
    private static final String TYPE_KEY = "t";
    private static final String START_KEY = "start";
    private static final String MAX_KEY = "max";
    private static final String RESOLVE_KEY = "r";
    private EIURI institution;
    private Term term;
    private TypeBinding binding;
    private int startIndex = 0;
    private int maxResults = 10;

    public SearchRequest() {
    }

    public SearchRequest(String query2) {
        this(new Term(query2));
    }

    public SearchRequest(EIURI uri) {
        this(new Term(uri));
    }

    public SearchRequest(Term term) {
        this.term = term;
    }

    public static SearchRequest parse(String strParams) {
        SearchRequest r = new SearchRequest();
        if (strParams != null && strParams.length() > 0) {
            String[] params;
            for (String param : params = strParams.split(PARAM_DELIMITER)) {
                EIURI uri;
                String[] parts = param.split("=");
                if (parts.length != 2) continue;
                if (parts[0].equals(QUERY_KEY)) {
                    if (r.term == null) {
                        r.term = new Term();
                    }
                    r.term.query = parts[1];
                    continue;
                }
                if (parts[0].equals(URI_KEY)) {
                    if (r.term == null) {
                        r.term = new Term();
                    }
                    uri = EIURI.create(parts[1]);
                    r.term.uri = uri;
                    continue;
                }
                if (parts[0].equals(INSTITUTION_KEY)) {
                    r.institution = uri = EIURI.create(parts[1]);
                    continue;
                }
                if (parts[0].equals(TYPE_KEY)) {
                    if (r.binding == null) {
                        r.binding = new TypeBinding();
                    }
                    uri = EIURI.create(parts[1]);
                    r.binding.type = uri;
                    continue;
                }
                if (parts[0].equals(START_KEY)) {
                    try {
                        r.setStartIndex(Integer.valueOf(parts[1]));
                    }
                    catch (NumberFormatException ex) {}
                    continue;
                }
                if (!parts[0].equals(MAX_KEY)) continue;
                try {
                    r.setMaxResults(Integer.valueOf(parts[1]));
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
        }
        return r;
    }

    public EIURI getInstitution() {
        return this.institution;
    }

    public void setInstitution(EIURI institution) {
        this.institution = institution;
    }

    public Term getTerm() {
        return this.term;
    }

    public void setTerm(Term term) {
        this.term = term;
    }

    public TypeBinding getBinding() {
        return this.binding;
    }

    public void setBinding(TypeBinding binding) {
        this.binding = binding;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        assert (startIndex >= 0);
        this.startIndex = startIndex;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        assert (maxResults >= 0);
        this.maxResults = maxResults;
    }

    public String toURLParams() {
        StringBuilder buf = new StringBuilder();
        if (this.term != null) {
            if (this.term.query != null && this.term.query.length() > 0) {
                buf.append(QUERY_KEY);
                buf.append("=");
                buf.append(this.term.query);
            }
            if (this.term.uri != null) {
                if (buf.length() > 0) {
                    buf.append(PARAM_DELIMITER);
                }
                buf.append(URI_KEY);
                buf.append("=");
                buf.append(this.term.uri.toString());
            }
        }
        if (this.institution != null) {
            if (buf.length() > 0) {
                buf.append(PARAM_DELIMITER);
            }
            buf.append(INSTITUTION_KEY);
            buf.append("=");
            buf.append(this.institution.toString());
        }
        if (this.startIndex > 0) {
            if (buf.length() > 0) {
                buf.append(PARAM_DELIMITER);
            }
            buf.append(START_KEY);
            buf.append("=");
            buf.append(this.startIndex);
        }
        if (this.maxResults != 10) {
            if (buf.length() > 0) {
                buf.append(PARAM_DELIMITER);
            }
            buf.append(MAX_KEY);
            buf.append("=");
            buf.append(this.maxResults);
        }
        if (this.binding != null && this.binding.type != null) {
            if (buf.length() > 0) {
                buf.append(PARAM_DELIMITER);
            }
            buf.append(TYPE_KEY);
            buf.append("=");
            buf.append(this.binding.type.toString());
        }
        return buf.toString();
    }

    public String toString() {
        return this.toURLParams();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.binding == null ? 0 : this.binding.hashCode());
        result = 31 * result + (this.institution == null ? 0 : this.institution.hashCode());
        result = 31 * result + this.maxResults;
        result = 31 * result + this.startIndex;
        result = 31 * result + (this.term == null ? 0 : this.term.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchRequest other = (SearchRequest)obj;
        if (this.binding == null ? other.binding != null : !this.binding.equals(other.binding)) {
            return false;
        }
        if (this.institution == null ? other.institution != null : !this.institution.equals(other.institution)) {
            return false;
        }
        if (this.maxResults != other.maxResults) {
            return false;
        }
        if (this.startIndex != other.startIndex) {
            return false;
        }
        return !(this.term == null ? other.term != null : !this.term.equals(other.term));
    }

    public static class TypeBinding
    implements Serializable {
        public static final long serialVersionUID = 1L;
        private EIURI type;
        private Map<EIURI, Object> properties;

        private TypeBinding() {
        }

        public TypeBinding(EIURI type) {
            assert (type != null);
            this.type = type;
        }

        public EIURI getType() {
            return this.type;
        }

        public void addProperty(EIURI property, Object value) {
            assert (property != null);
            assert (value != null);
            if (this.properties == null) {
                this.properties = new HashMap<EIURI, Object>();
            }
            this.properties.put(property, value);
        }

        public Set<EIURI> getProperties() {
            if (this.properties == null) {
                return Collections.EMPTY_SET;
            }
            return this.properties.keySet();
        }

        public Object getProperty(EIURI property) {
            assert (property != null);
            if (this.properties == null) {
                return null;
            }
            return this.properties.get(property);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.properties == null ? 0 : ((Object)this.properties).hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeBinding other = (TypeBinding)obj;
            if (this.properties == null ? other.properties != null : !((Object)this.properties).equals(other.properties)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }

    public static class Term
    implements Serializable {
        public static final long serialVersionUID = 1L;
        private String query;
        private EIURI uri;

        private Term() {
        }

        public Term(String query2, EIURI uri) {
            assert (query2 != null || uri != null);
            assert (query2 == null || query2.length() > 0);
            this.query = query2;
            this.uri = uri;
        }

        public Term(String query2) {
            this(query2, null);
        }

        public Term(EIURI uri) {
            this(null, uri);
        }

        public Term(Term term) {
            this(term.query, term.uri);
        }

        public String getQuery() {
            return this.query;
        }

        public EIURI getURI() {
            return this.uri;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
            result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Term other = (Term)obj;
            if (this.query == null ? other.query != null : !this.query.equals(other.query)) {
                return false;
            }
            return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
        }
    }
}

