/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermFactory;
import aterm.ATermList;
import com.clarkparsia.pellet.datatypes.DatatypeReasoner;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.exceptions.UnrecognizedDatatypeException;
import com.clarkparsia.pellet.el.SimplifiedELClassifier;
import com.clarkparsia.pellet.expressivity.Expressivity;
import com.clarkparsia.pellet.expressivity.ExpressivityChecker;
import com.clarkparsia.pellet.rules.ContinuousRulesStrategy;
import com.clarkparsia.pellet.rules.RuleStrategy;
import com.clarkparsia.pellet.rules.UsableRuleFilter;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import com.clarkparsia.pellet.utils.CollectionUtils;
import com.clarkparsia.pellet.utils.MultiMapUtils;
import com.clarkparsia.pellet.utils.TermFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.KRSSLoader;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.RBox;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InconsistentOntologyException;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.exceptions.UndefinedEntityException;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.output.ATermBaseVisitor;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.EmptySRQStrategy;
import org.mindswap.pellet.tableau.completion.SHINStrategy;
import org.mindswap.pellet.tableau.completion.SHNStrategy;
import org.mindswap.pellet.tableau.completion.SHOINStrategy;
import org.mindswap.pellet.tableau.completion.SHOIQStrategy;
import org.mindswap.pellet.tableau.completion.SHONStrategy;
import org.mindswap.pellet.tableau.completion.SHOQStrategy;
import org.mindswap.pellet.tableau.completion.SHQStrategy;
import org.mindswap.pellet.tableau.completion.SRINStrategy;
import org.mindswap.pellet.tableau.completion.SRNStrategy;
import org.mindswap.pellet.tableau.completion.SROINStrategy;
import org.mindswap.pellet.tableau.completion.SROIQStrategy;
import org.mindswap.pellet.tableau.completion.SRONStrategy;
import org.mindswap.pellet.tableau.completion.SROQStrategy;
import org.mindswap.pellet.tableau.completion.SRQStrategy;
import org.mindswap.pellet.tableau.completion.incremental.DependencyIndex;
import org.mindswap.pellet.tableau.completion.incremental.IncrementalRestore;
import org.mindswap.pellet.taxonomy.CDOptimizedTaxonomyBuilder;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyBuilder;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.taxonomy.printer.ClassTreePrinter;
import org.mindswap.pellet.tbox.TBox;
import org.mindswap.pellet.tbox.TBoxFactory;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.MultiValueMap;
import org.mindswap.pellet.utils.SizeEstimate;
import org.mindswap.pellet.utils.TaxonomyUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;
import org.mindswap.pellet.utils.progress.ProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnowledgeBase {
    public static final Logger log = Logger.getLogger(KnowledgeBase.class.getName());
    private ATermFactory factory = ATermUtils.getFactory();
    protected ABox abox;
    protected TBox tbox;
    protected RBox rbox;
    private Set<ATermAppl> individuals;
    protected TaxonomyBuilder builder;
    private ProgressMonitor builderProgressMonitor;
    private boolean consistent;
    private SizeEstimate estimate;
    private boolean explainOnlyInconsistency = false;
    private Map<ATermAppl, Map<ATermAppl, Set<ATermAppl>>> annotations;
    protected EnumSet<ReasoningState> state = EnumSet.noneOf(ReasoningState.class);
    private Map<ATermAppl, Set<ATermAppl>> instances;
    private ExpressivityChecker expChecker;
    public Timers timers = new Timers();
    private Map<Rule, Rule> rules;
    private Set<ATermAppl> deletedAssertions;
    private DependencyIndex dependencyIndex;
    private Set<ATermAppl> syntacticAssertions;
    protected MultiValueMap<AssertionType, ATermAppl> aboxAssertions;
    protected EnumSet<ChangeType> changes;
    protected boolean canUseIncConsistency;
    FullyDefinedClassVisitor fullyDefinedVisitor = new FullyDefinedClassVisitor();
    DatatypeVisitor datatypeVisitor = new DatatypeVisitor();

    public KnowledgeBase() {
        this.clear();
        this.timers.createTimer("preprocessing");
        this.timers.createTimer("consistency");
        this.timers.createTimer("complete");
        this.state = EnumSet.noneOf(ReasoningState.class);
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.deletedAssertions = new HashSet<ATermAppl>();
            this.dependencyIndex = new DependencyIndex(this);
            this.syntacticAssertions = new HashSet<ATermAppl>();
        }
        this.aboxAssertions = new MultiValueMap();
        this.annotations = new HashMap<ATermAppl, Map<ATermAppl, Set<ATermAppl>>>();
    }

    protected KnowledgeBase(KnowledgeBase kb, boolean emptyABox) {
        this.tbox = kb.tbox;
        this.rbox = kb.rbox;
        this.rules = kb.rules;
        this.aboxAssertions = new MultiValueMap();
        this.expChecker = new ExpressivityChecker(this, kb.getExpressivity());
        this.changes = kb.changes.clone();
        if (emptyABox) {
            this.abox = new ABox(this);
            this.individuals = new HashSet<ATermAppl>();
            this.instances = new HashMap<ATermAppl, Set<ATermAppl>>();
            for (ATermAppl nominal : kb.getExpressivity().getNominals()) {
                this.addIndividual(nominal);
            }
            if (PelletOptions.USE_INCREMENTAL_DELETION) {
                this.deletedAssertions = new HashSet<ATermAppl>();
                this.dependencyIndex = new DependencyIndex(this);
                this.syntacticAssertions = new HashSet<ATermAppl>();
            }
        } else {
            this.abox = kb.abox.copy();
            if (PelletOptions.KEEP_ABOX_ASSERTIONS) {
                for (AssertionType assertionType : AssertionType.values()) {
                    Set assertions = (Set)kb.aboxAssertions.get((Object)assertionType);
                    if (assertions.isEmpty()) continue;
                    this.aboxAssertions.put(assertionType, new HashSet(assertions));
                }
            }
            this.individuals = new HashSet<ATermAppl>(kb.individuals);
            this.instances = new HashMap<ATermAppl, Set<ATermAppl>>(kb.instances);
            if (kb.getDeletedAssertions() != null) {
                this.deletedAssertions = new HashSet<ATermAppl>(kb.getDeletedAssertions());
            }
            if (PelletOptions.USE_INCREMENTAL_CONSISTENCY && PelletOptions.USE_INCREMENTAL_DELETION) {
                this.dependencyIndex = new DependencyIndex(this, kb.dependencyIndex);
            }
            if (kb.syntacticAssertions != null) {
                this.syntacticAssertions = new HashSet<ATermAppl>(kb.syntacticAssertions);
            }
        }
        if (kb.isConsistencyDone()) {
            this.prepare();
            this.state = EnumSet.of(ReasoningState.CONSISTENCY);
            this.consistent = kb.consistent;
            this.abox.setComplete(true);
            this.estimate = new SizeEstimate(this);
        } else {
            this.state = EnumSet.noneOf(ReasoningState.class);
        }
        this.timers = kb.timers;
    }

    public Expressivity getExpressivity() {
        return this.getExpressivityChecker().getExpressivity();
    }

    public ExpressivityChecker getExpressivityChecker() {
        if (this.canUseIncConsistency()) {
            return this.expChecker;
        }
        this.prepare();
        return this.expChecker;
    }

    public void clear() {
        if (this.abox == null) {
            this.abox = new ABox(this);
        } else {
            boolean doExplanation = this.abox.doExplanation();
            boolean keepLastCompletion = this.abox.isKeepLastCompletion();
            this.abox = new ABox(this);
            this.abox.setDoExplanation(doExplanation);
            this.abox.setKeepLastCompletion(keepLastCompletion);
        }
        this.tbox = TBoxFactory.createTBox(this);
        this.rbox = new RBox();
        this.rules = new HashMap<Rule, Rule>();
        this.expChecker = new ExpressivityChecker(this);
        this.individuals = new HashSet<ATermAppl>();
        this.aboxAssertions = new MultiValueMap();
        this.instances = new HashMap<ATermAppl, Set<ATermAppl>>();
        this.builder = null;
        this.state.clear();
        this.changes = EnumSet.of(ChangeType.ABOX_ADD, ChangeType.TBOX_ADD, ChangeType.RBOX_ADD);
    }

    public KnowledgeBase copy() {
        return this.copy(false);
    }

    public KnowledgeBase copy(boolean emptyABox) {
        return new KnowledgeBase(this, emptyABox);
    }

    public void loadKRSS(Reader reader) throws IOException {
        KRSSLoader loader = new KRSSLoader(this);
        loader.parse(reader);
    }

    public void addClass(ATermAppl c) {
        if (c.equals(ATermUtils.TOP) || ATermUtils.isComplexClass(c)) {
            return;
        }
        boolean added = this.tbox.addClass(c);
        if (added) {
            this.changes.add(ChangeType.TBOX_ADD);
            if (log.isLoggable(Level.FINER)) {
                log.finer("class " + c);
            }
        }
    }

    public void addSubClass(ATermAppl sub, ATermAppl sup) {
        if (sub.equals(sup)) {
            return;
        }
        this.changes.add(ChangeType.TBOX_ADD);
        this.tbox.addAxiom(ATermUtils.makeSub(sub, sup));
        if (log.isLoggable(Level.FINER)) {
            log.finer("sub-class " + sub + " " + sup);
        }
    }

    public void addEquivalentClass(ATermAppl c1, ATermAppl c2) {
        if (c1.equals(c2)) {
            return;
        }
        this.changes.add(ChangeType.TBOX_ADD);
        this.tbox.addAxiom(ATermUtils.makeEqClasses(c1, c2));
        if (log.isLoggable(Level.FINER)) {
            log.finer("eq-class " + c1 + " " + c2);
        }
    }

    public void addKey(ATermAppl c, Set<ATermAppl> properties) {
        int varId = 0;
        Set head = CollectionUtils.makeSet();
        Set body = CollectionUtils.makeSet();
        AtomIVariable x = new AtomIVariable("x");
        AtomIVariable y = new AtomIVariable("y");
        head.add(new SameIndividualAtom(x, y));
        for (ATermAppl property : properties) {
            AtomVariable z;
            if (this.isObjectProperty(property)) {
                z = new AtomIVariable("z" + varId);
                body.add(new IndividualPropertyAtom(property, x, (AtomIObject)((Object)z)));
                body.add(new IndividualPropertyAtom(property, y, (AtomIObject)((Object)z)));
            } else if (this.isDatatypeProperty(property)) {
                z = new AtomDVariable("z" + varId);
                body.add(new DatavaluedPropertyAtom(property, x, (AtomDObject)((Object)z)));
                body.add(new DatavaluedPropertyAtom(property, y, (AtomDObject)((Object)z)));
            }
            ++varId;
        }
        body.add(new ClassAtom(c, x));
        body.add(new ClassAtom(c, y));
        this.addRule(new Rule(head, body));
    }

    public void addDisjointClasses(ATermList classes) {
        this.changes.add(ChangeType.TBOX_ADD);
        this.tbox.addAxiom(ATermUtils.makeDisjoints(classes));
        if (log.isLoggable(Level.FINER)) {
            log.finer("disjoints " + classes);
        }
    }

    public void addDisjointClasses(List<ATermAppl> classes) {
        this.addDisjointClasses(ATermUtils.toSet(classes));
    }

    public void addDisjointClass(ATermAppl c1, ATermAppl c2) {
        this.changes.add(ChangeType.TBOX_ADD);
        this.tbox.addAxiom(ATermUtils.makeDisjoint(c1, c2));
        if (log.isLoggable(Level.FINER)) {
            log.finer("disjoint " + c1 + " " + c2);
        }
    }

    public void addComplementClass(ATermAppl c1, ATermAppl c2) {
        this.changes.add(ChangeType.TBOX_ADD);
        ATermAppl notC2 = ATermUtils.makeNot(c2);
        if (c1.equals(notC2)) {
            return;
        }
        this.tbox.addAxiom(ATermUtils.makeEqClasses(c1, notC2));
        if (log.isLoggable(Level.FINER)) {
            log.finer("complement " + c1 + " " + c2);
        }
    }

    public void addDataPropertyValue(ATermAppl p, ATermAppl s, ATermAppl o) {
        this.addPropertyValue(p, s, o);
    }

    public Individual addIndividual(ATermAppl i) {
        Node node = this.abox.getNode(i);
        if (node != null) {
            if (node instanceof Literal) {
                throw new UnsupportedFeatureException("Trying to use a literal as an individual: " + ATermUtils.toString(i));
            }
            return (Individual)node;
        }
        if (ATermUtils.isLiteral(i)) {
            throw new UnsupportedFeatureException("Trying to use a literal as an individual: " + ATermUtils.toString(i));
        }
        int remember = this.abox.getBranch();
        this.abox.setBranch(DependencySet.NO_BRANCH);
        this.abox.setSyntacticUpdate(true);
        Individual ind = this.abox.addIndividual(i, DependencySet.INDEPENDENT);
        this.individuals.add(i);
        if (log.isLoggable(Level.FINER)) {
            log.finer("individual " + i);
        }
        this.abox.setSyntacticUpdate(false);
        if (!PelletOptions.USE_PSEUDO_NOMINALS) {
            ATermAppl nominal = ATermUtils.makeValue(i);
            this.abox.addType(i, nominal, DependencySet.INDEPENDENT);
        }
        this.changes.add(ChangeType.ABOX_ADD);
        if (this.canUseIncConsistency()) {
            this.abox.setSyntacticUpdate(true);
            for (int j = 0; j < this.abox.getBranches().size(); ++j) {
                Branch branch = this.abox.getBranches().get(j);
                branch.setNodeCount(branch.getNodeCount() + 1);
            }
            this.abox.getIncrementalChangeTracker().addUpdatedIndividual(this.abox.getIndividual(i));
            this.abox.getIncrementalChangeTracker().addNewIndividual(this.abox.getIndividual(i));
            this.abox.setSyntacticUpdate(false);
        }
        this.abox.setBranch(remember);
        return ind;
    }

    public void addType(ATermAppl i, ATermAppl c) {
        DependencySet ds;
        ATermAppl typeAxiom = ATermUtils.makeTypeAtom(i, c);
        DependencySet dependencySet = ds = PelletOptions.USE_TRACING ? new DependencySet(typeAxiom) : DependencySet.INDEPENDENT;
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.syntacticAssertions.add(typeAxiom);
            this.dependencyIndex.addTypeDependency(i, c, ds);
        }
        if (PelletOptions.KEEP_ABOX_ASSERTIONS) {
            this.aboxAssertions.add(AssertionType.TYPE, typeAxiom);
        }
        this.addType(i, c, ds);
    }

    public void addType(ATermAppl i, ATermAppl c, DependencySet ds) {
        this.changes.add(ChangeType.ABOX_ADD);
        if (this.canUseIncConsistency()) {
            this.abox.getIncrementalChangeTracker().addUpdatedIndividual(this.abox.getIndividual(i));
        }
        this.abox.setSyntacticUpdate(true);
        this.abox.addType(i, c, ds);
        this.abox.setSyntacticUpdate(false);
        if (this.canUseIncConsistency()) {
            this.updateExpressivity(i, c);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("type " + i + " " + c);
        }
    }

    public void addSame(ATermAppl i1, ATermAppl i2) {
        this.changes.add(ChangeType.ABOX_ADD);
        if (this.canUseIncConsistency()) {
            this.abox.getIncrementalChangeTracker().addUpdatedIndividual(this.abox.getIndividual(i1));
            this.abox.getIncrementalChangeTracker().addUpdatedIndividual(this.abox.getIndividual(i2));
            this.abox.addSame(i1, i2);
        }
        this.abox.addSame(i1, i2);
        if (log.isLoggable(Level.FINER)) {
            log.finer("same " + i1 + " " + i2);
        }
    }

    public void addAllDifferent(ATermList list) {
        this.changes.add(ChangeType.ABOX_ADD);
        if (this.canUseIncConsistency()) {
            ATermList outer = list;
            while (!outer.isEmpty()) {
                ATermList inner = outer.getNext();
                while (!inner.isEmpty()) {
                    this.abox.getIncrementalChangeTracker().addUpdatedIndividual(this.abox.getIndividual(outer.getFirst()));
                    this.abox.getIncrementalChangeTracker().addUpdatedIndividual(this.abox.getIndividual(inner.getFirst()));
                    inner = inner.getNext();
                }
                outer = outer.getNext();
            }
            int branch = this.abox.getBranch();
            this.abox.setBranch(0);
            this.abox.addAllDifferent(list);
            this.abox.setBranch(branch);
        }
        this.abox.addAllDifferent(list);
        if (log.isLoggable(Level.FINER)) {
            log.finer("all diff " + list);
        }
    }

    public void addDifferent(ATermAppl i1, ATermAppl i2) {
        this.changes.add(ChangeType.ABOX_ADD);
        if (this.canUseIncConsistency()) {
            this.abox.getIncrementalChangeTracker().addUpdatedIndividual(this.abox.getIndividual(i1));
            this.abox.getIncrementalChangeTracker().addUpdatedIndividual(this.abox.getIndividual(i2));
            int branch = this.abox.getBranch();
            this.abox.setBranch(0);
            this.abox.addDifferent(i1, i2);
            this.abox.setBranch(branch);
        }
        this.abox.addDifferent(i1, i2);
        if (log.isLoggable(Level.FINER)) {
            log.finer("diff " + i1 + " " + i2);
        }
    }

    public void addObjectPropertyValue(ATermAppl p, ATermAppl s, ATermAppl o) {
        this.addPropertyValue(p, s, o);
    }

    public boolean addPropertyValue(ATermAppl p, ATermAppl s, ATermAppl o) {
        DependencySet ds;
        Individual subj = this.abox.getIndividual(s);
        Role role = this.getRole(p);
        Node obj = null;
        if (subj == null) {
            log.warning(s + " is not a known individual!");
            return false;
        }
        if (role == null) {
            log.warning(p + " is not a known property!");
            return false;
        }
        if (!role.isObjectRole() && !role.isDatatypeRole()) {
            return false;
        }
        ATermAppl propAxiom = ATermUtils.makePropAtom(p, s, o);
        DependencySet dependencySet = ds = PelletOptions.USE_TRACING ? new DependencySet(propAxiom) : DependencySet.INDEPENDENT;
        if (role.isObjectRole()) {
            obj = this.abox.getIndividual(o);
            if (obj == null) {
                if (ATermUtils.isLiteral(o)) {
                    log.warning("Ignoring literal value " + o + " for object property " + p);
                    return false;
                }
                log.warning(o + " is not a known individual!");
                return false;
            }
            if (PelletOptions.KEEP_ABOX_ASSERTIONS) {
                this.aboxAssertions.add(AssertionType.OBJ_ROLE, propAxiom);
            }
        } else if (role.isDatatypeRole()) {
            if (!ATermUtils.isLiteral(o)) {
                log.warning("Ignoring non-literal value " + o + " for data property " + p);
                return false;
            }
            obj = this.abox.addLiteral(o, ds);
            if (PelletOptions.KEEP_ABOX_ASSERTIONS) {
                this.aboxAssertions.add(AssertionType.DATA_ROLE, propAxiom);
            }
        }
        this.changes.add(ChangeType.ABOX_ADD);
        if (!this.canUseIncConsistency()) {
            Edge edge = this.abox.addEdge(p, s, obj.getName(), ds);
            if (PelletOptions.USE_INCREMENTAL_DELETION) {
                this.syntacticAssertions.add(propAxiom);
                this.dependencyIndex.addEdgeDependency(edge, edge.getDepends());
            }
        } else if (this.canUseIncConsistency()) {
            Individual subj2;
            this.abox.getIncrementalChangeTracker().addUpdatedIndividual(this.abox.getIndividual(s));
            if (role.isObjectRole()) {
                this.abox.getIncrementalChangeTracker().addUpdatedIndividual(this.abox.getIndividual(o));
                obj = this.abox.getIndividual(o);
                if (obj.isPruned() || obj.isMerged()) {
                    obj = obj.getSame();
                }
            }
            if ((subj2 = this.abox.getIndividual(s)).isPruned() || subj2.isMerged()) {
                subj2 = subj2.getSame();
            }
            ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makePropAtom(p, s, o)) : DependencySet.INDEPENDENT;
            int branch = this.abox.getBranch();
            this.abox.setBranch(DependencySet.NO_BRANCH);
            Edge newEdge = subj2.addEdge(role, obj, ds);
            this.abox.setBranch(branch);
            if (newEdge != null) {
                this.abox.getIncrementalChangeTracker().addNewEdge(newEdge);
            }
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("prop-value " + s + " " + p + " " + o);
        }
        return true;
    }

    public boolean addNegatedPropertyValue(ATermAppl p, ATermAppl s, ATermAppl o) {
        DependencySet ds;
        this.changes.add(ChangeType.ABOX_ADD);
        Individual subj = this.abox.getIndividual(s);
        Role role = this.getRole(p);
        if (subj == null) {
            log.warning(s + " is not a known individual!");
            return false;
        }
        if (role == null) {
            log.warning(p + " is not a known property!");
            return false;
        }
        ATermAppl propAxiom = ATermUtils.makeNot(ATermUtils.makePropAtom(p, s, o));
        DependencySet dependencySet = ds = PelletOptions.USE_TRACING ? new DependencySet(propAxiom) : DependencySet.INDEPENDENT;
        if (role.isObjectRole()) {
            if (this.abox.getIndividual(o) == null) {
                if (ATermUtils.isLiteral(o)) {
                    log.warning("Ignoring literal value " + o + " for object property " + p);
                    return false;
                }
                log.warning(o + " is not a known individual!");
                return false;
            }
        } else if (role.isDatatypeRole()) {
            this.abox.addLiteral(o, ds);
        }
        ATermAppl C2 = ATermUtils.makeNot(ATermUtils.makeHasValue(p, o));
        this.addType(s, C2, ds);
        if (log.isLoggable(Level.FINER)) {
            log.finer("not-prop-value " + s + " " + p + " " + o);
        }
        return true;
    }

    public void addProperty(ATermAppl p) {
        this.changes.add(ChangeType.RBOX_ADD);
        this.rbox.addRole(p);
        if (log.isLoggable(Level.FINER)) {
            log.finer("prop " + p);
        }
    }

    public boolean addObjectProperty(ATerm p) {
        boolean exists = this.getPropertyType(p) == 1;
        Role role = this.rbox.addObjectRole((ATermAppl)p);
        if (!exists) {
            this.changes.add(ChangeType.RBOX_ADD);
            if (log.isLoggable(Level.FINER)) {
                log.finer("object-prop " + p);
            }
        }
        return role != null;
    }

    public boolean addDatatypeProperty(ATerm p) {
        boolean exists = this.getPropertyType(p) == 2;
        Role role = this.rbox.addDatatypeRole((ATermAppl)p);
        if (!exists) {
            this.changes.add(ChangeType.RBOX_ADD);
            if (log.isLoggable(Level.FINER)) {
                log.finer("data-prop " + p);
            }
        }
        return role != null;
    }

    public void addOntologyProperty(ATermAppl p) {
        this.changes.add(ChangeType.RBOX_ADD);
        this.rbox.addOntologyRole(p);
        if (log.isLoggable(Level.FINER)) {
            log.finer("onto-prop " + p);
        }
    }

    public boolean addAnnotationProperty(ATermAppl p) {
        this.changes.add(ChangeType.RBOX_ADD);
        Role role = this.rbox.addAnnotationRole(p);
        if (log.isLoggable(Level.FINER)) {
            log.finer("annotation-prop " + p);
        }
        return role != null;
    }

    public boolean addAnnotation(ATermAppl s, ATermAppl p, ATermAppl o) {
        Set<ATermAppl> oidx;
        if (!PelletOptions.USE_ANNOTATION_SUPPORT) {
            return false;
        }
        if (!this.isAnnotationProperty(p)) {
            return false;
        }
        Map<ATermAppl, Set<ATermAppl>> pidx = this.annotations.get(s);
        if (pidx == null) {
            pidx = new HashMap<ATermAppl, Set<ATermAppl>>();
        }
        if ((oidx = pidx.get(p)) == null) {
            oidx = new HashSet<ATermAppl>();
        }
        oidx.add(o);
        pidx.put(p, oidx);
        this.annotations.put(s, pidx);
        if (log.isLoggable(Level.FINER)) {
            log.finer("annotation " + s + " " + p + " " + o);
        }
        return true;
    }

    public Set<ATermAppl> getAnnotations(ATermAppl s, ATermAppl p) {
        if (s == null || p == null) {
            return null;
        }
        Map<ATermAppl, Set<ATermAppl>> pidx = this.annotations.get(s);
        if (pidx == null) {
            return null;
        }
        HashSet<ATermAppl> values = new HashSet<ATermAppl>();
        for (ATermAppl subproperty : this.getSubAnnotationProperties(p)) {
            if (pidx.get(subproperty) == null) continue;
            for (ATermAppl value : pidx.get(subproperty)) {
                values.add(value);
            }
        }
        return values;
    }

    private Set<ATermAppl> getSubAnnotationProperties(ATermAppl p) {
        HashSet<ATermAppl> values = new HashSet<ATermAppl>();
        ArrayList<ATermAppl> temp = new ArrayList<ATermAppl>();
        temp.add(p);
        while (!temp.isEmpty()) {
            ATermAppl value = (ATermAppl)temp.remove(0);
            values.add(value);
            for (ATermAppl property : this.getAnnotationProperties()) {
                if (value == property || !this.isSubPropertyOf(property, value)) continue;
                temp.add(property);
            }
        }
        return values;
    }

    public Set<ATermAppl> getIndividualsWithAnnotation(ATermAppl p, ATermAppl o) {
        HashSet<ATermAppl> ret = new HashSet<ATermAppl>();
        for (Map.Entry<ATermAppl, Map<ATermAppl, Set<ATermAppl>>> e1 : this.annotations.entrySet()) {
            ATermAppl st = e1.getKey();
            Map<ATermAppl, Set<ATermAppl>> pidx = e1.getValue();
            for (Map.Entry<ATermAppl, Set<ATermAppl>> e2 : pidx.entrySet()) {
                ATermAppl pt = e2.getKey();
                Set<ATermAppl> oidx = e2.getValue();
                if (!pt.equals(p) || !oidx.contains(o)) continue;
                ret.add(st);
            }
        }
        return ret;
    }

    public boolean isAnnotation(ATermAppl s, ATermAppl p, ATermAppl o) {
        Set<ATermAppl> oidx = this.getAnnotations(s, p);
        if (oidx == null) {
            return false;
        }
        return oidx.contains(o);
    }

    public void addSubProperty(ATerm sub, ATermAppl sup) {
        this.changes.add(ChangeType.RBOX_ADD);
        this.rbox.addSubRole(sub, sup);
        if (log.isLoggable(Level.FINER)) {
            log.finer("sub-prop " + sub + " " + sup);
        }
    }

    public void addEquivalentProperty(ATermAppl p1, ATermAppl p2) {
        this.changes.add(ChangeType.RBOX_ADD);
        this.rbox.addEquivalentRole(p1, p2);
        if (log.isLoggable(Level.FINER)) {
            log.finer("same-prop " + p1 + " " + p2);
        }
    }

    public void addDisjointProperties(ATermList properties) {
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeDisjointProperties(properties)) : DependencySet.INDEPENDENT;
        ATermList l1 = properties;
        while (!l1.isEmpty()) {
            ATermAppl p1 = (ATermAppl)l1.getFirst();
            ATermList l2 = l1.getNext();
            while (!l2.isEmpty()) {
                ATermAppl p2 = (ATermAppl)l2.getFirst();
                this.addDisjointProperty(p1, p2, ds);
                l2 = l2.getNext();
            }
            l1 = l1.getNext();
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("disjoints " + properties);
        }
    }

    public void addDisjointProperties(List<ATermAppl> properties) {
        this.addDisjointProperties(ATermUtils.toSet(properties));
    }

    public void addDisjointProperty(ATermAppl p1, ATermAppl p2) {
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeDisjointProperty(p1, p2)) : DependencySet.INDEPENDENT;
        this.addDisjointProperty(p1, p2, ds);
    }

    public void addDisjointProperty(ATermAppl p1, ATermAppl p2, DependencySet ds) {
        this.changes.add(ChangeType.RBOX_ADD);
        this.rbox.addDisjointRole(p1, p2, ds);
        if (log.isLoggable(Level.FINER)) {
            log.finer("dis-prop " + p1 + " " + p2);
        }
    }

    public void addInverseProperty(ATermAppl p1, ATermAppl p2) {
        if (PelletOptions.IGNORE_INVERSES) {
            log.warning("Ignoring inverseOf(" + p1 + " " + p2 + ") axiom due to the IGNORE_INVERSES option");
            return;
        }
        this.changes.add(ChangeType.RBOX_ADD);
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeInvProp(p1, p2)) : DependencySet.INDEPENDENT;
        this.rbox.addInverseRole(p1, p2, ds);
        if (log.isLoggable(Level.FINER)) {
            log.finer("inv-prop " + p1 + " " + p2);
        }
    }

    public void addTransitiveProperty(ATermAppl p) {
        this.changes.add(ChangeType.RBOX_ADD);
        Role r = this.rbox.getDefinedRole(p);
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeTransitive(p)) : DependencySet.INDEPENDENT;
        r.addSubRoleChain(ATermUtils.makeList(new ATerm[]{p, p}), ds);
        if (log.isLoggable(Level.FINER)) {
            log.finer("trans-prop " + p);
        }
    }

    public void addSymmetricProperty(ATermAppl p) {
        if (PelletOptions.IGNORE_INVERSES) {
            log.warning("Ignoring SymmetricProperty(" + p + ") axiom due to the IGNORE_INVERSES option");
            return;
        }
        this.changes.add(ChangeType.RBOX_ADD);
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeSymmetric(p)) : DependencySet.INDEPENDENT;
        this.rbox.addInverseRole(p, p, ds);
        if (log.isLoggable(Level.FINER)) {
            log.finer("sym-prop " + p);
        }
    }

    public void addAntisymmetricProperty(ATermAppl p) {
        this.addAsymmetricProperty(p);
    }

    public void addAsymmetricProperty(ATermAppl p) {
        this.changes.add(ChangeType.RBOX_ADD);
        Role r = this.rbox.getDefinedRole(p);
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeAsymmetric(p)) : DependencySet.INDEPENDENT;
        r.setAsymmetric(true, ds);
        if (log.isLoggable(Level.FINER)) {
            log.finer("anti-sym-prop " + p);
        }
    }

    public void addReflexiveProperty(ATermAppl p) {
        this.changes.add(ChangeType.RBOX_ADD);
        Role r = this.rbox.getDefinedRole(p);
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeReflexive(p)) : DependencySet.INDEPENDENT;
        r.setReflexive(true, ds);
        if (log.isLoggable(Level.FINER)) {
            log.finer("reflexive-prop " + p);
        }
    }

    public void addIrreflexiveProperty(ATermAppl p) {
        this.changes.add(ChangeType.RBOX_ADD);
        Role r = this.rbox.getDefinedRole(p);
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeIrreflexive(p)) : DependencySet.INDEPENDENT;
        r.setIrreflexive(true, ds);
        if (log.isLoggable(Level.FINER)) {
            log.finer("irreflexive-prop " + p);
        }
    }

    public void addFunctionalProperty(ATermAppl p) {
        this.changes.add(ChangeType.RBOX_ADD);
        Role r = this.rbox.getDefinedRole(p);
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeFunctional(p)) : DependencySet.INDEPENDENT;
        r.setFunctional(true, ds);
        if (log.isLoggable(Level.FINER)) {
            log.finer("func-prop " + p);
        }
    }

    public void addInverseFunctionalProperty(ATerm p) {
        if (PelletOptions.IGNORE_INVERSES) {
            log.warning("Ignoring InverseFunctionalProperty(" + p + ") axiom due to the IGNORE_INVERSES option");
            return;
        }
        this.changes.add(ChangeType.RBOX_ADD);
        Role role = this.rbox.getDefinedRole(p);
        DependencySet ds = PelletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeInverseFunctional(p)) : DependencySet.INDEPENDENT;
        role.setInverseFunctional(true, ds);
        if (log.isLoggable(Level.FINER)) {
            log.finer("inv-func-prop " + p);
        }
    }

    public void addDomain(ATerm p, ATermAppl c) {
        this.changes.add(ChangeType.RBOX_ADD);
        this.rbox.addDomain(p, c);
        if (log.isLoggable(Level.FINER)) {
            log.finer("domain " + p + " " + c);
        }
    }

    public void addDomain(ATerm p, ATermAppl c, Set<ATermAppl> explain) {
        this.changes.add(ChangeType.RBOX_ADD);
        this.rbox.addDomain(p, c, explain);
        if (log.isLoggable(Level.FINER)) {
            log.finer("domain " + p + " " + c + " " + explain);
        }
    }

    public void addRange(ATerm p, ATermAppl c) {
        this.changes.add(ChangeType.RBOX_ADD);
        this.rbox.addRange(p, c);
        if (log.isLoggable(Level.FINER)) {
            log.finer("range " + p + " " + c);
        }
    }

    public void addRange(ATerm p, ATermAppl c, Set<ATermAppl> explain) {
        this.changes.add(ChangeType.RBOX_ADD);
        this.rbox.addRange(p, c, explain);
        if (log.isLoggable(Level.FINER)) {
            log.finer("range " + p + " " + c + " " + explain);
        }
    }

    public void addDatatype(ATermAppl p) {
        this.getDatatypeReasoner().declare(p);
    }

    public boolean addDatatypeDefinition(ATermAppl name, ATermAppl datarange) {
        return this.getDatatypeReasoner().define(name, datarange);
    }

    public boolean removeDomain(ATerm p, ATermAppl c) {
        Role role = this.getRole(p);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(p + " is not a property!");
            return false;
        }
        if (!this.isClass(c)) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a valid class expression");
            return false;
        }
        boolean removed = this.getRBox().removeDomain(p, c);
        if (removed) {
            this.changes.add(ChangeType.RBOX_DEL);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Remove domain " + p + " " + c);
        }
        return removed;
    }

    public boolean removePropertyValue(ATermAppl p, ATermAppl i1, ATermAppl i2) {
        if (ATermUtils.isLiteral(i2)) {
            try {
                i2 = this.abox.getDatatypeReasoner().getCanonicalRepresentation(i2);
            }
            catch (InvalidLiteralException e2) {
                log.warning(String.format("Unable to remove property value (%s,%s,%s) due to invalid literal: %s", p, i1, i2, e2.getMessage()));
                return false;
            }
            catch (UnrecognizedDatatypeException e3) {
                log.warning(String.format("Unable to remove property value (%s,%s,%s) due to unrecognized datatype for literal: %s", p, i1, i2, e3.getMessage()));
                return false;
            }
        }
        Individual subj = this.abox.getIndividual(i1);
        Node obj = this.abox.getNode(i2);
        Role role = this.getRole(p);
        if (subj == null) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                throw new UnsupportedFeatureException(i1 + " is not an individual!");
            }
            return false;
        }
        if (obj == null) {
            KnowledgeBase.handleUndefinedEntity(i2 + " is not an individual!");
            return false;
        }
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(p + " is not a property!");
            return false;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Remove ObjectPropertyValue " + i1 + " " + p + " " + i2);
        }
        Edge edge = null;
        EdgeList edges = subj.getEdgesTo(obj, role);
        for (int i = 0; i < edges.size() && !(edge = edges.edgeAt(i)).getRole().equals(role); ++i) {
        }
        if (edge == null) {
            return false;
        }
        this.changes.add(ChangeType.ABOX_DEL);
        if (!this.canUseIncConsistency()) {
            subj.removeEdge(edge);
            obj.removeInEdge(edge);
        } else {
            this.getDeletedAssertions().add(ATermUtils.makePropAtom(p, i1, i2));
            this.abox.getIncrementalChangeTracker().addUpdatedIndividual(subj);
            if (!role.isDatatypeRole()) {
                this.abox.getIncrementalChangeTracker().addUpdatedIndividual((Individual)obj);
            }
        }
        if (PelletOptions.KEEP_ABOX_ASSERTIONS) {
            ATermAppl propAxiom = ATermUtils.makePropAtom(p, i1, i2);
            if (ATermUtils.isLiteral(i2)) {
                this.aboxAssertions.remove(AssertionType.DATA_ROLE, propAxiom);
            } else {
                this.aboxAssertions.remove(AssertionType.OBJ_ROLE, propAxiom);
            }
        }
        return true;
    }

    public boolean removeRange(ATerm p, ATermAppl c) {
        Role role = this.getRole(p);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(p + " is not a property!");
            return false;
        }
        if (!this.isClass(c) && !this.isDatatype(c)) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a valid class expression or data range");
            return false;
        }
        boolean removed = this.getRBox().removeRange(p, c);
        if (removed) {
            this.changes.add(ChangeType.RBOX_DEL);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Remove range" + p + " " + c);
        }
        return removed;
    }

    public void removeType(ATermAppl ind, ATermAppl c) {
        this.changes.add(ChangeType.ABOX_DEL);
        Individual subj = this.abox.getIndividual(ind);
        if (subj == null) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return;
            }
            throw new UnsupportedFeatureException(ind + " is not an individual!");
        }
        if (!this.canUseIncConsistency()) {
            subj.removeType(ATermUtils.normalize(c));
        } else {
            this.getDeletedAssertions().add(ATermUtils.makeTypeAtom(ind, c));
            this.abox.getIncrementalChangeTracker().addUpdatedIndividual(subj);
        }
        if (PelletOptions.KEEP_ABOX_ASSERTIONS) {
            ATermAppl typeAxiom = ATermUtils.makeTypeAtom(ind, c);
            this.aboxAssertions.remove(AssertionType.TYPE, typeAxiom);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Remove Type " + ind + " " + c);
        }
    }

    public boolean removeAxiom(ATermAppl axiom) {
        boolean removed = false;
        try {
            removed = this.tbox.removeAxiom(axiom);
        }
        catch (Exception e2) {
            log.log(Level.SEVERE, "Removal failed for axiom " + axiom, e2);
        }
        if (removed) {
            this.changes.add(ChangeType.TBOX_DEL);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Remove " + axiom + ": " + removed);
        }
        return removed;
    }

    public void prepare() {
        Timer t;
        boolean reuseTaxonomy;
        if (!this.isChanged()) {
            return;
        }
        boolean explain = this.abox.doExplanation();
        this.abox.setDoExplanation(true);
        Timer timer = this.timers.startTimer("preprocessing");
        this.state.remove((Object)ReasoningState.CONSISTENCY);
        this.state.remove((Object)ReasoningState.REALIZE);
        boolean bl = reuseTaxonomy = this.state.contains((Object)ReasoningState.CLASSIFY) && !this.isTBoxChanged() && !this.isRBoxChanged() && (!this.expChecker.getExpressivity().hasNominal() || PelletOptions.USE_PSEUDO_NOMINALS);
        if (this.isRBoxChanged()) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Role hierarchy...");
            }
            t = this.timers.startTimer("rbox");
            this.rbox.prepare();
            t.stop();
        }
        if (this.isTBoxChanged()) {
            if (PelletOptions.USE_ABSORPTION) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Absorbing...");
                }
                this.tbox.absorb();
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer("Normalizing...");
            }
            t = this.timers.startTimer("normalize");
            this.tbox.normalize();
            t.stop();
            if (log.isLoggable(Level.FINER)) {
                log.finer("Internalizing...");
            }
            this.tbox.internalize();
        }
        if (this.isRBoxChanged()) {
            this.rbox.propagateDomainRange();
        }
        this.canUseIncConsistency = this.canUseIncConsistency();
        if (this.abox.isComplete()) {
            if (this.changes.contains((Object)ChangeType.TBOX_DEL) || this.changes.contains((Object)ChangeType.RBOX_DEL) || !this.canUseIncConsistency && this.changes.contains((Object)ChangeType.ABOX_DEL)) {
                this.abox.reset();
            } else if (this.changes.contains((Object)ChangeType.TBOX_ADD) || this.changes.contains((Object)ChangeType.RBOX_ADD)) {
                this.abox.resetQueue();
            } else if (this.canUseIncConsistency && this.changes.contains((Object)ChangeType.ABOX_DEL)) {
                IncrementalRestore.restoreDependencies(this);
            }
        }
        this.changes.clear();
        this.instances.clear();
        this.estimate = new SizeEstimate(this);
        this.abox.setDoExplanation(explain);
        this.abox.clearCaches(!reuseTaxonomy);
        this.abox.cache.setMaxSize(PelletOptions.MAX_ANONYMOUS_CACHE);
        if (!reuseTaxonomy) {
            this.state.remove((Object)ReasoningState.CLASSIFY);
            this.builder = null;
        }
        if (!this.canUseIncConsistency) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Expressivity...");
            }
            this.expChecker.prepare();
        }
        timer.stop();
        if (log.isLoggable(Level.FINE)) {
            StringBuffer info = new StringBuffer();
            info.append("Expressivity: " + this.expChecker.getExpressivity() + ", ");
            info.append("Classes: " + this.getClasses().size() + " ");
            info.append("Properties: " + this.getProperties().size() + " ");
            info.append("Individuals: " + this.individuals.size());
            log.fine(info.toString());
        }
    }

    public void updateExpressivity(ATermAppl i, ATermAppl c) {
        if (!this.isChanged() || this.isTBoxChanged() || this.isRBoxChanged()) {
            return;
        }
        this.expChecker.updateWithIndividual(i, c);
        this.estimate = new SizeEstimate(this);
    }

    public String getInfo() {
        this.prepare();
        StringBuffer buffer = new StringBuffer();
        buffer.append("Expressivity: " + this.expChecker + " ");
        buffer.append("Classes: " + this.getClasses().size() + " ");
        buffer.append("Properties: " + this.getProperties().size() + " ");
        buffer.append("Individuals: " + this.individuals.size() + " ");
        Expressivity expressivity = this.expChecker.getExpressivity();
        if (expressivity.hasNominal()) {
            buffer.append("Nominals: " + expressivity.getNominals().size() + " ");
        }
        return buffer.toString();
    }

    public boolean isConsistencyDone() {
        return !this.isChanged() && this.state.contains((Object)ReasoningState.CONSISTENCY);
    }

    public boolean isClassified() {
        return !this.isChanged() && this.state.contains((Object)ReasoningState.CLASSIFY);
    }

    public boolean isRealized() {
        return !this.isChanged() && this.state.contains((Object)ReasoningState.REALIZE);
    }

    public boolean isChanged() {
        return !this.changes.isEmpty();
    }

    public boolean isChanged(ChangeType change) {
        return this.changes.contains((Object)change);
    }

    public boolean isTBoxChanged() {
        return this.changes.contains((Object)ChangeType.TBOX_ADD) || this.changes.contains((Object)ChangeType.TBOX_DEL);
    }

    public boolean isRBoxChanged() {
        return this.changes.contains((Object)ChangeType.RBOX_ADD) || this.changes.contains((Object)ChangeType.RBOX_DEL);
    }

    public boolean isABoxChanged() {
        return this.changes.contains((Object)ChangeType.ABOX_ADD) || this.changes.contains((Object)ChangeType.ABOX_DEL);
    }

    public Set<ATermAppl> getUnsatisfiableClasses() {
        HashSet<ATermAppl> aUnsatClasses = new HashSet();
        if (this.isClassified()) {
            aUnsatClasses = this.getEquivalentClasses(ATermUtils.BOTTOM);
        } else {
            Set<ATermAppl> aClasses = this.getClasses();
            for (ATermAppl aClass : aClasses) {
                if (this.isSatisfiable(aClass)) continue;
                aUnsatClasses.add(aClass);
            }
        }
        return aUnsatClasses;
    }

    private void consistency() {
        if (this.isConsistencyDone()) {
            return;
        }
        this.abox.setInitialized(false);
        this.prepare();
        Timer timer = this.timers.startTimer("consistency");
        boolean doExplanation = this.abox.doExplanation();
        if (PelletOptions.USE_TRACING && !this.explainOnlyInconsistency) {
            this.abox.setDoExplanation(true);
        }
        boolean bl = this.consistent = this.canUseIncConsistency ? this.abox.isIncConsistent() : this.abox.isConsistent();
        if (PelletOptions.USE_INCREMENTAL_CONSISTENCY) {
            this.abox.getIncrementalChangeTracker().clear();
        }
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.getDeletedAssertions().clear();
        }
        if (!this.consistent) {
            if (PelletOptions.USE_TRACING && this.explainOnlyInconsistency && !this.abox.doExplanation()) {
                this.abox.setDoExplanation(true);
                this.abox.reset();
                this.abox.isConsistent();
                this.abox.setDoExplanation(false);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Inconsistent ontology. Reason: " + this.getExplanation());
            }
            if (PelletOptions.USE_TRACING && log.isLoggable(Level.FINE)) {
                log.fine(this.renderExplanationSet());
            }
        }
        this.abox.setDoExplanation(doExplanation);
        this.state.add(ReasoningState.CONSISTENCY);
        timer.stop();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Consistent: " + this.consistent + " (" + timer.getLast() + "ms)");
        }
        assert (this.isConsistencyDone()) : "Consistency flag not set";
    }

    private String renderExplanationSet() {
        StringBuilder msg = new StringBuilder("ExplanationSet: [");
        Set<ATermAppl> explanation = this.getExplanationSet();
        for (ATermAppl axiom : explanation) {
            msg.append(ATermUtils.toString(axiom));
            msg.append(",");
        }
        if (explanation.isEmpty()) {
            msg.append(']');
        } else {
            msg.setCharAt(msg.length() - 1, ']');
        }
        return msg.toString();
    }

    public boolean isConsistent() {
        this.consistency();
        return this.consistent;
    }

    public Taxonomy<ATermAppl> getToldTaxonomy() {
        return this.getTaxonomyBuilder().getToldTaxonomy();
    }

    public Map<ATermAppl, Set<ATermAppl>> getToldDisjoints() {
        return this.getTaxonomyBuilder().getToldDisjoints();
    }

    public void ensureConsistency() {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException("Cannot do reasoning with inconsistent ontologies!\nReason for inconsistency: " + this.getExplanation() + (PelletOptions.USE_TRACING ? "\n" + this.renderExplanationSet() : ""));
        }
    }

    public void classify() {
        this.ensureConsistency();
        if (this.isClassified()) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Classifying...");
        }
        Timer timer = this.timers.startTimer("classify");
        this.builder = this.getTaxonomyBuilder();
        boolean isClassified = this.builder.classify();
        timer.stop();
        if (!isClassified) {
            return;
        }
        this.state.add(ReasoningState.CLASSIFY);
        this.estimate.computKBCosts();
    }

    public void realize() {
        if (this.isRealized()) {
            return;
        }
        this.classify();
        if (!this.isClassified()) {
            return;
        }
        Timer timer = this.timers.startTimer("realize");
        boolean isRealized = this.builder.realize();
        timer.stop();
        if (!isRealized) {
            return;
        }
        this.state.add(ReasoningState.REALIZE);
        this.estimate.computKBCosts();
    }

    public Set<ATermAppl> getClasses() {
        return Collections.unmodifiableSet(this.tbox.getClasses());
    }

    public Set<ATermAppl> getAllClasses() {
        return Collections.unmodifiableSet(this.tbox.getAllClasses());
    }

    public Set<ATermAppl> getProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isObjectRole() && !role.isDatatypeRole() && !role.isAnnotationRole()) continue;
            set.add(p);
        }
        return set;
    }

    public Set<ATermAppl> getObjectProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isObjectRole()) continue;
            set.add(p);
        }
        return set;
    }

    public Set<ATermAppl> getAnnotationProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isAnnotationRole()) continue;
            set.add(p);
        }
        return set;
    }

    public Set<ATermAppl> getTransitiveProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isTransitive()) continue;
            set.add(p);
        }
        set.add(ATermUtils.BOTTOM_OBJECT_PROPERTY);
        return set;
    }

    public Set<ATermAppl> getSymmetricProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isSymmetric()) continue;
            set.add(p);
        }
        return set;
    }

    public Set<ATermAppl> getAntisymmetricProperties() {
        return this.getAsymmetricProperties();
    }

    public Set<ATermAppl> getAsymmetricProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isAsymmetric()) continue;
            set.add(p);
        }
        return set;
    }

    public Set<ATermAppl> getReflexiveProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isReflexive()) continue;
            set.add(p);
        }
        return set;
    }

    public Set<ATermAppl> getIrreflexiveProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isIrreflexive()) continue;
            set.add(p);
        }
        return set;
    }

    public Set<ATermAppl> getFunctionalProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isFunctional()) continue;
            set.add(p);
        }
        set.add(ATermUtils.BOTTOM_DATA_PROPERTY);
        set.add(ATermUtils.BOTTOM_OBJECT_PROPERTY);
        return set;
    }

    public Set<ATermAppl> getInverseFunctionalProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isInverseFunctional()) continue;
            set.add(p);
        }
        set.add(ATermUtils.BOTTOM_OBJECT_PROPERTY);
        return set;
    }

    public Set<ATermAppl> getDataProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        for (Role role : this.rbox.getRoles()) {
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isDatatypeRole()) continue;
            set.add(p);
        }
        return set;
    }

    public Set<ATermAppl> getIndividuals() {
        return Collections.unmodifiableSet(this.individuals);
    }

    public Role getProperty(ATerm r) {
        return this.rbox.getRole(r);
    }

    public int getPropertyType(ATerm r) {
        Role role = this.getProperty(r);
        return role == null ? 0 : role.getType();
    }

    public boolean isClass(ATerm c) {
        if (this.tbox.getClasses().contains(c) || ((Object)c).equals(ATermUtils.TOP)) {
            return true;
        }
        if (ATermUtils.isComplexClass(c)) {
            return this.fullyDefinedVisitor.isFullyDefined((ATermAppl)c);
        }
        return false;
    }

    public boolean isProperty(ATerm p) {
        return this.rbox.isRole(p);
    }

    public boolean isDatatypeProperty(ATerm p) {
        return this.getPropertyType(p) == 2;
    }

    public boolean isObjectProperty(ATerm p) {
        return this.getPropertyType(p) == 1;
    }

    public boolean isABoxProperty(ATerm p) {
        int type = this.getPropertyType(p);
        return type == 1 || type == 2;
    }

    public boolean isAnnotationProperty(ATerm p) {
        return this.getPropertyType(p) == 3;
    }

    public boolean isOntologyProperty(ATerm p) {
        return this.getPropertyType(p) == 4;
    }

    public boolean isIndividual(ATerm ind) {
        return this.getIndividuals().contains(ind);
    }

    public boolean isTransitiveProperty(ATermAppl r) {
        Role role = this.getRole(r);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(r + " is not a known property");
            return false;
        }
        if (role.isTransitive()) {
            if (this.doExplanation()) {
                this.abox.setExplanation(role.getExplainTransitive());
            }
            return true;
        }
        if (!role.isObjectRole() || role.isFunctional() || role.isInverseFunctional()) {
            return false;
        }
        this.ensureConsistency();
        ATermAppl c = ATermUtils.makeTermAppl("_C_");
        ATermAppl notC = ATermUtils.makeNot(c);
        ATermAppl test = ATermUtils.makeAnd(ATermUtils.makeSomeValues(r, ATermUtils.makeSomeValues(r, c)), ATermUtils.makeAllValues(r, notC));
        return !this.abox.isSatisfiable(test);
    }

    public boolean isSymmetricProperty(ATermAppl p) {
        return this.isInverse(p, p);
    }

    public boolean isFunctionalProperty(ATermAppl p) {
        Role role = this.getRole(p);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(p + " is not a known property");
            return false;
        }
        if (role.isAnnotationRole()) {
            return false;
        }
        if (role.isBottom()) {
            if (this.doExplanation()) {
                this.abox.setExplanation(DependencySet.INDEPENDENT);
            }
            return true;
        }
        if (role.isFunctional()) {
            if (this.doExplanation()) {
                this.abox.setExplanation(role.getExplainFunctional());
            }
            return true;
        }
        if (!role.isSimple()) {
            return false;
        }
        ATermAppl min2P = role.isDatatypeRole() ? ATermUtils.makeMin((ATerm)p, 2, (ATerm)ATermUtils.TOP_LIT) : ATermUtils.makeMin((ATerm)p, 2, (ATerm)ATermUtils.TOP);
        return !this.isSatisfiable(min2P);
    }

    public boolean isInverseFunctionalProperty(ATermAppl p) {
        Role role = this.getRole(p);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(p + " is not a known property");
            return false;
        }
        if (!role.isObjectRole()) {
            return false;
        }
        if (role.isInverseFunctional() || role.isBottom()) {
            if (this.doExplanation()) {
                this.abox.setExplanation(role.getExplainInverseFunctional());
            }
            return true;
        }
        ATermAppl invP = role.getInverse().getName();
        ATermAppl max1invP = ATermUtils.makeMax((ATerm)invP, 1, (ATerm)ATermUtils.TOP);
        return this.isSubClassOf(ATermUtils.TOP, max1invP);
    }

    public boolean isReflexiveProperty(ATermAppl p) {
        Role role = this.getRole(p);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(p + " is not a known property");
            return false;
        }
        if (!role.isObjectRole() || role.isIrreflexive()) {
            return false;
        }
        if (role.isReflexive()) {
            if (this.doExplanation()) {
                this.abox.setExplanation(role.getExplainReflexive());
            }
            return true;
        }
        this.ensureConsistency();
        ATermAppl c = ATermUtils.makeTermAppl("_C_");
        ATermAppl notC = ATermUtils.makeNot(c);
        ATermAppl test = ATermUtils.makeAnd(c, ATermUtils.makeAllValues(p, notC));
        return !this.abox.isSatisfiable(test);
    }

    public boolean isIrreflexiveProperty(ATermAppl p) {
        Role role = this.getRole(p);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(p + " is not a known property");
            return false;
        }
        if (!role.isObjectRole() || role.isReflexive()) {
            return false;
        }
        if (role.isIrreflexive()) {
            if (this.doExplanation()) {
                this.abox.setExplanation(role.getExplainIrreflexive());
            }
            return true;
        }
        if (role.isAsymmetric()) {
            if (this.doExplanation()) {
                this.abox.setExplanation(role.getExplainAsymmetric());
            }
            return true;
        }
        this.ensureConsistency();
        ATermAppl test = ATermUtils.makeSelf(p);
        return !this.abox.isSatisfiable(test);
    }

    public boolean isAntisymmetricProperty(ATermAppl p) {
        return this.isAsymmetricProperty(p);
    }

    public boolean isAsymmetricProperty(ATermAppl p) {
        Role role = this.getRole(p);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(p + " is not a known property");
            return false;
        }
        if (!role.isObjectRole()) {
            return false;
        }
        if (role.isAsymmetric()) {
            if (this.doExplanation()) {
                this.abox.setExplanation(role.getExplainAsymmetric());
            }
            return true;
        }
        this.ensureConsistency();
        ATermAppl o = ATermUtils.makeAnonNominal(Integer.MAX_VALUE);
        ATermAppl nom = ATermUtils.makeValue(o);
        ATermAppl test = ATermUtils.makeAnd(nom, ATermUtils.makeSomeValues(p, ATermUtils.makeAnd(ATermUtils.makeNot(nom), ATermUtils.makeSomeValues(p, nom))));
        return !this.abox.isSatisfiable(test);
    }

    public boolean isSubPropertyOf(ATermAppl sub, ATermAppl sup) {
        ATermAppl test;
        Role roleSub = this.rbox.getRole(sub);
        Role roleSup = this.rbox.getRole(sup);
        if (roleSub == null) {
            KnowledgeBase.handleUndefinedEntity(sub + " is not a known property");
            return false;
        }
        if (roleSup == null) {
            KnowledgeBase.handleUndefinedEntity(sup + " is not a known property");
            return false;
        }
        if (roleSub.isSubRoleOf(roleSup)) {
            if (this.doExplanation()) {
                this.abox.setExplanation(roleSub.getExplainSuper(sup));
            }
            return true;
        }
        if (roleSub.getType() != roleSup.getType()) {
            return false;
        }
        this.ensureConsistency();
        if (roleSub.isObjectRole()) {
            ATermAppl c = !roleSub.getRanges().isEmpty() ? roleSub.getRanges().iterator().next() : ATermUtils.makeTermAppl("_C_");
            ATermAppl notC = ATermUtils.makeNot(c);
            test = ATermUtils.makeAnd(ATermUtils.makeSomeValues(sub, c), ATermUtils.makeAllValues(sup, notC));
        } else if (roleSub.isDatatypeRole()) {
            ATermAppl anon = ATermUtils.makeLiteral(ATermUtils.makeAnonNominal(Integer.MAX_VALUE));
            test = ATermUtils.makeAnd(ATermUtils.makeHasValue(sub, anon), ATermUtils.makeAllValues(sup, ATermUtils.makeNot(ATermUtils.makeValue(anon))));
        } else {
            if (roleSub.isAnnotationRole()) {
                return false;
            }
            throw new IllegalArgumentException();
        }
        return !this.abox.isSatisfiable(test);
    }

    public boolean isEquivalentProperty(ATermAppl p1, ATermAppl p2) {
        ATermAppl test;
        Role role1 = this.rbox.getRole(p1);
        Role role2 = this.rbox.getRole(p2);
        if (role1 == null) {
            KnowledgeBase.handleUndefinedEntity(p1 + " is not a known property");
            return false;
        }
        if (role2 == null) {
            KnowledgeBase.handleUndefinedEntity(p2 + " is not a known property");
            return false;
        }
        if (role1.isSubRoleOf(role2) && role2.isSubRoleOf(role1)) {
            if (this.doExplanation()) {
                this.abox.setExplanation(role1.getExplainSuper(p2).union(role1.getExplainSub(p2), this.doExplanation()));
            }
            return true;
        }
        if (role1.isAnnotationRole() || role2.isAnnotationRole()) {
            return false;
        }
        if (role1.getType() != role2.getType()) {
            return false;
        }
        this.ensureConsistency();
        if (role1.isObjectRole()) {
            ATermAppl c = !role1.getRanges().isEmpty() ? role1.getRanges().iterator().next() : (!role2.getRanges().isEmpty() ? role2.getRanges().iterator().next() : ATermUtils.makeTermAppl("_C_"));
            ATermAppl notC = ATermUtils.makeNot(c);
            test = ATermUtils.makeOr(ATermUtils.makeAnd(ATermUtils.makeSomeValues(p1, c), ATermUtils.makeAllValues(p2, notC)), ATermUtils.makeAnd(ATermUtils.makeSomeValues(p2, c), ATermUtils.makeAllValues(p1, notC)));
        } else if (role1.isDatatypeRole()) {
            ATermAppl anon = ATermUtils.makeLiteral(ATermUtils.makeAnonNominal(Integer.MAX_VALUE));
            test = ATermUtils.makeOr(ATermUtils.makeAnd(ATermUtils.makeHasValue(p1, anon), ATermUtils.makeAllValues(p2, ATermUtils.makeNot(ATermUtils.makeValue(anon)))), ATermUtils.makeAnd(ATermUtils.makeHasValue(p2, anon), ATermUtils.makeAllValues(p1, ATermUtils.makeNot(ATermUtils.makeValue(anon)))));
        } else {
            throw new IllegalArgumentException();
        }
        return !this.abox.isSatisfiable(test);
    }

    public boolean isInverse(ATermAppl r1, ATermAppl r2) {
        Role role1 = this.getRole(r1);
        Role role2 = this.getRole(r2);
        if (role1 == null) {
            KnowledgeBase.handleUndefinedEntity(r1 + " is not a known property");
            return false;
        }
        if (role2 == null) {
            KnowledgeBase.handleUndefinedEntity(r2 + " is not a known property");
            return false;
        }
        if (!role1.isObjectRole() || !role2.isObjectRole()) {
            return false;
        }
        if (role1.getInverse().equals(role2)) {
            return true;
        }
        this.ensureConsistency();
        ATermAppl c = ATermUtils.makeTermAppl("_C_");
        ATermAppl notC = ATermUtils.makeNot(c);
        ATermAppl test = ATermUtils.makeAnd(c, ATermUtils.makeOr(ATermUtils.makeSomeValues(r1, ATermUtils.makeAllValues(r2, notC)), ATermUtils.makeSomeValues(r2, ATermUtils.makeAllValues(r1, notC))));
        return !this.abox.isSatisfiable(test);
    }

    public boolean hasDomain(ATermAppl p, ATermAppl c) {
        Role r = this.rbox.getRole(p);
        if (r == null) {
            KnowledgeBase.handleUndefinedEntity(p + " is not a property!");
            return false;
        }
        if (!this.isClass(c)) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a valid class expression");
            return false;
        }
        ATermAppl someP = ATermUtils.makeSomeValues(p, ATermUtils.getTop(r));
        return this.isSubClassOf(someP, c);
    }

    public boolean hasRange(ATermAppl p, ATermAppl c) {
        if (!this.isClass(c) && !this.isDatatype(c)) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a valid class expression");
            return false;
        }
        ATermAppl allValues = ATermUtils.makeAllValues(p, c);
        return this.isSubClassOf(ATermUtils.TOP, allValues);
    }

    public boolean isDatatype(ATermAppl c) {
        return this.datatypeVisitor.isDatatype(c);
    }

    public boolean isSatisfiable(ATermAppl c) {
        Bool equivToBottom;
        this.ensureConsistency();
        if (!this.isClass(c)) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a known class!");
            return false;
        }
        c = ATermUtils.normalize(c);
        if (this.isClassified() && !this.doExplanation() && (equivToBottom = this.builder.getTaxonomy().isEquivalent(ATermUtils.BOTTOM, c)).isKnown()) {
            return equivToBottom.isFalse();
        }
        return this.abox.isSatisfiable(c);
    }

    public boolean hasInstance(ATerm d) {
        if (!this.isClass(d)) {
            KnowledgeBase.handleUndefinedEntity(d + " is not a class!");
            return false;
        }
        this.ensureConsistency();
        ATermAppl c = ATermUtils.normalize((ATermAppl)d);
        ArrayList<ATermAppl> unknowns = new ArrayList<ATermAppl>();
        IndividualIterator i = new IndividualIterator(this.abox);
        while (i.hasNext()) {
            ATermAppl x = ((Individual)i.next()).getName();
            Bool knownType = this.abox.isKnownType(x, c);
            if (knownType.isTrue()) {
                return true;
            }
            if (!knownType.isUnknown()) continue;
            unknowns.add(x);
        }
        boolean hasInstance = !unknowns.isEmpty() && this.abox.isType(unknowns, c);
        return hasInstance;
    }

    public boolean isSubClassOf(ATermAppl c1, ATermAppl c2) {
        Bool isSubNode;
        this.ensureConsistency();
        if (!this.isClass(c1)) {
            KnowledgeBase.handleUndefinedEntity(c1 + " is not a known class");
            return false;
        }
        if (!this.isClass(c2)) {
            KnowledgeBase.handleUndefinedEntity(c2 + " is not a known class");
            return false;
        }
        if (c1.equals(c2)) {
            return true;
        }
        c1 = ATermUtils.normalize(c1);
        c2 = ATermUtils.normalize(c2);
        if (this.isClassified() && !this.doExplanation() && (isSubNode = this.builder.getTaxonomy().isSubNodeOf(c1, c2)).isKnown()) {
            return isSubNode.isTrue();
        }
        return this.abox.isSubClassOf(c1, c2);
    }

    public boolean isEquivalentClass(ATermAppl c1, ATermAppl c2) {
        ATermAppl c2NotC1;
        this.ensureConsistency();
        if (!this.isClass(c1)) {
            KnowledgeBase.handleUndefinedEntity(c1 + " is not a known class");
            return false;
        }
        if (!this.isClass(c2)) {
            KnowledgeBase.handleUndefinedEntity(c2 + " is not a known class");
            return false;
        }
        if (c1.equals(c2)) {
            return true;
        }
        c1 = ATermUtils.normalize(c1);
        c2 = ATermUtils.normalize(c2);
        if (!this.doExplanation()) {
            Bool isEquivalent = Bool.UNKNOWN;
            if (this.isClassified()) {
                isEquivalent = this.builder.getTaxonomy().isEquivalent(c1, c2);
            }
            if (isEquivalent.isUnknown()) {
                isEquivalent = this.abox.isKnownSubClassOf(c1, c2).and(this.abox.isKnownSubClassOf(c2, c1));
            }
            if (isEquivalent.isKnown()) {
                return isEquivalent.isTrue();
            }
        }
        ATermAppl notC2 = ATermUtils.negate(c2);
        ATermAppl notC1 = ATermUtils.negate(c1);
        ATermAppl c1NotC2 = ATermUtils.makeAnd(c1, notC2);
        ATermAppl test = ATermUtils.makeOr(c1NotC2, c2NotC1 = ATermUtils.makeAnd(c2, notC1));
        return !this.isSatisfiable(test);
    }

    public boolean isDisjoint(ATermAppl c1, ATermAppl c2) {
        if (this.isClass(c1) && this.isClass(c2)) {
            return this.isDisjointClass(c1, c2);
        }
        if (this.isProperty(c1) && this.isProperty(c2)) {
            return this.isDisjointProperty(c1, c2);
        }
        return false;
    }

    public boolean isDisjointClass(ATermAppl c1, ATermAppl c2) {
        ATermAppl notC2 = ATermUtils.makeNot(c2);
        return this.isSubClassOf(c1, notC2);
    }

    public boolean isDisjointProperty(ATermAppl r1, ATermAppl r2) {
        Role role1 = this.getRole(r1);
        Role role2 = this.getRole(r2);
        if (role1 == null) {
            KnowledgeBase.handleUndefinedEntity(r1 + " is not a known property");
            return false;
        }
        if (role2 == null) {
            KnowledgeBase.handleUndefinedEntity(r2 + " is not a known property");
            return false;
        }
        if (role1.getType() != role2.getType()) {
            return false;
        }
        if (role1.isBottom() || role2.isBottom()) {
            if (this.doExplanation()) {
                this.abox.setExplanation(DependencySet.INDEPENDENT);
            }
            return true;
        }
        if (role1.isTop() || role2.isTop()) {
            return false;
        }
        if (role1.getDisjointRoles().contains(role2) && !this.doExplanation()) {
            return true;
        }
        this.ensureConsistency();
        ATermAppl top = ATermUtils.getTop(role1);
        ATermAppl topRole = role1.isObjectRole() ? TermFactory.TOP_OBJECT_PROPERTY : TermFactory.TOP_DATA_PROPERTY;
        ATermAppl test = TermFactory.and(TermFactory.some(r1, top), TermFactory.some(r2, top), TermFactory.max(topRole, 1, top));
        return !this.abox.isSatisfiable(test);
    }

    public boolean isComplement(ATermAppl c1, ATermAppl c2) {
        ATermAppl notC2 = ATermUtils.makeNot(c2);
        return this.isEquivalentClass(c1, notC2);
    }

    public Bool isKnownType(ATermAppl x, ATermAppl c) {
        this.ensureConsistency();
        if (!this.isIndividual(x)) {
            KnowledgeBase.handleUndefinedEntity(x + " is not an individual!");
            return Bool.FALSE;
        }
        if (!this.isClass(c)) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a valid class expression");
            return Bool.FALSE;
        }
        c = ATermUtils.normalize(c);
        return this.abox.isKnownType(x, c);
    }

    public boolean isType(ATermAppl x, ATermAppl c) {
        this.ensureConsistency();
        if (!this.isIndividual(x)) {
            KnowledgeBase.handleUndefinedEntity(x + " is not an individual!");
            return false;
        }
        if (!this.isClass(c)) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a valid class expression");
            return false;
        }
        if (this.isRealized() && !this.doExplanation()) {
            if (this.builder == null) {
                throw new NullPointerException("Builder is null");
            }
            Taxonomy<ATermAppl> taxonomy = this.builder.getTaxonomy();
            if (taxonomy == null) {
                throw new NullPointerException("Taxonomy is null");
            }
            if (taxonomy.contains(c)) {
                return TaxonomyUtils.isType(taxonomy, x, c);
            }
        }
        return this.abox.isType(x, c);
    }

    public boolean isSameAs(ATermAppl t1, ATermAppl t2) {
        this.ensureConsistency();
        if (!this.isIndividual(t1)) {
            KnowledgeBase.handleUndefinedEntity(t1 + " is not an individual!");
            return false;
        }
        if (!this.isIndividual(t2)) {
            KnowledgeBase.handleUndefinedEntity(t2 + " is not an individual!");
            return false;
        }
        if (t1.equals(t2)) {
            return true;
        }
        HashSet<ATermAppl> knowns = new HashSet<ATermAppl>();
        HashSet<ATermAppl> unknowns = new HashSet<ATermAppl>();
        Individual ind = this.abox.getIndividual(t1);
        if (ind.isMerged() && !ind.getMergeDependency(true).isIndependent()) {
            this.abox.getSames(ind.getSame(), unknowns, unknowns);
        } else {
            this.abox.getSames(ind.getSame(), knowns, unknowns);
        }
        if (knowns.contains(t2)) {
            if (!this.doExplanation()) {
                return true;
            }
        } else if (!unknowns.contains(t2)) {
            return false;
        }
        return this.abox.isSameAs(t1, t2);
    }

    public boolean isDifferentFrom(ATermAppl t1, ATermAppl t2) {
        Individual ind1 = this.abox.getIndividual(t1);
        Individual ind2 = this.abox.getIndividual(t2);
        if (ind1 == null) {
            KnowledgeBase.handleUndefinedEntity(t1 + " is not an individual!");
            return false;
        }
        if (ind2 == null) {
            KnowledgeBase.handleUndefinedEntity(t2 + " is not an individual!");
            return false;
        }
        if (ind1.isDifferent(ind2) && !this.doExplanation()) {
            return true;
        }
        ATermAppl c = ATermUtils.makeNot(ATermUtils.makeValue(t2));
        return this.isType(t1, c);
    }

    public Set<ATermAppl> getDifferents(ATermAppl name) {
        Individual ind = this.abox.getIndividual(name);
        if (ind == null) {
            KnowledgeBase.handleUndefinedEntity(name + " is not an individual!");
            return Collections.emptySet();
        }
        ATermAppl c = ATermUtils.makeNot(ATermUtils.makeValue(name));
        HashSet<ATermAppl> differents = new HashSet<ATermAppl>();
        for (ATermAppl x : this.individuals) {
            Bool isType = this.abox.isKnownType(x, c);
            if (isType.isTrue()) {
                differents.add(x);
                continue;
            }
            if (!isType.isUnknown() || !this.isType(x, c)) continue;
            differents.add(x);
        }
        return differents;
    }

    public boolean hasPropertyValue(ATermAppl s, ATermAppl p, ATermAppl o) {
        this.ensureConsistency();
        if (!this.isIndividual(s)) {
            KnowledgeBase.handleUndefinedEntity(s + " is not an individual!");
            return false;
        }
        if (!this.isProperty(p)) {
            KnowledgeBase.handleUndefinedEntity(p + " is not a known property!");
            return false;
        }
        if (o != null && (this.isDatatypeProperty(p) ? !ATermUtils.isLiteral(o) : !this.isIndividual(o))) {
            return false;
        }
        return this.abox.hasPropertyValue(s, p, o);
    }

    public Bool hasKnownPropertyValue(ATermAppl s, ATermAppl p, ATermAppl o) {
        this.ensureConsistency();
        return this.abox.hasObviousPropertyValue(s, p, o);
    }

    public ABox getABox() {
        return this.abox;
    }

    public RBox getRBox() {
        return this.rbox;
    }

    public TBox getTBox() {
        return this.tbox;
    }

    public DatatypeReasoner getDatatypeReasoner() {
        return this.abox.getDatatypeReasoner();
    }

    public Set<Set<ATermAppl>> getSuperClasses(ATermAppl c, boolean direct) {
        if (!this.isClass(c)) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a class!");
            return Collections.emptySet();
        }
        c = ATermUtils.normalize(c);
        this.classify();
        Taxonomy<ATermAppl> taxonomy = this.builder.getTaxonomy();
        if (!taxonomy.contains(c)) {
            this.builder.classify(c);
        }
        HashSet<Set<ATermAppl>> supers = new HashSet<Set<ATermAppl>>();
        for (Set<ATermAppl> s : taxonomy.getSupers(c, direct)) {
            Set<ATermAppl> supEqSet = ATermUtils.primitiveOrBottom(s);
            if (supEqSet.isEmpty()) continue;
            supers.add(supEqSet);
        }
        return supers;
    }

    public Set<Set<ATermAppl>> getSubClasses(ATermAppl c) {
        return this.getSubClasses(c, false);
    }

    public Set<Set<ATermAppl>> getDisjoints(ATermAppl c) {
        if (this.isClass(c)) {
            return this.getDisjointClasses(c);
        }
        if (this.isProperty(c)) {
            return this.getDisjointProperties(c);
        }
        KnowledgeBase.handleUndefinedEntity(c + " is not a property nor a class!");
        return Collections.emptySet();
    }

    public Set<Set<ATermAppl>> getDisjointClasses(ATermAppl c) {
        return this.getDisjointClasses(c, false);
    }

    public Set<Set<ATermAppl>> getDisjointClasses(ATermAppl c, boolean direct) {
        if (!this.isClass(c)) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a class!");
            return Collections.emptySet();
        }
        ATermAppl notC = ATermUtils.normalize(ATermUtils.makeNot(c));
        Set<ATermAppl> complements = this.getAllEquivalentClasses(notC);
        if (notC.equals(ATermUtils.BOTTOM)) {
            complements.add(ATermUtils.BOTTOM);
        }
        if (direct && !complements.isEmpty()) {
            return Collections.singleton(complements);
        }
        Set<Set<ATermAppl>> disjoints = this.getSubClasses(notC, direct);
        if (!complements.isEmpty()) {
            disjoints.add(complements);
        }
        return disjoints;
    }

    public Set<Set<ATermAppl>> getDisjointProperties(ATermAppl p) {
        return this.getDisjointProperties(p, false);
    }

    public Set<Set<ATermAppl>> getDisjointProperties(ATermAppl p, boolean direct) {
        if (!this.isProperty(p)) {
            KnowledgeBase.handleUndefinedEntity(p + " is not a property!");
            return Collections.emptySet();
        }
        Role role = this.rbox.getRole(p);
        if (!role.isObjectRole() && !role.isDatatypeRole()) {
            return Collections.emptySet();
        }
        HashSet<Set<ATermAppl>> disjoints = new HashSet<Set<ATermAppl>>();
        TaxonomyNode node = this.getRoleTaxonomy(role.isObjectRole()).getTop();
        HashSet<TaxonomyNode<ATermAppl>> marked = new HashSet<TaxonomyNode<ATermAppl>>();
        ArrayList visit = new ArrayList();
        visit.add(node);
        for (int i = 0; i < visit.size(); ++i) {
            node = (TaxonomyNode)visit.get(i);
            if (node.isHidden() || node.getEquivalents().isEmpty() || marked.contains(node)) continue;
            ATermAppl r = (ATermAppl)node.getName();
            if (this.isDisjointProperty(p, r)) {
                Set<ATermAppl> eqs = this.getAllEquivalentProperties(r);
                if (!eqs.isEmpty()) {
                    disjoints.add(eqs);
                }
                if (direct) {
                    this.mark(node, marked);
                    continue;
                }
                disjoints.addAll(this.getSubProperties(r));
                continue;
            }
            visit.addAll(node.getSubs());
        }
        return disjoints;
    }

    private void mark(TaxonomyNode<ATermAppl> node, Set<TaxonomyNode<ATermAppl>> marked) {
        marked.add(node);
        for (TaxonomyNode<ATermAppl> next : node.getSubs()) {
            this.mark(next, marked);
        }
    }

    public Set<ATermAppl> getComplements(ATermAppl c) {
        if (!this.isClass(c)) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a class!");
            return Collections.emptySet();
        }
        ATermAppl notC = ATermUtils.normalize(ATermUtils.makeNot(c));
        Set<ATermAppl> complements = this.getAllEquivalentClasses(notC);
        if (notC.equals(ATermUtils.BOTTOM)) {
            complements.add(ATermUtils.BOTTOM);
        }
        return complements;
    }

    public Set<Set<ATermAppl>> getTypes(ATermAppl ind, boolean direct) {
        if (!this.isIndividual(ind)) {
            KnowledgeBase.handleUndefinedEntity(ind + " is not an individual!");
            return Collections.emptySet();
        }
        this.realize();
        HashSet<Set<ATermAppl>> types = new HashSet<Set<ATermAppl>>();
        for (Set<ATermAppl> t : TaxonomyUtils.getTypes(this.builder.getTaxonomy(), ind, direct)) {
            Set<ATermAppl> eqSet = ATermUtils.primitiveOrBottom(t);
            if (eqSet.isEmpty()) continue;
            types.add(eqSet);
        }
        return types;
    }

    public Set<Set<ATermAppl>> getTypes(ATermAppl ind) {
        return this.getTypes(ind, false);
    }

    public ATermAppl getType(ATermAppl ind) {
        if (!this.isIndividual(ind)) {
            KnowledgeBase.handleUndefinedEntity(ind + " is not an individual!");
            return null;
        }
        return this.abox.getIndividual(ind).getTypes(0).iterator().next();
    }

    public ATermAppl getType(ATermAppl ind, boolean direct) {
        if (!this.isIndividual(ind)) {
            KnowledgeBase.handleUndefinedEntity(ind + " is not an individual!");
            return null;
        }
        this.realize();
        for (Set<ATermAppl> t : TaxonomyUtils.getTypes(this.builder.getTaxonomy(), ind, direct)) {
            Set<ATermAppl> eqSet = ATermUtils.primitiveOrBottom(t);
            if (eqSet.isEmpty()) continue;
            return eqSet.iterator().next();
        }
        return null;
    }

    public Set<ATermAppl> getInstances(ATermAppl c) {
        if (!this.isClass(c)) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a class!");
            return Collections.emptySet();
        }
        if (this.instances.containsKey(c)) {
            return this.instances.get(c);
        }
        if (this.isRealized()) {
            if (this.builder == null) {
                throw new NullPointerException("Builder is null");
            }
            Taxonomy<ATermAppl> taxonomy = this.builder.getTaxonomy();
            if (taxonomy == null) {
                throw new NullPointerException("Taxonomy is null");
            }
            if (taxonomy.contains(c) && ATermUtils.isPrimitive(c)) {
                return TaxonomyUtils.getAllInstances(taxonomy, c);
            }
        }
        return new HashSet<ATermAppl>(this.retrieve(c, this.individuals));
    }

    public Set<ATermAppl> getInstances(ATermAppl c, boolean direct) {
        if (!this.isClass(c)) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a class!");
            return Collections.emptySet();
        }
        if (!direct) {
            return this.getInstances(c);
        }
        this.realize();
        if (this.builder == null) {
            throw new NullPointerException("Builder is null");
        }
        Taxonomy<ATermAppl> taxonomy = this.builder.getTaxonomy();
        if (taxonomy == null) {
            throw new NullPointerException("Taxonomy is null");
        }
        if (ATermUtils.isPrimitive(c)) {
            return TaxonomyUtils.getDirectInstances(taxonomy, c);
        }
        if (!taxonomy.contains(c)) {
            this.builder.classify(c);
        }
        HashSet<ATermAppl> ret = new HashSet<ATermAppl>();
        Set<Set<ATermAppl>> sups = this.getSuperClasses(c, true);
        for (Set<ATermAppl> s : sups) {
            Iterator<ATermAppl> i = s.iterator();
            ATermAppl term = i.next();
            Set<ATermAppl> cand = TaxonomyUtils.getDirectInstances(taxonomy, term);
            if (ret.isEmpty()) {
                ret.addAll(cand);
            } else {
                ret.retainAll(cand);
            }
            if (!ret.isEmpty()) continue;
            return ret;
        }
        return this.retrieve(c, ret);
    }

    public Set<ATermAppl> getEquivalentClasses(ATermAppl c) {
        Set<ATermAppl> result = this.getAllEquivalentClasses(c);
        result.remove(c);
        return result;
    }

    public Set<ATermAppl> getAllEquivalentClasses(ATermAppl c) {
        if (!this.isClass(c)) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a class!");
            return Collections.emptySet();
        }
        c = ATermUtils.normalize(c);
        this.classify();
        Taxonomy<ATermAppl> taxonomy = this.builder.getTaxonomy();
        if (!taxonomy.contains(c)) {
            this.builder.classify(c);
        }
        return ATermUtils.primitiveOrBottom(taxonomy.getAllEquivalents(c));
    }

    public Set<Set<ATermAppl>> getSuperClasses(ATermAppl c) {
        return this.getSuperClasses(c, false);
    }

    public Set<Set<ATermAppl>> getSubClasses(ATermAppl c, boolean direct) {
        if (!this.isClass(c)) {
            KnowledgeBase.handleUndefinedEntity(c + " is not a class!");
            return Collections.emptySet();
        }
        c = ATermUtils.normalize(c);
        this.classify();
        Taxonomy<ATermAppl> taxonomy = this.builder.getTaxonomy();
        if (!taxonomy.contains(c)) {
            this.builder.classify(c);
        }
        HashSet<Set<ATermAppl>> subs = new HashSet<Set<ATermAppl>>();
        for (Set<ATermAppl> s : taxonomy.getSubs(c, direct)) {
            Set<ATermAppl> subEqSet = ATermUtils.primitiveOrBottom(s);
            if (subEqSet.isEmpty()) continue;
            subs.add(subEqSet);
        }
        return subs;
    }

    public Set<Set<ATermAppl>> getAllSuperProperties(ATermAppl prop) {
        if (!this.isProperty(prop)) {
            KnowledgeBase.handleUndefinedEntity(prop + " is not a property!");
            return Collections.emptySet();
        }
        Set<Set<ATermAppl>> supers = this.getSuperProperties(prop);
        supers.add(this.getAllEquivalentProperties(prop));
        return supers;
    }

    public Set<Set<ATermAppl>> getSuperProperties(ATermAppl prop) {
        return this.getSuperProperties(prop, false);
    }

    public Set<Set<ATermAppl>> getSuperProperties(ATermAppl prop, boolean direct) {
        if (!this.isProperty(prop)) {
            KnowledgeBase.handleUndefinedEntity(prop + " is not a property!");
            return Collections.emptySet();
        }
        HashSet<Set<ATermAppl>> supers = new HashSet<Set<ATermAppl>>();
        for (Set<ATermAppl> s : this.getRoleTaxonomy(prop).getSupers(prop, direct)) {
            Set<ATermAppl> supEqSet = ATermUtils.primitiveOrBottom(s);
            if (supEqSet.isEmpty()) continue;
            supers.add(supEqSet);
        }
        return supers;
    }

    public Set<Set<ATermAppl>> getAllSubProperties(ATermAppl prop) {
        if (!this.isProperty(prop)) {
            KnowledgeBase.handleUndefinedEntity(prop + " is not a property!");
            return Collections.emptySet();
        }
        Set<Set<ATermAppl>> subs = this.getSubProperties(prop);
        subs.add(this.getAllEquivalentProperties(prop));
        return subs;
    }

    public Set<Set<ATermAppl>> getSubProperties(ATermAppl prop) {
        return this.getSubProperties(prop, false);
    }

    public Set<Set<ATermAppl>> getSubProperties(ATermAppl prop, boolean direct) {
        if (!this.isProperty(prop)) {
            KnowledgeBase.handleUndefinedEntity(prop + " is not a property!");
            return Collections.emptySet();
        }
        HashSet<Set<ATermAppl>> subs = new HashSet<Set<ATermAppl>>();
        for (Set<ATermAppl> s : this.getRoleTaxonomy(prop).getSubs(prop, direct)) {
            Set<ATermAppl> subEqSet = ATermUtils.primitiveOrBottom(s);
            if (subEqSet.isEmpty()) continue;
            subs.add(subEqSet);
        }
        return subs;
    }

    public Set<ATermAppl> getEquivalentProperties(ATermAppl prop) {
        if (!this.isProperty(prop)) {
            KnowledgeBase.handleUndefinedEntity(prop + " is not a property!");
            return Collections.emptySet();
        }
        return ATermUtils.primitiveOrBottom(this.getRoleTaxonomy(prop).getEquivalents(prop));
    }

    public Set<ATermAppl> getAllEquivalentProperties(ATermAppl prop) {
        if (!this.isProperty(prop)) {
            KnowledgeBase.handleUndefinedEntity(prop + " is not a property!");
            return Collections.emptySet();
        }
        return ATermUtils.primitiveOrBottom(this.getRoleTaxonomy(prop).getAllEquivalents(prop));
    }

    public Set<ATermAppl> getInverses(ATerm name) {
        ATermAppl invR = this.getInverse(name);
        if (invR != null) {
            Set<ATermAppl> inverses = this.getAllEquivalentProperties(invR);
            return inverses;
        }
        return Collections.emptySet();
    }

    public ATermAppl getInverse(ATerm name) {
        Role prop = this.rbox.getRole(name);
        if (prop == null) {
            KnowledgeBase.handleUndefinedEntity(name + " is not a property!");
            return null;
        }
        Role invProp = prop.getInverse();
        return invProp != null ? invProp.getName() : null;
    }

    public Set<ATermAppl> getDomains(ATermAppl name) {
        this.ensureConsistency();
        Role prop = this.rbox.getRole(name);
        if (prop == null) {
            KnowledgeBase.handleUndefinedEntity(name + " is not a property!");
            return Collections.emptySet();
        }
        return ATermUtils.primitiveOrBottom(prop.getDomains());
    }

    public Set<ATermAppl> getRanges(ATerm name) {
        this.ensureConsistency();
        Set<ATermAppl> set = Collections.emptySet();
        Role prop = this.rbox.getRole(name);
        if (prop == null) {
            KnowledgeBase.handleUndefinedEntity(name + " is not a property!");
            return set;
        }
        return ATermUtils.primitiveOrBottom(prop.getRanges());
    }

    public Set<ATermAppl> getAllSames(ATermAppl name) {
        this.ensureConsistency();
        HashSet<ATermAppl> knowns = new HashSet<ATermAppl>();
        HashSet<ATermAppl> unknowns = new HashSet<ATermAppl>();
        Individual ind = this.abox.getIndividual(name);
        if (ind == null) {
            KnowledgeBase.handleUndefinedEntity(name + " is not an individual!");
            return Collections.emptySet();
        }
        if (ind.isMerged() && !ind.getMergeDependency(true).isIndependent()) {
            knowns.add(name);
            this.abox.getSames(ind.getSame(), unknowns, unknowns);
            unknowns.remove(name);
        } else {
            this.abox.getSames(ind.getSame(), knowns, unknowns);
        }
        for (ATermAppl other : unknowns) {
            if (!this.abox.isSameAs(name, other)) continue;
            knowns.add(other);
        }
        return knowns;
    }

    public Set<ATermAppl> getSames(ATermAppl name) {
        Set<ATermAppl> sames = this.getAllSames(name);
        sames.remove(name);
        return sames;
    }

    public List<ATermAppl> getDataPropertyValues(ATermAppl r, ATermAppl x, ATermAppl datatype) {
        this.ensureConsistency();
        Individual ind = this.abox.getIndividual(x);
        Role role = this.rbox.getRole(r);
        if (ind == null) {
            KnowledgeBase.handleUndefinedEntity(x + " is not an individual!");
            return Collections.emptyList();
        }
        if (role == null || !role.isDatatypeRole()) {
            KnowledgeBase.handleUndefinedEntity(r + " is not a known data property!");
            return Collections.emptyList();
        }
        if (role.isTop()) {
            ArrayList<ATermAppl> literals = new ArrayList<ATermAppl>();
            if (!PelletOptions.HIDE_TOP_PROPERTY_VALUES) {
                for (Node node : this.abox.getNodes()) {
                    if (!node.isLiteral() || node.getTerm() == null) continue;
                    literals.add(node.getTerm());
                }
            }
            return literals;
        }
        if (role.isBottom()) {
            return Collections.emptyList();
        }
        return this.abox.getDataPropertyValues(x, role, datatype);
    }

    public List<ATermAppl> getDataPropertyValues(ATermAppl r, ATermAppl x, String lang) {
        List<ATermAppl> values = this.getDataPropertyValues(r, x);
        if (lang == null) {
            return values;
        }
        ArrayList<ATermAppl> result = new ArrayList<ATermAppl>();
        for (ATermAppl lit : values) {
            String litLang = ((ATermAppl)lit.getArgument(1)).getName();
            if (!litLang.equals(lang)) continue;
            result.add(lit);
        }
        return result;
    }

    public List<ATermAppl> getDataPropertyValues(ATermAppl r, ATermAppl x) {
        return this.getDataPropertyValues(r, x, (ATermAppl)null);
    }

    public List<ATermAppl> getObjectPropertyValues(ATermAppl r, ATermAppl x) {
        this.ensureConsistency();
        Role role = this.rbox.getRole(r);
        if (role == null || !role.isObjectRole()) {
            KnowledgeBase.handleUndefinedEntity(r + " is not a known object property!");
            return Collections.emptyList();
        }
        if (!this.isIndividual(x)) {
            KnowledgeBase.handleUndefinedEntity(x + " is not a known individual!");
            return Collections.emptyList();
        }
        HashSet<ATermAppl> knowns = new HashSet();
        HashSet<ATermAppl> unknowns = new HashSet<ATermAppl>();
        if (role.isTop()) {
            if (!PelletOptions.HIDE_TOP_PROPERTY_VALUES) {
                knowns = this.getIndividuals();
            }
        } else if (!role.isBottom()) {
            this.abox.getObjectPropertyValues(x, role, knowns, unknowns, true);
        }
        if (!unknowns.isEmpty()) {
            ATermAppl valueX = ATermUtils.makeHasValue(role.getInverse().getName(), x);
            ATermAppl c = ATermUtils.normalize(valueX);
            this.binaryInstanceRetrieval(c, new ArrayList<ATermAppl>(unknowns), knowns);
        }
        return new ArrayList<ATermAppl>(knowns);
    }

    public List<ATermAppl> getPropertyValues(ATermAppl r, ATermAppl x) {
        Role role = this.rbox.getRole(r);
        if (role == null || role.isUntypedRole()) {
            KnowledgeBase.handleUndefinedEntity(r + " is not a known property!");
            return Collections.emptyList();
        }
        if (role.isObjectRole()) {
            return this.getObjectPropertyValues(r, x);
        }
        if (role.isDatatypeRole()) {
            return this.getDataPropertyValues(r, x);
        }
        if (role.isAnnotationRole()) {
            Set<ATermAppl> values = this.getAnnotations(x, r);
            return values == null || values.isEmpty() ? Collections.emptyList() : Arrays.asList(values.toArray(new ATermAppl[0]));
        }
        throw new IllegalArgumentException();
    }

    public List<ATermAppl> getIndividualsWithProperty(ATermAppl r, ATermAppl x) {
        Role role = this.rbox.getRole(r);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(r + " is not a known property!");
            return Collections.emptyList();
        }
        if (role.isObjectRole()) {
            if (ATermUtils.isPrimitive(x)) {
                return this.getIndividualsWithObjectProperty(r, x);
            }
            return Collections.emptyList();
        }
        if (role.isDatatypeRole()) {
            if (ATermUtils.isLiteral(x)) {
                return this.getIndividualsWithDataProperty(r, x);
            }
            return Collections.emptyList();
        }
        if (role.isAnnotationRole()) {
            return Arrays.asList(this.getIndividualsWithAnnotation(r, x).toArray(new ATermAppl[0]));
        }
        throw new IllegalArgumentException();
    }

    public List<ATermAppl> getIndividualsWithDataProperty(ATermAppl r, ATermAppl litValue) {
        ATermAppl canonicalLit;
        this.ensureConsistency();
        ArrayList<ATermAppl> knowns = new ArrayList<ATermAppl>();
        ArrayList<ATermAppl> unknowns = new ArrayList<ATermAppl>();
        try {
            canonicalLit = this.getDatatypeReasoner().getCanonicalRepresentation(litValue);
        }
        catch (InvalidLiteralException e2) {
            log.warning(String.format("Invalid literal '%s' passed as input, returning empty set of individuals: %s", litValue, e2.getMessage()));
            return Collections.emptyList();
        }
        catch (UnrecognizedDatatypeException e3) {
            log.warning(String.format("Unrecognized datatype for literal '%s' passed as input, returning empty set of individuals: %s", litValue, e3.getMessage()));
            return Collections.emptyList();
        }
        Literal literal = this.abox.getLiteral(canonicalLit);
        if (literal != null) {
            Role role = this.getRole(r);
            EdgeList edges = literal.getInEdges();
            for (Edge edge : edges) {
                if (!edge.getRole().isSubRoleOf(role)) continue;
                ATermAppl subj = edge.getFrom().getName();
                if (edge.getDepends().isIndependent()) {
                    knowns.add(subj);
                    continue;
                }
                unknowns.add(subj);
            }
            if (!unknowns.isEmpty()) {
                ATermAppl c = ATermUtils.normalize(ATermUtils.makeHasValue(r, litValue));
                this.binaryInstanceRetrieval(c, unknowns, knowns);
            }
        }
        return knowns;
    }

    public List<ATermAppl> getIndividualsWithObjectProperty(ATermAppl r, ATermAppl o) {
        this.ensureConsistency();
        if (!this.isIndividual(o)) {
            KnowledgeBase.handleUndefinedEntity(o + " is not an individual!");
            return Collections.emptyList();
        }
        Role role = this.rbox.getRole(r);
        ATermAppl invR = role.getInverse().getName();
        return this.getObjectPropertyValues(invR, o);
    }

    public List<ATermAppl> getProperties(ATermAppl s, ATermAppl o) {
        if (!this.isIndividual(s)) {
            KnowledgeBase.handleUndefinedEntity(s + " is not an individual!");
            return Collections.emptyList();
        }
        if (!this.isIndividual(o)) {
            KnowledgeBase.handleUndefinedEntity(o + " is not an individual!");
            return Collections.emptyList();
        }
        ArrayList<ATermAppl> props = new ArrayList<ATermAppl>();
        Set<ATermAppl> allProps = ATermUtils.isLiteral(o) ? this.getDataProperties() : this.getObjectProperties();
        for (ATermAppl p : allProps) {
            if (!this.abox.hasPropertyValue(s, p, o)) continue;
            props.add(p);
        }
        return props;
    }

    public Map<ATermAppl, List<ATermAppl>> getPropertyValues(ATermAppl pred) {
        HashMap<ATermAppl, List<ATermAppl>> result = new HashMap<ATermAppl, List<ATermAppl>>();
        for (ATermAppl subj : this.individuals) {
            List<ATermAppl> objects = this.getPropertyValues(pred, subj);
            if (objects.isEmpty()) continue;
            result.put(subj, objects);
        }
        return result;
    }

    public Set<ATermAppl> retrieve(ATermAppl d, Collection<ATermAppl> individuals) {
        this.ensureConsistency();
        ATermAppl c = ATermUtils.normalize(d);
        Timer timer = this.timers.startTimer("retrieve");
        ATermAppl notC = ATermUtils.negate(c);
        ArrayList<ATermAppl> knowns = new ArrayList<ATermAppl>();
        if (!this.abox.isSatisfiable(notC)) {
            knowns.addAll(this.getIndividuals());
        } else if (this.abox.isSatisfiable(c)) {
            Set<ATermAppl> subs = Collections.emptySet();
            if (this.isClassified()) {
                if (this.builder == null) {
                    throw new NullPointerException("Builder is null");
                }
                Taxonomy<ATermAppl> taxonomy = this.builder.getTaxonomy();
                if (taxonomy == null) {
                    throw new NullPointerException("Taxonomy");
                }
                if (taxonomy.contains(c)) {
                    subs = taxonomy.getFlattenedSubs(c, false);
                }
            }
            ArrayList<ATermAppl> unknowns = new ArrayList<ATermAppl>();
            for (ATermAppl x : individuals) {
                Bool isType = this.abox.isKnownType(x, c, subs);
                if (isType.isTrue()) {
                    knowns.add(x);
                    continue;
                }
                if (!isType.isUnknown()) continue;
                unknowns.add(x);
            }
            if (!unknowns.isEmpty()) {
                if (PelletOptions.INSTANCE_RETRIEVAL == PelletOptions.InstanceRetrievalMethod.TRACING_BASED && PelletOptions.USE_TRACING) {
                    this.tracingBasedInstanceRetrieval(c, unknowns, knowns);
                } else if (this.abox.isType(unknowns, c)) {
                    if (PelletOptions.INSTANCE_RETRIEVAL == PelletOptions.InstanceRetrievalMethod.BINARY) {
                        this.binaryInstanceRetrieval(c, unknowns, knowns);
                    } else {
                        this.linearInstanceRetrieval(c, unknowns, knowns);
                    }
                }
            }
        }
        timer.stop();
        Set<ATermAppl> result = Collections.unmodifiableSet(new HashSet(knowns));
        if (PelletOptions.CACHE_RETRIEVAL) {
            this.instances.put(c, result);
        }
        return result;
    }

    public List<ATermAppl> retrieveIndividualsWithProperty(ATermAppl r) {
        this.ensureConsistency();
        Role role = this.rbox.getRole(r);
        if (role == null) {
            KnowledgeBase.handleUndefinedEntity(r + " is not a known property!");
            return Collections.emptyList();
        }
        ArrayList<ATermAppl> result = new ArrayList<ATermAppl>();
        for (ATermAppl ind : this.individuals) {
            if (this.abox.hasObviousPropertyValue(ind, r, null).isFalse()) continue;
            result.add(ind);
        }
        return result;
    }

    public void tracingBasedInstanceRetrieval(ATermAppl c, List<ATermAppl> candidates, Collection<ATermAppl> results) {
        boolean doExplanation = this.doExplanation();
        this.setDoExplanation(true);
        ATermAppl notC = ATermUtils.negate(c);
        block0: while (this.abox.isType(candidates, c)) {
            Set<ATermAppl> explanationSet = this.getExplanationSet();
            for (ATermAppl axiom : explanationSet) {
                ATermAppl ind;
                int index;
                if (!axiom.getAFun().equals(ATermUtils.TYPEFUN) || !((Object)axiom.getArgument(1)).equals(notC) || (index = candidates.indexOf(ind = (ATermAppl)axiom.getArgument(0))) < 0) continue;
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Filter instance " + axiom + " while retrieving " + c);
                }
                Collections.swap(candidates, index, 0);
                results.add(ind);
                candidates = candidates.subList(1, candidates.size());
                continue block0;
            }
        }
        this.setDoExplanation(doExplanation);
    }

    public void linearInstanceRetrieval(ATermAppl c, List<ATermAppl> candidates, Collection<ATermAppl> results) {
        for (ATermAppl ind : candidates) {
            if (!this.abox.isType(ind, c)) continue;
            results.add(ind);
        }
    }

    public void binaryInstanceRetrieval(ATermAppl c, List<ATermAppl> candidates, Collection<ATermAppl> results) {
        if (candidates.isEmpty()) {
            return;
        }
        List<ATermAppl>[] partitions = this.partition(candidates);
        this.partitionInstanceRetrieval(c, partitions, results);
    }

    private void partitionInstanceRetrieval(ATermAppl c, List<ATermAppl>[] partitions, Collection<ATermAppl> results) {
        if (partitions[0].size() == 1) {
            ATermAppl i = partitions[0].get(0);
            this.binaryInstanceRetrieval(c, partitions[1], results);
            if (this.abox.isType(i, c)) {
                results.add(i);
            }
        } else if (!this.abox.isType(partitions[0], c)) {
            this.binaryInstanceRetrieval(c, partitions[1], results);
        } else if (!this.abox.isType(partitions[1], c)) {
            this.binaryInstanceRetrieval(c, partitions[0], results);
        } else {
            this.binaryInstanceRetrieval(c, partitions[0], results);
            this.binaryInstanceRetrieval(c, partitions[1], results);
        }
    }

    private List<ATermAppl>[] partition(List<ATermAppl> candidates) {
        List[] partitions = new List[2];
        int n = candidates.size();
        if (n <= 1) {
            partitions[0] = candidates;
            partitions[1] = new ArrayList();
        } else {
            partitions[0] = candidates.subList(0, n / 2);
            partitions[1] = candidates.subList(n / 2, n);
        }
        return partitions;
    }

    public void printClassTree() {
        this.classify();
        new ClassTreePrinter().print(this.builder.getTaxonomy());
    }

    public void printClassTree(PrintWriter out) {
        this.classify();
        new ClassTreePrinter().print(this.builder.getTaxonomy(), out);
    }

    public boolean doExplanation() {
        return this.abox.doExplanation();
    }

    public void setDoExplanation(boolean doExplanation) {
        this.abox.setDoExplanation(doExplanation);
    }

    public String getExplanation() {
        return this.abox.getExplanation();
    }

    public void setDoDependencyAxioms(boolean doDepAxioms) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Setting DoDependencyAxioms = " + doDepAxioms);
        }
    }

    public boolean getDoDependencyAxioms() {
        return false;
    }

    public Set<ATermAppl> getExplanationSet() {
        return this.abox.getExplanationSet();
    }

    public void setRBox(RBox rbox) {
        this.rbox = rbox;
    }

    public void setTBox(TBox tbox) {
        this.tbox = tbox;
    }

    CompletionStrategy chooseStrategy(ABox abox) {
        return this.chooseStrategy(abox, this.getExpressivity());
    }

    CompletionStrategy chooseStrategy(ABox abox, Expressivity expressivity) {
        boolean conceptSatisfiability;
        boolean bl = conceptSatisfiability = abox.size() == 1 && new IndividualIterator(abox).next().isConceptRoot();
        if (this.getRules().size() > 0 && (expressivity.hasNominal() || !conceptSatisfiability)) {
            if (PelletOptions.USE_CONTINUOUS_RULES) {
                return new ContinuousRulesStrategy(abox);
            }
            return new RuleStrategy(abox);
        }
        if (PelletOptions.DEFAULT_COMPLETION_STRATEGY != null) {
            Object[] args = new Object[]{abox};
            try {
                Constructor<? extends CompletionStrategy> cons = PelletOptions.DEFAULT_COMPLETION_STRATEGY.getConstructor(ABox.class);
                return cons.newInstance(args);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new InternalReasonerException("Failed to create the default completion strategy defined in PelletOptions!");
            }
        }
        if (PelletOptions.USE_COMPLETION_STRATEGY) {
            boolean fullDatatypeReasoning;
            boolean bl2 = fullDatatypeReasoning = PelletOptions.USE_FULL_DATATYPE_REASONING && (expressivity.hasCardinalityD() || expressivity.hasKeys());
            if (!fullDatatypeReasoning) {
                if (conceptSatisfiability && !expressivity.hasInverse() && !expressivity.hasNominal()) {
                    return new EmptySRQStrategy(abox);
                }
                if (!expressivity.hasComplexSubRoles()) {
                    if (!expressivity.hasInverse()) {
                        if (expressivity.hasNominal()) {
                            if (expressivity.hasCardinalityQ()) {
                                return new SHOQStrategy(abox);
                            }
                            return new SHONStrategy(abox);
                        }
                        if (expressivity.hasCardinalityQ()) {
                            return new SHQStrategy(abox);
                        }
                        return new SHNStrategy(abox);
                    }
                    if (expressivity.hasCardinalityQ()) {
                        return new SHOIQStrategy(abox);
                    }
                    if (expressivity.hasNominal()) {
                        return new SHOINStrategy(abox);
                    }
                    return new SHINStrategy(abox);
                }
                if (!expressivity.hasInverse()) {
                    if (expressivity.hasNominal()) {
                        if (expressivity.hasCardinalityQ()) {
                            return new SROQStrategy(abox);
                        }
                        return new SRONStrategy(abox);
                    }
                    if (expressivity.hasCardinalityQ()) {
                        return new SRQStrategy(abox);
                    }
                    return new SRNStrategy(abox);
                }
                if (expressivity.hasCardinalityQ()) {
                    return new SROIQStrategy(abox);
                }
                if (expressivity.hasNominal()) {
                    return new SROINStrategy(abox);
                }
                return new SRINStrategy(abox);
            }
        }
        return new SROIQStrategy(abox);
    }

    public void setTimeout(long timeout) {
        this.timers.mainTimer.setTimeout(timeout);
    }

    public Role getRole(ATerm term) {
        return this.rbox.getRole(term);
    }

    public Taxonomy<ATermAppl> getTaxonomy() {
        this.classify();
        return this.builder.getTaxonomy();
    }

    public TaxonomyBuilder getTaxonomyBuilder() {
        if (this.builder == null) {
            this.prepare();
            this.builder = this.expChecker.getExpressivity().isEL() ? new SimplifiedELClassifier() : new CDOptimizedTaxonomyBuilder();
            this.builder.setKB(this);
            if (this.builderProgressMonitor != null) {
                this.builder.setProgressMonitor(this.builderProgressMonitor);
            }
        }
        return this.builder;
    }

    public void setTaxonomyBuilderProgressMonitor(ProgressMonitor progressMonitor) {
        this.builderProgressMonitor = progressMonitor;
        if (this.builder != null) {
            this.builder.setProgressMonitor(progressMonitor);
        }
    }

    public Taxonomy<ATermAppl> getRoleTaxonomy(boolean objectTaxonomy) {
        this.prepare();
        return objectTaxonomy ? this.rbox.getObjectTaxonomy() : this.rbox.getDataTaxonomy();
    }

    public Taxonomy<ATermAppl> getRoleTaxonomy(ATermAppl r) {
        this.prepare();
        return this.isObjectProperty(r) ? this.rbox.getObjectTaxonomy() : this.rbox.getDataTaxonomy();
    }

    public SizeEstimate getSizeEstimate() {
        return this.estimate;
    }

    public boolean addRule(Rule rule) {
        this.changes.add(ChangeType.ABOX_ADD);
        this.rules.put(rule, this.normalize(rule));
        if (log.isLoggable(Level.FINER)) {
            log.finer("rule " + rule);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private Rule normalize(Rule rule) {
        if (!UsableRuleFilter.isUsable(rule)) {
            return null;
        }
        LinkedHashSet<void> head = new LinkedHashSet<void>();
        LinkedHashSet<void> body = new LinkedHashSet<void>();
        for (RuleAtom ruleAtom : rule.getHead()) {
            void var5_5;
            if (ruleAtom instanceof ClassAtom) {
                ATermAppl normC;
                ClassAtom classAtom = (ClassAtom)ruleAtom;
                AtomIObject arg = (AtomIObject)classAtom.getArgument();
                ATermAppl c = (ATermAppl)classAtom.getPredicate();
                if (c != (normC = ATermUtils.normalize(c))) {
                    ClassAtom classAtom2 = new ClassAtom(normC, arg);
                }
            }
            head.add(var5_5);
        }
        HashMap types = new HashMap();
        for (RuleAtom ruleAtom : rule.getBody()) {
            Set<ATermAppl> ranges;
            AtomIObject obj;
            Set<ATermAppl> domains;
            if (!(ruleAtom instanceof IndividualPropertyAtom)) continue;
            IndividualPropertyAtom propAtom = (IndividualPropertyAtom)ruleAtom;
            ATermAppl prop = (ATermAppl)propAtom.getPredicate();
            AtomIObject subj = (AtomIObject)propAtom.getArgument1();
            if (subj instanceof AtomIVariable && (domains = this.getRole(prop).getDomains()) != null) {
                MultiMapUtils.addAll(types, subj, domains);
            }
            if (!((obj = (AtomIObject)propAtom.getArgument2()) instanceof AtomIVariable) || (ranges = this.getRole(prop).getRanges()) == null) continue;
            MultiMapUtils.addAll(types, obj, ranges);
        }
        for (RuleAtom ruleAtom : rule.getBody()) {
            void var6_16;
            if (ruleAtom instanceof ClassAtom) {
                ATermAppl c;
                ATermAppl normC;
                ClassAtom ca = (ClassAtom)ruleAtom;
                AtomIObject arg = (AtomIObject)ca.getArgument();
                if (MultiMapUtils.contains(types, arg, normC = ATermUtils.normalize(c = (ATermAppl)ca.getPredicate()))) continue;
                if (c != normC) {
                    ClassAtom classAtom = new ClassAtom(normC, (AtomIObject)ca.getArgument());
                }
            }
            body.add(var6_16);
        }
        return new Rule(rule.getName(), head, body);
    }

    public Set<Rule> getRules() {
        return this.rules.keySet();
    }

    public Map<Rule, Rule> getNormalizedRules() {
        return this.rules;
    }

    protected boolean canUseIncConsistency() {
        Expressivity expressivity = this.expChecker.getExpressivity();
        if (expressivity == null) {
            return false;
        }
        boolean canUseIncConsistency = !(expressivity.hasNominal() && expressivity.hasInverse() || !this.getRules().isEmpty() || this.isTBoxChanged() || this.isRBoxChanged() || !this.abox.isComplete() || !PelletOptions.USE_INCREMENTAL_CONSISTENCY || this.changes.contains((Object)ChangeType.ABOX_DEL) && !PelletOptions.USE_INCREMENTAL_DELETION);
        return canUseIncConsistency;
    }

    public void ensureIncConsistency(boolean aboxDeletion) {
        if (this.canUseIncConsistency()) {
            return;
        }
        Expressivity expressivity = this.expChecker.getExpressivity();
        String msg = "ABox " + (aboxDeletion ? "deletion" : "addition") + " failed because ";
        msg = expressivity == null ? msg + "an initial consistency check has not been performed on this KB" : (expressivity.hasNominal() ? msg + "KB has nominals" : (expressivity.hasInverse() ? msg + "KB has inverse properties" : (this.isTBoxChanged() ? msg + "TBox changed" : (this.isRBoxChanged() ? msg + "RBox changed" : (PelletOptions.USE_INCREMENTAL_CONSISTENCY ? msg + "configuration option USE_INCREMENTAL_CONSISTENCY is not enabled" : (aboxDeletion ? msg + "configuration option USE_INCREMENTAL_DELETION is not enabled" : msg + "of an unknown reason"))))));
        throw new UnsupportedOperationException(msg);
    }

    public DependencyIndex getDependencyIndex() {
        return this.dependencyIndex;
    }

    public Set<ATermAppl> getSyntacticAssertions() {
        return this.syntacticAssertions;
    }

    protected static void handleUndefinedEntity(String s) {
        if (!PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
            throw new UndefinedEntityException(s);
        }
    }

    public Set<ATermAppl> getABoxAssertions(AssertionType assertionType) {
        Set assertions = (Set)this.aboxAssertions.get((Object)assertionType);
        if (assertions == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(assertions);
    }

    public Set<ATermAppl> getAboxMembershipAssertions() {
        return this.getABoxAssertions(AssertionType.TYPE);
    }

    public Set<ATermAppl> getAboxObjectRoleAssertions() {
        return this.getABoxAssertions(AssertionType.OBJ_ROLE);
    }

    public Set<ATermAppl> getAboxDataRoleAssertions() {
        return this.getABoxAssertions(AssertionType.DATA_ROLE);
    }

    public Set<ATermAppl> getDeletedAssertions() {
        return this.deletedAssertions;
    }

    public boolean isExplainOnlyInconsistency() {
        return this.explainOnlyInconsistency;
    }

    public void setExplainOnlyInconsistency(boolean explainOnlyInconsistency) {
        this.explainOnlyInconsistency = explainOnlyInconsistency;
    }

    class FullyDefinedClassVisitor
    extends ATermBaseVisitor {
        private boolean fullyDefined = true;

        FullyDefinedClassVisitor() {
        }

        public boolean isFullyDefined(ATermAppl term) {
            this.fullyDefined = true;
            this.visit(term);
            return this.fullyDefined;
        }

        private void visitQCR(ATermAppl term) {
            ATermAppl q;
            this.visitRestr(term);
            if (this.fullyDefined && !KnowledgeBase.this.isDatatype(q = (ATermAppl)term.getArgument(2))) {
                this.visit(q);
            }
        }

        private void visitQR(ATermAppl term) {
            ATermAppl q;
            this.visitRestr(term);
            if (this.fullyDefined && !KnowledgeBase.this.isDatatype(q = (ATermAppl)term.getArgument(1))) {
                this.visit(q);
            }
        }

        private void visitRestr(ATermAppl term) {
            this.fullyDefined = this.fullyDefined && KnowledgeBase.this.isProperty(term.getArgument(0));
        }

        public void visit(ATermAppl term) {
            if (term.equals(ATermUtils.TOP) || term.equals(ATermUtils.BOTTOM) || term.equals(ATermUtils.TOP_LIT) || term.equals(ATermUtils.BOTTOM_LIT)) {
                return;
            }
            super.visit(term);
        }

        public void visitAll(ATermAppl term) {
            this.visitQR(term);
        }

        public void visitAnd(ATermAppl term) {
            if (this.fullyDefined) {
                this.visitList((ATermList)term.getArgument(0));
            }
        }

        public void visitCard(ATermAppl term) {
            this.visitQCR(term);
        }

        public void visitHasValue(ATermAppl term) {
            this.visitQR(term);
        }

        public void visitLiteral(ATermAppl term) {
        }

        public void visitMax(ATermAppl term) {
            this.visitQCR(term);
        }

        public void visitMin(ATermAppl term) {
            this.visitQCR(term);
        }

        public void visitNot(ATermAppl term) {
            this.visit((ATermAppl)term.getArgument(0));
        }

        public void visitOneOf(ATermAppl term) {
            if (this.fullyDefined) {
                this.visitList((ATermList)term.getArgument(0));
            }
        }

        public void visitOr(ATermAppl term) {
            if (this.fullyDefined) {
                this.visitList((ATermList)term.getArgument(0));
            }
        }

        public void visitSelf(ATermAppl term) {
            this.visitRestr(term);
        }

        public void visitSome(ATermAppl term) {
            this.visitQR(term);
        }

        public void visitTerm(ATermAppl term) {
            boolean bl = this.fullyDefined = this.fullyDefined && KnowledgeBase.this.tbox.getClasses().contains(term);
            if (!this.fullyDefined) {
                return;
            }
        }

        public void visitValue(ATermAppl term) {
            ATermAppl nominal = (ATermAppl)term.getArgument(0);
            if (ATermUtils.isLiteral(nominal)) {
                this.fullyDefined = false;
            } else if (!ATermUtils.isLiteral(nominal)) {
                this.fullyDefined = this.fullyDefined && KnowledgeBase.this.individuals.contains(nominal);
            }
        }

        public void visitInverse(ATermAppl term) {
            ATermAppl p = (ATermAppl)term.getArgument(0);
            if (ATermUtils.isPrimitive(p)) {
                this.fullyDefined = this.fullyDefined && KnowledgeBase.this.isProperty(p);
            } else {
                this.visitInverse(p);
            }
        }

        public void visitRestrictedDatatype(ATermAppl dt) {
            this.fullyDefined = this.fullyDefined && KnowledgeBase.this.isDatatype((ATermAppl)dt.getArgument(0));
        }
    }

    class DatatypeVisitor
    extends ATermBaseVisitor {
        private boolean isDatatype = false;

        DatatypeVisitor() {
        }

        public boolean isDatatype(ATermAppl term) {
            this.isDatatype = false;
            this.visit(term);
            return this.isDatatype;
        }

        public void visit(ATermAppl term) {
            super.visit(term);
        }

        public void visitOr(ATermAppl term) {
            this.visitList((ATermList)term.getArgument(0));
        }

        public void visitValue(ATermAppl term) {
            ATermAppl nominal = (ATermAppl)term.getArgument(0);
            if (ATermUtils.isLiteral(nominal)) {
                this.isDatatype = true;
            }
        }

        public void visitTerm(ATermAppl term) {
            if (KnowledgeBase.this.getDatatypeReasoner().isDeclared(term)) {
                this.isDatatype = true;
            }
        }

        public void visitNot(ATermAppl term) {
            this.visit((ATermAppl)term.getArgument(0));
        }

        public void visitAll(ATermAppl term) {
        }

        public void visitAnd(ATermAppl term) {
            this.visitList((ATermList)term.getArgument(0));
        }

        public void visitCard(ATermAppl term) {
        }

        public void visitHasValue(ATermAppl term) {
        }

        public void visitLiteral(ATermAppl term) {
        }

        public void visitMax(ATermAppl term) {
        }

        public void visitMin(ATermAppl term) {
        }

        public void visitOneOf(ATermAppl term) {
            this.visitList((ATermList)term.getArgument(0));
        }

        public void visitSelf(ATermAppl term) {
        }

        public void visitSome(ATermAppl term) {
        }

        public void visitInverse(ATermAppl term) {
        }

        public void visitRestrictedDatatype(ATermAppl dt) {
            this.isDatatype((ATermAppl)dt.getArgument(0));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChangeType {
        ABOX_ADD,
        ABOX_DEL,
        TBOX_ADD,
        TBOX_DEL,
        RBOX_ADD,
        RBOX_DEL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AssertionType {
        TYPE,
        OBJ_ROLE,
        DATA_ROLE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ReasoningState {
        CONSISTENCY,
        CLASSIFY,
        REALIZE;

    }
}

