/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.DatatypeReasoner;
import com.clarkparsia.pellet.datatypes.exceptions.DatatypeReasonerException;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.exceptions.UnrecognizedDatatypeException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.NodeMerge;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Literal
extends Node {
    private ATermAppl atermValue;
    private Object value;
    private boolean hasValue;
    private NodeMerge merge;

    public Literal(ATermAppl name, ATermAppl term, ABox abox, DependencySet ds) {
        super(name, abox);
        if (term != null) {
            boolean bl = this.hasValue = !((Object)term.getArgument(2)).equals(ATermUtils.NO_DATATYPE);
            if (this.hasValue) {
                try {
                    this.value = abox.dtReasoner.getValue(term);
                }
                catch (InvalidLiteralException e2) {
                    String msg = String.format("Attempt to create literal from invalid literal (%s): %s", term, e2.getMessage());
                    if (PelletOptions.INVALID_LITERAL_AS_INCONSISTENCY) {
                        log.fine(msg);
                        this.value = null;
                    }
                    log.severe(msg);
                    throw new InternalReasonerException(msg, e2);
                }
                catch (UnrecognizedDatatypeException e3) {
                    String msg = String.format("Attempt to create literal from with unrecognized datatype (%s): %s", term, e3.getMessage());
                    log.severe(msg);
                    throw new InternalReasonerException(msg, e3);
                }
                if (this.value == null) {
                    this.depends.put(name, ds);
                }
            }
            this.atermValue = ATermUtils.makeValue(term);
        } else {
            this.hasValue = false;
        }
    }

    public Literal(Literal literal, ABox abox) {
        super(literal, abox);
        this.atermValue = literal.atermValue;
        this.value = literal.value;
        this.hasValue = literal.hasValue;
    }

    @Override
    public DependencySet getNodeDepends() {
        return this.getDepends(ATermUtils.TOP_LIT);
    }

    @Override
    public Node copyTo(ABox abox) {
        return new Literal(this, abox);
    }

    @Override
    public final boolean isLeaf() {
        return true;
    }

    @Override
    public int getNominalLevel() {
        return this.isNominal() ? 0 : Integer.MAX_VALUE;
    }

    @Override
    public boolean isNominal() {
        return this.value != null;
    }

    @Override
    public boolean isBlockable() {
        return this.value == null;
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    @Override
    public boolean isIndividual() {
        return false;
    }

    @Override
    public boolean isDifferent(Node node) {
        if (super.isDifferent(node)) {
            return true;
        }
        Literal literal = (Literal)node;
        if (this.hasValue && literal.hasValue) {
            return this.value.getClass().equals(literal.value.getClass()) && !this.value.equals(literal.value);
        }
        return false;
    }

    @Override
    public boolean hasType(ATerm type) {
        ATermAppl a;
        if (type instanceof ATermAppl && ATermUtils.isNominal(a = (ATermAppl)type)) {
            try {
                ATermAppl input = (ATermAppl)a.getArgument(0);
                ATermAppl canonical = this.abox.getDatatypeReasoner().getCanonicalRepresentation(input);
                if (!canonical.equals(input)) {
                    type = ATermUtils.makeValue(canonical);
                }
            }
            catch (InvalidLiteralException e2) {
                log.warning(String.format("hasType called with nominal using invalid literal ('%s'), returning false", e2.getMessage()));
                return false;
            }
            catch (UnrecognizedDatatypeException e3) {
                log.warning(String.format("hasType called with nominal using literal with unrecognized datatype ('%s'), returning false", e3.getMessage()));
                return false;
            }
        }
        if (super.hasType(type)) {
            return true;
        }
        return this.hasValue && this.atermValue.equals(type);
    }

    @Override
    public DependencySet getDifferenceDependency(Node node) {
        DependencySet ds = null;
        if (this.isDifferent(node) && (ds = (DependencySet)this.differents.get(node)) == null) {
            ds = DependencySet.INDEPENDENT;
        }
        return ds;
    }

    @Override
    public void addType(ATermAppl c, DependencySet d) {
        ATermAppl arg;
        if (this.hasType(c)) {
            return;
        }
        if (ATermUtils.isNot(c) && ATermUtils.isNominal(arg = (ATermAppl)c.getArgument(0))) {
            ATermAppl v = (ATermAppl)arg.getArgument(0);
            Literal other = this.abox.getLiteral(v);
            if (other == null) {
                other = this.abox.addLiteral(v, d);
            }
            super.setDifferent(other, d);
            return;
        }
        super.addType(c, d);
        this.checkClash();
    }

    public void addAllTypes(Map<ATermAppl, DependencySet> types, DependencySet ds) {
        for (Map.Entry<ATermAppl, DependencySet> entry : types.entrySet()) {
            ATermAppl c = entry.getKey();
            if (this.hasType(c)) continue;
            DependencySet depends = entry.getValue();
            super.addType(c, depends.union(ds, this.abox.doExplanation()));
        }
        this.checkClash();
    }

    @Override
    public boolean hasSuccessor(Node x) {
        return false;
    }

    @Override
    public final Literal getSame() {
        return (Literal)super.getSame();
    }

    @Override
    public ATermAppl getTerm() {
        return this.hasValue ? (ATermAppl)this.atermValue.getArgument(0) : null;
    }

    public String getLang() {
        return this.hasValue ? ((ATermAppl)((ATermAppl)this.atermValue.getArgument(0)).getArgument(1)).getName() : "";
    }

    public String getLexicalValue() {
        if (this.hasValue) {
            return this.value.toString();
        }
        return null;
    }

    private void checkClash() {
        if (this.hasValue && this.value == null) {
            this.abox.setClash(Clash.invalidLiteral(this, this.getDepends(this.name), this.getTerm()));
            return;
        }
        if (this.hasType(ATermUtils.BOTTOM_LIT)) {
            this.abox.setClash(Clash.emptyDatatype(this, this.getDepends(ATermUtils.BOTTOM_LIT)));
            if (this.abox.doExplanation()) {
                System.out.println("1) Literal clash dependency = " + this.abox.getClash());
            }
            return;
        }
        Set<ATermAppl> types = this.getTypes();
        DatatypeReasoner dtReasoner = this.abox.getDatatypeReasoner();
        try {
            if (this.hasValue) {
                if (!dtReasoner.isSatisfiable(types, this.value)) {
                    ArrayList<ATermAppl> primitives = new ArrayList<ATermAppl>();
                    for (ATermAppl t : types) {
                        if (ATermUtils.TOP_LIT.equals(t)) continue;
                        primitives.add(t);
                    }
                    ATermAppl[] dt = primitives.toArray(new ATermAppl[primitives.size() - 1]);
                    DependencySet ds = DependencySet.EMPTY;
                    for (int i = 0; i < dt.length; ++i) {
                        ds = ds.union(this.getDepends(dt[i]), this.abox.doExplanation());
                    }
                    this.abox.setClash(Clash.emptyDatatype(this, ds, dt));
                }
            } else if (dtReasoner.isSatisfiable(types)) {
                if (!dtReasoner.containsAtLeast(2, types)) {
                    Object value = dtReasoner.valueIterator(types).next();
                    ATermAppl valueTerm = dtReasoner.getLiteral(value);
                    Literal valueLiteral = this.abox.getLiteral(valueTerm);
                    if (valueLiteral == null) {
                        valueLiteral = this.abox.addLiteral(valueTerm);
                    }
                    DependencySet mergeDs = DependencySet.INDEPENDENT;
                    for (DependencySet ds : this.depends.values()) {
                        mergeDs = mergeDs.union(ds, this.abox.doExplanation());
                    }
                    this.merge = new NodeMerge(this, valueLiteral, mergeDs);
                }
            } else {
                ArrayList<ATermAppl> primitives = new ArrayList<ATermAppl>();
                for (ATermAppl t : types) {
                    if (ATermUtils.TOP_LIT.equals(t)) continue;
                    primitives.add(t);
                }
                ATermAppl[] dt = primitives.toArray(new ATermAppl[primitives.size() - 1]);
                DependencySet ds = DependencySet.EMPTY;
                for (int i = 0; i < dt.length; ++i) {
                    ds = ds.union(this.getDepends(dt[i]), this.abox.doExplanation());
                }
                this.abox.setClash(Clash.valueDatatype(this, ds, this.getTerm(), dt[0]));
            }
        }
        catch (DatatypeReasonerException e2) {
            String msg = "Unexcepted datatype reasoner exception: " + e2.getMessage();
            log.severe(msg);
            throw new InternalReasonerException(msg, e2);
        }
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean restore(int branch) {
        Boolean restorePruned = this.restorePruned(branch);
        if (Boolean.FALSE.equals(restorePruned)) {
            return restorePruned;
        }
        boolean restored = Boolean.TRUE.equals(restorePruned);
        return restored |= super.restore(branch);
    }

    @Override
    public final void prune(DependencySet ds) {
        this.pruned = ds;
    }

    @Override
    public void unprune(int branch) {
        super.unprune(branch);
        this.checkClash();
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return super.toString();
        }
        String str2 = "\"" + this.value + "\"";
        String lang = this.getLang();
        if (!lang.equals("")) {
            return str2 + "@" + lang;
        }
        String datatypeURI = ATermUtils.getLiteralDatatype((ATermAppl)this.atermValue.getArgument(0));
        if (datatypeURI != null) {
            return str2 + "^^" + datatypeURI;
        }
        return str2;
    }

    public String debugString() {
        return this.name + " = " + this.getTypes().toString();
    }

    public NodeMerge getMergeToConstant() {
        return this.merge;
    }

    public void clearMergeToConstant() {
        this.merge = null;
    }
}

