/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.utils.iterator.IteratorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetUtils {
    public static final Set<?> EMPTY_SET = new EmptySet();

    public static <T> Set<T> add(T o, Set<T> set) {
        int size = set.size();
        if (size == 0) {
            set = SetUtils.singleton(o);
        } else if (size == 1) {
            T existing = set.iterator().next();
            if (!existing.equals(o)) {
                set = SetUtils.binary(existing, o);
            }
        } else {
            set.add(o);
        }
        return set;
    }

    public static final <T> Set<T> emptySet() {
        return EMPTY_SET;
    }

    public static <T> Set<T> remove(Object o, Set<T> set) {
        int size = set.size();
        if (size != 0) {
            if (size == 1) {
                if (set.contains(o)) {
                    set = Collections.emptySet();
                }
            } else {
                set.remove(o);
            }
        }
        return set;
    }

    public static final <T> Set<T> singleton(T o) {
        return Collections.singleton(o);
    }

    public static final <T> Set<T> binary(T o1, T o2) {
        HashSet<T> set = new HashSet<T>();
        set.add(o1);
        set.add(o2);
        return set;
    }

    public static <T> Set<T> union(Collection<? extends Collection<? extends T>> coll) {
        HashSet<T> set = new HashSet<T>();
        for (Collection<T> collection : coll) {
            set.addAll(collection);
        }
        return set;
    }

    public static <T> Set<T> union(Collection<? extends T> c1, Collection<? extends T> c2) {
        HashSet<T> set = new HashSet<T>(c1);
        set.addAll(c2);
        return set;
    }

    public static <T> Set<T> intersection(Collection<? extends Collection<? extends T>> coll) {
        Iterator<Collection<T>> i = coll.iterator();
        if (!i.hasNext()) {
            return new HashSet();
        }
        HashSet<T> set = new HashSet<T>(i.next());
        while (i.hasNext()) {
            Collection<? extends T> innerColl = i.next();
            set.retainAll(innerColl);
        }
        return set;
    }

    public static <T> Set<T> intersection(Collection<? extends T> c1, Collection<? extends T> c2) {
        HashSet<T> set = new HashSet<T>(c1);
        set.retainAll(c2);
        return set;
    }

    public static boolean intersects(Collection<?> c1, Collection<?> c2) {
        Iterator<?> i = c1.iterator();
        while (i.hasNext()) {
            if (!c2.contains(i.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean subset(Set<?> sub, Set<?> sup) {
        return sub.size() <= sup.size() && sup.containsAll(sub);
    }

    public static <T> boolean equals(Set<T> s1, Set<T> s2) {
        return s1.size() == s2.size() && s1.containsAll(s2);
    }

    public static <T> Set<T> difference(Collection<T> c1, Collection<? extends Object> c2) {
        HashSet<T> set = new HashSet<T>();
        set.addAll(c1);
        set.removeAll(c2);
        return set;
    }

    public static <T> Set<T> create(T ... elems) {
        HashSet<T> set = new HashSet<T>(elems.length);
        for (int i = 0; i < elems.length; ++i) {
            set.add(elems[i]);
        }
        return set;
    }

    public static <T> Set<T> create(Collection<T> coll) {
        return new HashSet<T>(coll);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptySet
    extends AbstractSet<Object> {
        private EmptySet() {
        }

        @Override
        public Iterator<Object> iterator() {
            return IteratorUtils.emptyIterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }
    }
}

