/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.io;

import com.clarkparsia.modularity.IncrementalClassifier;
import com.clarkparsia.modularity.ModuleExtractor;
import com.clarkparsia.modularity.ModuleExtractorFactory;
import com.clarkparsia.modularity.io.TaxonomyPersistence;
import com.clarkparsia.modularity.io.UncloseableOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLOntology;

public class IncrementalClassifierPersistence {
    private static final String TAXONOMY_FILE_NAME = "Taxonomy";
    private static final String PROPERTIES_FILE_NAME = "Properties";
    private static final String PROPERTIES_FILE_COMMENT = "Properties of the IncrementalClassifier";
    private static final String REALIZED_PROPERTY = "realized";

    public static void save(IncrementalClassifier classifier, OutputStream outputStream) throws IOException {
        IncrementalClassifier.PersistedState persistedState = new IncrementalClassifier.PersistedState(classifier);
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        persistedState.getModuleExtractor().save(zipOutputStream);
        ZipEntry taxonomyEntry = new ZipEntry(TAXONOMY_FILE_NAME);
        zipOutputStream.putNextEntry(taxonomyEntry);
        TaxonomyPersistence.save(persistedState.getTaxonomy(), new UncloseableOutputStream(zipOutputStream));
        ZipEntry propertiesEntry = new ZipEntry(PROPERTIES_FILE_NAME);
        zipOutputStream.putNextEntry(propertiesEntry);
        Properties properties = new Properties();
        properties.setProperty(REALIZED_PROPERTY, String.valueOf(persistedState.isRealized()));
        properties.store(zipOutputStream, PROPERTIES_FILE_COMMENT);
        zipOutputStream.finish();
    }

    public static IncrementalClassifier load(InputStream inputStream) throws IOException {
        return IncrementalClassifierPersistence.load(inputStream, null);
    }

    public static IncrementalClassifier load(InputStream inputStream, OWLOntology loadedOntology) throws IOException {
        ModuleExtractor extractor = null;
        Taxonomy<OWLClass> taxonomy = null;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        extractor = ModuleExtractorFactory.createModuleExtractor();
        extractor.load(zipInputStream);
        ZipEntry currentEntry = zipInputStream.getNextEntry();
        if (!TAXONOMY_FILE_NAME.equals(currentEntry.getName())) {
            throw new IOException(String.format("Unexpected entry (%s) in ZipInputStream. Expected %s", currentEntry.getName(), TAXONOMY_FILE_NAME));
        }
        taxonomy = TaxonomyPersistence.load(zipInputStream);
        Properties properties = new Properties();
        currentEntry = zipInputStream.getNextEntry();
        if (currentEntry != null && PROPERTIES_FILE_NAME.equals(currentEntry.getName())) {
            properties.load(zipInputStream);
        }
        boolean realized = Boolean.valueOf(properties.getProperty(REALIZED_PROPERTY, "false"));
        IncrementalClassifier.PersistedState persistedState = new IncrementalClassifier.PersistedState(extractor, taxonomy, realized);
        if (loadedOntology != null) {
            return new IncrementalClassifier(persistedState, loadedOntology);
        }
        return new IncrementalClassifier(persistedState);
    }
}

