/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.uri;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.uri.RestrictedURIDatatype;
import java.net.URI;
import java.net.URISyntaxException;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDAnyURI
extends AbstractBaseDatatype<ATermAppl> {
    private static final XSDAnyURI instance;
    static final ATermAppl NAME;
    private final RestrictedDatatype<ATermAppl> dataRange = new RestrictedURIDatatype(this);

    public static XSDAnyURI getInstance() {
        return instance;
    }

    private XSDAnyURI() {
        super(NAME);
    }

    @Override
    public RestrictedDatatype<ATermAppl> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        return this.getValue(input);
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public ATermAppl getValue(ATermAppl literal) throws InvalidLiteralException {
        String lexicalForm = this.getLexicalForm(literal);
        try {
            return ATermUtils.makeTypedLiteral(new URI(lexicalForm).normalize().toString(), NAME);
        }
        catch (URISyntaxException e2) {
            throw new InvalidLiteralException(NAME, lexicalForm);
        }
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    static {
        NAME = ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#anyURI");
        instance = new XSDAnyURI();
    }
}

