/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.rdf;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.search.provider.rdf.AbstractRDFProvider;
import org.eaglei.search.provider.rdf.RepositoryConfig;

public class RepositoryHarvester
extends AbstractRDFProvider {
    private static final Log logger = LogFactory.getLog(RepositoryHarvester.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private Date fromTime = null;

    public RepositoryHarvester(EIOntModel eagleiOntModel, EIEntity institution, RepositoryConfig repoConfig) {
        super(eagleiOntModel, institution, repoConfig);
    }

    @Override
    public void init() throws IOException {
    }

    @Override
    public SearchResultSet query(SearchRequest request) throws IOException {
        List<QuerySolution> resultList = this.harvest();
        List<SearchResult> results = this.getSearchResultsFromSPARQLResults(resultList, request);
        request.setMaxResults(results.size());
        SearchResultSet resultSet = this.createSearchResultSet(results, request);
        if (DEBUG && resultSet.getTotalCount() > 0) {
            logger.debug("Harvest query found " + resultSet.getTotalCount() + " results");
        }
        return resultSet;
    }

    @Override
    protected QueryExecution getQueryExecution(Query query2) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QuerySolution> harvest() throws IOException {
        HttpClient httpclient = new HttpClient();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials();
        credentials.setUserName(this.repoConfig.getUsername());
        credentials.setPassword(this.repoConfig.getPassword());
        httpclient.getState().setCredentials(AuthScope.ANY, credentials);
        httpclient.getParams().setAuthenticationPreemptive(true);
        PostMethod method = new PostMethod(this.repoConfig.getUrl());
        method.setParameter("view", this.repoConfig.getView());
        method.setParameter("detail", "full");
        if (this.fromTime != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            String dateStr = format.format(this.fromTime);
            method.setParameter("from", dateStr + "Z");
        }
        Date timeBeforeCall = new Date();
        if (DEBUG) {
            // empty if block
        }
        InputStream is = null;
        try {
            httpclient.executeMethod(method);
            is = method.getResponseBodyAsStream();
            ResultSet results = ResultSetFactory.fromXML(is);
            List<QuerySolution> resultList = ResultSetFormatter.toList(results);
            if (!resultList.isEmpty()) {
                this.fromTime = timeBeforeCall;
            }
            List<QuerySolution> list = resultList;
            return list;
        }
        finally {
            method.releaseConnection();
            if (is != null) {
                is.close();
            }
        }
    }

    @Override
    public SearchCounts count(SearchCountRequest request) throws IOException {
        return new SearchCounts(request.getRequest());
    }
}

