/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query.impl;

import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryResultBinding;
import org.mindswap.pellet.query.QueryResults;
import org.mindswap.pellet.query.impl.QueryResultBindingImpl;
import org.mindswap.pellet.query.impl.QueryResultsImpl;

public class MultiQueryResults
extends QueryResultsImpl
implements QueryResults {
    private QueryResults[] queryResults;
    private int size;

    public MultiQueryResults(Query query2, QueryResults[] queryResults) {
        super(query2);
        this.queryResults = queryResults;
        this.size = queryResults[0].size();
        for (int i = 1; i < queryResults.length; ++i) {
            this.size *= queryResults[i].size();
        }
    }

    public void add(QueryResultBinding binding) {
        throw new UnsupportedOperationException("MultiQueryResults do not support addition!");
    }

    public boolean contains(QueryResultBinding binding) {
        for (int i = 0; i < this.queryResults.length; ++i) {
            if (!this.queryResults[i].contains(binding)) continue;
            return true;
        }
        return false;
    }

    public QueryResultBinding get(int index) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        QueryResultBindingImpl result = new QueryResultBindingImpl();
        for (int i = this.queryResults.length - 1; i >= 0; --i) {
            int k = index % this.queryResults[i].size();
            index = (index - k) / this.queryResults[i].size();
            result.setValues(this.queryResults[i].get(k));
        }
        return result;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }
}

