/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.Map;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.tbox.impl.TBoxExpImpl;
import org.mindswap.pellet.tbox.impl.TermDefinition;

public class TBoxBase {
    public static Logger log = Logger.getLogger(TBoxBase.class.getName());
    protected KnowledgeBase kb;
    protected TBoxExpImpl tbox;
    protected Map<ATermAppl, TermDefinition> termhash = CollectionUtils.makeIdentityMap();

    public TBoxBase(TBoxExpImpl tbox) {
        this.tbox = tbox;
        this.kb = tbox.getKB();
    }

    public boolean addDef(ATermAppl def) {
        ATermAppl name = (ATermAppl)def.getArgument(0);
        if (this.termhash.containsKey(name)) {
            this.getTD(name).addDef(def);
        } else {
            TermDefinition td = new TermDefinition();
            td.addDef(def);
            this.termhash.put(name, td);
        }
        return true;
    }

    public boolean removeDef(ATermAppl axiom) {
        boolean removed = false;
        ATermAppl name = (ATermAppl)axiom.getArgument(0);
        TermDefinition td = this.getTD(name);
        if (td != null) {
            removed = td.removeDef(axiom);
        }
        return removed;
    }

    public boolean contains(ATerm name) {
        return this.termhash.containsKey(name);
    }

    public TermDefinition getTD(ATerm name) {
        return this.termhash.get(name);
    }

    public boolean isEmpty() {
        return this.termhash.size() == 0;
    }

    public int size() {
        return this.termhash.size();
    }
}

