/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import aterm.ATerm;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import org.mindswap.pellet.utils.NumberUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Comparators {
    public static final Comparator<Comparable<Object>> comparator = new Comparator<Comparable<Object>>(){

        @Override
        public int compare(Comparable<Object> o1, Comparable<Object> o2) {
            return o1.compareTo(o2);
        }
    };
    public static final Comparator<ATerm> termComparator = new Comparator<ATerm>(){

        @Override
        public int compare(ATerm o1, ATerm o2) {
            int h2;
            int h1 = ((Object)o1).hashCode();
            if (h1 < (h2 = ((Object)o2).hashCode())) {
                return -1;
            }
            if (h1 > h2) {
                return 1;
            }
            if (o1 == o2) {
                return 0;
            }
            return ((Object)o1).toString().compareTo(((Object)o2).toString());
        }
    };
    public static final Comparator<Number> numberComparator = new Comparator<Number>(){

        @Override
        public int compare(Number n1, Number n2) {
            return NumberUtils.compare(n1, n2);
        }
    };
    public static final Comparator<Object> stringComparator = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    };
    public static final Comparator<Calendar> calendarComparator = new Comparator<Calendar>(){

        @Override
        public int compare(Calendar c1, Calendar c2) {
            long t2;
            long t1 = c1.getTimeInMillis();
            if (t1 < (t2 = c2.getTimeInMillis())) {
                return -1;
            }
            if (t1 == t2) {
                return 0;
            }
            return 1;
        }
    };

    public static <T> Comparator<T> reverse(Comparator<T> cmp) {
        return Collections.reverseOrder(cmp);
    }
}

