/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import org.mindswap.pellet.utils.progress.ProgressMonitor;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;

public class ProgressAdapter
implements ProgressMonitor {
    private ReasonerProgressMonitor monitor;
    private int length;
    private int progress;
    private String title;

    public ProgressAdapter(ReasonerProgressMonitor monitor) {
        this.monitor = monitor;
        this.progress = 0;
        this.length = -1;
        this.title = "<untitled>";
    }

    public int getProgress() {
        return this.progress;
    }

    public int getProgressPercent() {
        return this.length > 0 ? this.progress * 100 / this.length : 0;
    }

    public void incrementProgress() {
        ++this.progress;
        if (this.length > 0) {
            this.monitor.reasonerTaskProgressChanged(this.progress, this.length);
        } else {
            this.monitor.reasonerTaskBusy();
        }
    }

    public boolean isCanceled() {
        return false;
    }

    public void setProgress(int value) {
        this.progress = value;
        if (this.length > 0) {
            this.monitor.reasonerTaskProgressChanged(this.progress, this.length);
        } else {
            this.monitor.reasonerTaskBusy();
        }
    }

    public void setProgressLength(int length) {
        this.length = length;
        if (length > 0) {
            this.monitor.reasonerTaskProgressChanged(this.progress, length);
        } else {
            this.monitor.reasonerTaskBusy();
        }
    }

    public void setProgressMessage(String message) {
    }

    public void setProgressTitle(String title) {
        this.title = title;
    }

    public void taskFinished() {
        this.monitor.reasonerTaskStopped();
    }

    public void taskStarted() {
        this.monitor.reasonerTaskStarted(this.title);
    }
}

