/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefixMapping2
implements PrefixMapping {
    PrefixMapping pmapGlobal;
    PrefixMapping pmapLocal;

    public PrefixMapping2(PrefixMapping globalMapping, PrefixMapping localMapping) {
        this.pmapGlobal = globalMapping;
        this.pmapLocal = localMapping;
    }

    public PrefixMapping2(PrefixMapping globalMapping) {
        this(globalMapping, new PrefixMappingImpl());
    }

    public PrefixMapping getLocalPrefixMapping() {
        return this.pmapLocal;
    }

    public PrefixMapping getGlobalPrefixMapping() {
        return this.pmapGlobal;
    }

    public void setLocalPrefixMapping(PrefixMapping x) {
        this.pmapLocal = x;
    }

    public void setGlobalPrefixMapping(PrefixMapping x) {
        this.pmapGlobal = x;
    }

    @Override
    public PrefixMapping setNsPrefix(String prefix, String uri) {
        this.pmapLocal.setNsPrefix(prefix, uri);
        return this;
    }

    @Override
    public PrefixMapping removeNsPrefix(String prefix) {
        this.pmapLocal.removeNsPrefix(prefix);
        if (this.pmapGlobal != null && this.pmapGlobal.getNsPrefixURI(prefix) != null) {
            throw new UnsupportedOperationException("PrefixMapping2: prefix '" + prefix + "' in the immutable map");
        }
        return this;
    }

    @Override
    public PrefixMapping setNsPrefixes(PrefixMapping other) {
        this.pmapLocal.setNsPrefixes(other);
        return this;
    }

    @Override
    public PrefixMapping setNsPrefixes(Map<String, String> map) {
        this.pmapLocal.setNsPrefixes(map);
        return this;
    }

    @Override
    public String getNsPrefixURI(String prefix) {
        String s = this.pmapLocal.getNsPrefixURI(prefix);
        if (s != null) {
            return s;
        }
        if (this.pmapGlobal != null) {
            return this.pmapGlobal.getNsPrefixURI(prefix);
        }
        return null;
    }

    @Override
    public String getNsURIPrefix(String uri) {
        String s = this.pmapLocal.getNsURIPrefix(uri);
        if (s != null) {
            return s;
        }
        if (this.pmapGlobal == null) {
            return null;
        }
        if (this.pmapGlobal != null) {
            return this.pmapGlobal.getNsURIPrefix(uri);
        }
        return null;
    }

    @Override
    public Map<String, String> getNsPrefixMap() {
        return this.getNsPrefixMap(true);
    }

    public Map<String, String> getNsPrefixMap(boolean includeGlobalMap) {
        Map<String, String> m1 = this.pmapLocal.getNsPrefixMap();
        if (this.pmapGlobal == null) {
            return m1;
        }
        if (includeGlobalMap) {
            Map<String, String> m2 = this.pmapGlobal.getNsPrefixMap();
            m1.putAll(m2);
        }
        return m1;
    }

    @Override
    public String expandPrefix(String prefixed) {
        String s = this.pmapLocal.expandPrefix(prefixed);
        if (this.pmapGlobal == null) {
            return s;
        }
        if ((s == null || s.equals(prefixed)) && this.pmapGlobal != null) {
            s = this.pmapGlobal.expandPrefix(prefixed);
        }
        return s;
    }

    @Override
    public String shortForm(String uri) {
        String s = this.pmapLocal.shortForm(uri);
        if (this.pmapGlobal == null) {
            return s;
        }
        if (s == null || s.equals(uri)) {
            s = this.pmapGlobal.shortForm(uri);
        }
        return s;
    }

    @Override
    public String qnameFor(String uri) {
        String s = this.pmapLocal.qnameFor(uri);
        if (this.pmapGlobal == null) {
            return s;
        }
        if (s != null) {
            return s;
        }
        if (this.pmapGlobal != null) {
            return this.pmapGlobal.qnameFor(uri);
        }
        return null;
    }

    @Override
    public PrefixMapping lock() {
        this.pmapLocal.lock();
        return this;
    }

    @Override
    public PrefixMapping withDefaultMappings(PrefixMapping map) {
        for (Map.Entry<String, String> e2 : map.getNsPrefixMap().entrySet()) {
            String prefix = e2.getKey();
            String uri = e2.getValue();
            if (this.getNsPrefixURI(prefix) != null || this.getNsURIPrefix(uri) != null) continue;
            this.setNsPrefix(prefix, uri);
        }
        return this;
    }

    @Override
    public boolean samePrefixMappingAs(PrefixMapping other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof PrefixMapping2)) {
            return false;
        }
        PrefixMapping2 other2 = (PrefixMapping2)other;
        return this.pmapGlobal.samePrefixMappingAs(other2.pmapGlobal) && this.pmapLocal.samePrefixMappingAs(other2.pmapLocal);
    }
}

