/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchResultSet;

public class SearchResultAugmenter
implements SearchProvider {
    private static final Log logger = LogFactory.getLog(SearchResultAugmenter.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private SearchProvider nestedProvider;
    private Map<EIEntity, SearchProvider> resultAugmenters;

    public SearchResultAugmenter(SearchProvider nestedProvider, Map<EIEntity, SearchProvider> resultAugmenters) {
        this.nestedProvider = nestedProvider;
        this.resultAugmenters = resultAugmenters;
    }

    @Override
    public SearchResultSet query(SearchRequest request) throws IOException {
        SearchResultSet nestedResults = this.nestedProvider.query(request);
        for (SearchResult result : nestedResults.getResults()) {
            EIEntity entity = result.getEntity();
            SearchRequest.Term term = new SearchRequest.Term(entity.getLabel(), entity.getURI());
            SearchRequest entityRequest = new SearchRequest(term);
            for (EIEntity type : this.resultAugmenters.keySet()) {
                SearchProvider augmenter = this.resultAugmenters.get(type);
                SearchResultSet augmentingResults = augmenter.query(entityRequest);
                EIURI prop = EIURI.create(type.getLabel());
                for (SearchResult augmentingResult : augmentingResults.getResults()) {
                    result.addDataTypeProperty(prop, augmentingResult.getEntity().getLabel());
                }
            }
        }
        return nestedResults;
    }

    @Override
    public SearchCounts count(SearchCountRequest request) throws IOException {
        return this.nestedProvider.count(request);
    }

    @Override
    public void init() throws IOException {
        this.nestedProvider.init();
        for (SearchProvider augmenter : this.resultAugmenters.values()) {
            augmenter.init();
        }
    }
}

