/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.datatype.xsd.datetime.BigDateTimeValueType;
import com.sun.msv.datatype.xsd.datetime.BigTimeDurationValueType;
import com.sun.msv.datatype.xsd.datetime.IDateTimeValueType;
import com.sun.msv.datatype.xsd.datetime.ITimeDurationValueType;
import java.math.BigInteger;
import org.mindswap.pellet.datatypes.AbstractDateTimeValueSpace;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseXSDAtomicType;
import org.mindswap.pellet.datatypes.ValueSpace;
import org.mindswap.pellet.datatypes.XSDAtomicType;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.GenericIntervalList;
import org.mindswap.pellet.utils.NumberUtils;
import org.relaxng.datatype.DatatypeException;

public class XSDYear
extends BaseXSDAtomicType
implements AtomicDatatype,
XSDAtomicType {
    private static XSDatatype dt = null;
    private static IDateTimeValueType min = null;
    private static IDateTimeValueType max = null;
    private static final ValueSpace YEAR_VALUE_SPACE;
    public static XSDYear instance;

    protected XSDYear(ATermAppl name) {
        super(name, YEAR_VALUE_SPACE);
    }

    public BaseXSDAtomicType create(GenericIntervalList intervals) {
        XSDYear type = new XSDYear(null);
        type.values = intervals;
        return type;
    }

    public AtomicDatatype getPrimitiveType() {
        return instance;
    }

    static {
        try {
            dt = DatatypeFactory.getTypeByName((String)"gYear");
            min = (IDateTimeValueType)dt.createValue("-9999", null);
            max = (IDateTimeValueType)dt.createValue("9999", null);
        }
        catch (DatatypeException e2) {
            e2.printStackTrace();
        }
        YEAR_VALUE_SPACE = new YearValueSpace();
        instance = new XSDYear(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#gYear"));
    }

    private static class YearValueSpace
    extends AbstractDateTimeValueSpace
    implements ValueSpace {
        public YearValueSpace() {
            super(min, max, dt);
        }

        public int count(Object start, Object end) {
            BigDateTimeValueType calendarStart = ((IDateTimeValueType)start).getBigValue();
            BigDateTimeValueType calendarEnd = ((IDateTimeValueType)end).getBigValue();
            return calendarEnd.getYear().intValue() - calendarStart.getYear().intValue() + 1;
        }

        public Object succ(Object value, int n) {
            BigInteger bigN = new BigInteger(String.valueOf(n));
            BigTimeDurationValueType nYears = new BigTimeDurationValueType(bigN, NumberUtils.INTEGER_ZERO, NumberUtils.INTEGER_ZERO, NumberUtils.INTEGER_ZERO, NumberUtils.INTEGER_ZERO, NumberUtils.DECIMAL_ZERO);
            IDateTimeValueType s = ((IDateTimeValueType)value).add((ITimeDurationValueType)nYears);
            return s;
        }
    }
}

