/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.net.URI;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class QNameProvider {
    private static String OWL = "http://www.w3.org/2002/07/owl#";
    private static String RDFS = "http://www.w3.org/2000/01/rdf-schema#";
    private static String RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static String XSD = "http://www.w3.org/2001/XMLSchema#";
    private static String DC = "http://purl.org/dc/elements/1.1/";
    Map uriToPrefix = new Hashtable();
    Map prefixToUri = new Hashtable();

    public QNameProvider() {
        this.setMapping("owl", OWL);
        this.setMapping("rdf", RDF);
        this.setMapping("rdfs", RDFS);
        this.setMapping("xsd", XSD);
        this.setMapping("dc", DC);
    }

    public static boolean isNameStartChar(char ch) {
        return Character.isLetter(ch) || ch == '_';
    }

    public static boolean isNameChar(char ch) {
        return QNameProvider.isNameStartChar(ch) || Character.isDigit(ch) || ch == '.' || ch == '-';
    }

    public static int findNameStartIndex(String str2) {
        char[] strChars = str2.toCharArray();
        int nameStartIndex = -1;
        boolean foundNameChar = false;
        for (int strIndex = strChars.length - 1; strIndex >= 0; --strIndex) {
            char letter = strChars[strIndex];
            if (QNameProvider.isNameStartChar(letter)) {
                nameStartIndex = strIndex;
                foundNameChar = true;
                continue;
            }
            if (foundNameChar && !QNameProvider.isNameChar(letter)) break;
        }
        return nameStartIndex;
    }

    public static int findLastNameIndex(String str2) {
        char letter;
        char[] strChars = str2.toCharArray();
        int nameIndex = -1;
        int strIndex = strChars.length - 1;
        while (strIndex >= 0 && QNameProvider.isNameChar(letter = strChars[strIndex])) {
            nameIndex = strIndex--;
        }
        return nameIndex;
    }

    public static int findNextNonNameIndex(String str2, int startIndex) {
        char letter;
        char[] strChars = str2.toCharArray();
        int nameIndex = startIndex;
        for (nameIndex = startIndex; nameIndex < strChars.length && QNameProvider.isNameChar(letter = strChars[nameIndex]); ++nameIndex) {
        }
        return nameIndex;
    }

    protected static String[] splitURI(String uriString) {
        String prefix;
        String base;
        String[] bpn = new String[3];
        int nameStart = QNameProvider.findLastNameIndex(uriString);
        if (nameStart < 0) {
            return null;
        }
        String name = uriString.substring(nameStart);
        if (nameStart == 0) {
            base = "";
            prefix = "a";
        } else {
            base = uriString.substring(0, nameStart);
            int prefixStart = QNameProvider.findNameStartIndex(base);
            if (prefixStart < 0) {
                prefix = "b";
            } else {
                int prefixEnd = QNameProvider.findNextNonNameIndex(base, prefixStart + 1);
                prefix = uriString.substring(prefixStart, prefixEnd);
            }
        }
        bpn[0] = base;
        bpn[1] = prefix;
        bpn[2] = name;
        return bpn;
    }

    public String getPrefix(String uri) {
        return (String)this.uriToPrefix.get(uri);
    }

    public String getURI(String prefix) {
        return (String)this.prefixToUri.get(prefix);
    }

    public boolean setMapping(String prefix, String uri) {
        String currentUri = this.getURI(prefix);
        if (currentUri == null) {
            this.prefixToUri.put(prefix, uri);
            this.uriToPrefix.put(uri, prefix);
            return true;
        }
        return currentUri.equals(uri);
    }

    public Set getPrefixSet() {
        return this.prefixToUri.keySet();
    }

    public Set getURISet() {
        return this.uriToPrefix.keySet();
    }

    public String shortForm(URI uri) {
        return this.shortForm(uri.toString());
    }

    public String shortForm(String uri) {
        return this.shortForm(uri, true);
    }

    public String shortForm(String uri, boolean default_to_uri) {
        String prefix;
        String[] bpn = QNameProvider.splitURI(uri);
        if (bpn == null) {
            if (default_to_uri) {
                return uri;
            }
            return null;
        }
        String base = bpn[0];
        String possible_prefix = bpn[1];
        String name = bpn[2];
        if (possible_prefix.endsWith(".owl") || possible_prefix.endsWith(".rdf") || possible_prefix.endsWith(".xml")) {
            possible_prefix = possible_prefix.substring(0, possible_prefix.length() - 4);
        }
        if (possible_prefix.length() > 1 && !Character.isUpperCase(possible_prefix.charAt(1))) {
            possible_prefix = Character.toLowerCase(possible_prefix.charAt(0)) + possible_prefix.substring(1, possible_prefix.length());
        }
        if ((prefix = this.getPrefix(base)) == null) {
            prefix = possible_prefix;
            int mod = 0;
            while (!this.setMapping(prefix, base)) {
                prefix = possible_prefix + mod;
                ++mod;
            }
        }
        String qname = prefix + ":" + name;
        return qname;
    }

    public String longForm(String qname) {
        String[] str2 = qname.split(":");
        return this.getURI(str2[0]) + str2[1];
    }

    public String toString() {
        return this.prefixToUri.toString();
    }
}

