/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.intset;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.mindswap.pellet.utils.intset.AbstractIntSet;
import org.mindswap.pellet.utils.intset.IntIterator;
import org.mindswap.pellet.utils.intset.IntSet;

public class TreeIntSet
extends AbstractIntSet
implements IntSet {
    private TreeSet<Integer> ints;

    public TreeIntSet() {
        this.ints = new TreeSet();
    }

    public TreeIntSet(TreeIntSet other) {
        this.ints = new TreeSet<Integer>((SortedSet<Integer>)other.ints);
    }

    public void add(int value) {
        if (value < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ints.add(value);
    }

    public void addAll(IntSet values) {
        if (values instanceof TreeIntSet) {
            this.ints.addAll(((TreeIntSet)values).ints);
        } else {
            super.addAll(values);
        }
    }

    public boolean contains(int value) {
        return this.ints.contains(value);
    }

    public IntSet copy() {
        return new TreeIntSet(this);
    }

    public boolean isEmpty() {
        return this.ints.isEmpty();
    }

    public IntIterator iterator() {
        return new IntIterator(){
            private Iterator<Integer> base;
            {
                this.base = TreeIntSet.this.ints.iterator();
            }

            public boolean hasNext() {
                return this.base.hasNext();
            }

            public int next() {
                return this.base.next();
            }
        };
    }

    public int max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.ints.last();
    }

    public int min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.ints.first();
    }

    public void remove(int value) {
        this.ints.remove(value);
    }

    public int size() {
        return this.ints.size();
    }
}

