/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.actions;

import junit.framework.TestCase;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.network.actions.QueryTestUtils;
import org.eaglei.network.actions.RDFQueryAction;
import org.eaglei.network.actions.Shared;
import org.eaglei.search.datagen.DataGenParams;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.lucene.CompositeLuceneProvider;
import org.eaglei.search.provider.rdf.RDFModelProvider;
import org.eaglei.search.provider.rdf.RepositoryHarvester;
import org.eaglei.services.InstitutionRegistry;
import org.spin.node.actions.QueryAction;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class RDFQueryActionTest
extends TestCase {
    private EIOntModel eagleiOntModel;
    private InstitutionRegistry institutionRegistry;

    protected void setUp() throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{"jena-model-config.xml", "services-config.xml"});
        this.eagleiOntModel = (EIOntModel)context.getBean(EIOntModel.class);
        this.institutionRegistry = (InstitutionRegistry)context.getBean(InstitutionRegistry.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContructorHonorsSystemProps() throws Exception {
        String originalCentralIndexPropValue = System.getProperty("search.central.index");
        String originalSearchNodePropValue = System.getProperty("org.eaglei.search.node");
        String originalRepoURLPropValue = System.getProperty("org.eaglei.search.repository.url");
        try {
            System.setProperty("org.eaglei.search.node", ((EIEntity)this.eagleiOntModel.getInstitutions().get(0)).getURI().toString());
            System.setProperty("org.eaglei.search.repository.url", "");
            System.setProperty("search.central.index", Boolean.FALSE.toString());
            RDFQueryActionTest.invalidateSharedSearchProvider();
            RDFQueryAction noCentralIndex = new RDFQueryAction();
            RDFQueryActionTest.assertEquals(CompositeLuceneProvider.class, noCentralIndex.getSearchProvider().getClass());
            System.setProperty("search.central.index", Boolean.TRUE.toString());
            RDFQueryActionTest.invalidateSharedSearchProvider();
            RDFQueryAction centralIndex = new RDFQueryAction();
            RDFQueryActionTest.assertEquals(RepositoryHarvester.class, centralIndex.getSearchProvider().getClass());
        }
        finally {
            if (originalCentralIndexPropValue == null) {
                System.clearProperty("search.central.index");
            } else {
                System.setProperty("search.central.index", originalCentralIndexPropValue);
            }
            if (originalSearchNodePropValue == null) {
                System.clearProperty("org.eaglei.search.node");
            } else {
                System.setProperty("org.eaglei.search.node", originalSearchNodePropValue);
            }
            if (originalRepoURLPropValue == null) {
                System.clearProperty("org.eaglei.search.repository.url");
            } else {
                System.setProperty("org.eaglei.search.repository.url", originalRepoURLPropValue);
            }
        }
    }

    private static void invalidateSharedSearchProvider() {
        Shared.setSearchProvider(null);
    }

    public void testPerform() throws Exception {
        EIEntity university = (EIEntity)this.institutionRegistry.getInstitutions().get(0);
        RDFModelProvider searchProvider = new RDFModelProvider(this.eagleiOntModel, DataGenParams.createForOneInstitution((String)university.getURI().toString(), (String)university.getLabel()), university);
        RDFQueryAction action = new RDFQueryAction((SearchProvider)searchProvider);
        SearchRequest request = QueryTestUtils.searchRequestForUniversity(university);
        QueryTestUtils.doPerformTest((QueryAction<SearchRequest>)action, request);
    }
}

