/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdUpdate;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.modify.op.UpdateLoad;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.sparql.util.graph.GraphLoadMonitor;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateFactory;
import java.util.Iterator;
import java.util.List;

public class load
extends CmdUpdate {
    ArgDecl graphNameArg = new ArgDecl(true, "--graph");
    ArgDecl dumpArg = new ArgDecl(false, "--dump");
    String graphName = null;
    List<String> loadFiles = null;
    boolean dump = false;

    public static void main(String ... argv) {
        new load(argv).mainRun();
    }

    protected load(String[] argv) {
        super(argv);
        super.add(this.graphNameArg, "--graph=IRI", "Graph IRI (loads default graph if absent)");
        super.add(this.dumpArg, "--dump", "Dump the resulting graph store");
    }

    protected void processModulesAndArgs() {
        if (this.containsMultiple(this.graphNameArg)) {
            throw new CmdException("At most one --graph allowed");
        }
        this.graphName = this.getValue(this.graphNameArg);
        this.loadFiles = super.getPositional();
        this.dump = this.contains(this.dumpArg);
        super.processModulesAndArgs();
    }

    protected String getCommandName() {
        return Utils.className(this);
    }

    protected String getSummary() {
        return this.getCommandName() + " --desc=assembler [--dump] --update=<request file>";
    }

    protected void execUpdate(GraphStore graphStore) {
        if (this.loadFiles.size() == 0) {
            throw new CmdException("Nothing to do");
        }
        UpdateLoad loadReq = new UpdateLoad();
        if (this.graphName != null) {
            loadReq.setGraphName(this.graphName);
        }
        for (String filename : this.loadFiles) {
            loadReq.addLoadIRI(filename);
        }
        this.monitor(graphStore.getDefaultGraph());
        Iterator<Object> iter = graphStore.listGraphNodes();
        while (iter.hasNext()) {
            Graph g = graphStore.getGraph((Node)iter.next());
            this.monitor(g);
        }
        UpdateFactory.create(loadReq, graphStore).execute();
        if (this.dump) {
            IndentedWriter out = IndentedWriter.stdout;
            SSE.write(graphStore);
            out.flush();
        }
    }

    private void monitor(Graph graph) {
        GraphLoadMonitor m = new GraphLoadMonitor(20000, false);
        graph.getEventManager().register(m);
    }
}

