/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation.io.manchester;

import com.clarkparsia.owlapi.explanation.io.ExplanationRenderer;
import com.clarkparsia.owlapi.explanation.io.manchester.BlockWriter;
import com.clarkparsia.owlapi.explanation.io.manchester.ManchesterSyntaxObjectRenderer;
import com.clarkparsia.owlapi.explanation.io.manchester.TextBlockWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObjectVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManchesterSyntaxExplanationRenderer
implements ExplanationRenderer {
    protected ManchesterSyntaxObjectRenderer renderer;
    protected BlockWriter writer;
    protected OWLAxiom currentAxiom;
    private boolean wrapLines = true;
    private boolean smartIndent = true;

    public void endRendering() {
        this.writer.flush();
    }

    protected OWLAxiom getCurrentAxiom() {
        return this.currentAxiom;
    }

    public boolean isSmartIndent() {
        return this.smartIndent;
    }

    public boolean isWrapLines() {
        return this.wrapLines;
    }

    public void render(Set<Set<OWLAxiom>> explanations) throws OWLException, IOException, UnsupportedOperationException {
        this.render(null, explanations);
    }

    public void render(OWLAxiom axiom, Set<Set<OWLAxiom>> explanations) throws OWLException, IOException {
        int expSize;
        this.setCurrentAxiom(axiom);
        if (axiom != null) {
            this.writer.print("Axiom: ");
            axiom.accept((OWLObjectVisitor)this.renderer);
            this.writer.println();
            this.writer.println();
        }
        if ((expSize = explanations.size()) == 0) {
            this.writer.println("Explanation: AXIOM IS NOT ENTAILED!");
            return;
        }
        if (expSize == 1) {
            this.writer.println("Explanation: ");
            Set<OWLAxiom> explanation = explanations.iterator().next();
            this.renderSingleExplanation(explanation);
        } else {
            this.writer.println("Explanations (" + expSize + "): ");
            this.renderMultipleExplanations(explanations);
        }
        this.writer.println();
    }

    protected void renderMultipleExplanations(Set<Set<OWLAxiom>> explanations) throws OWLException, IOException {
        int count = 1;
        for (Set<OWLAxiom> exp : explanations) {
            String header = count++ + ")";
            this.writer.print(header);
            this.renderSingleExplanation(exp);
        }
    }

    protected void renderSingleExplanation(Set<OWLAxiom> explanation) throws OWLException, IOException {
        this.writer.printSpace();
        this.writer.printSpace();
        this.writer.printSpace();
        this.writer.startBlock();
        for (OWLAxiom a : explanation) {
            a.accept((OWLObjectVisitor)this.renderer);
            this.writer.println();
        }
        this.writer.endBlock();
        this.writer.println();
    }

    protected void setCurrentAxiom(OWLAxiom currentAxiom) {
        this.currentAxiom = currentAxiom;
    }

    public void setSmartIndent(boolean smartIndent) {
        this.smartIndent = smartIndent;
    }

    public void setWrapLines(boolean wrapLines) {
        this.wrapLines = wrapLines;
    }

    public void startRendering(Writer w) {
        this.writer = new TextBlockWriter(w);
        this.renderer = new ManchesterSyntaxObjectRenderer(this.writer);
        this.renderer.setWrapLines(this.isWrapLines());
        this.renderer.setSmartIndent(this.isSmartIndent());
    }
}

