/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.text;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidConstrainingFacetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestrictedTextDatatype
implements RestrictedDatatype<ATermAppl> {
    private static final Set<ATermAppl> permittedDts = new HashSet<ATermAppl>(Arrays.asList(ATermUtils.EMPTY));
    private final boolean allowLang;
    private final Datatype<ATermAppl> dt;

    public static boolean addPermittedDatatype(ATermAppl dt) {
        return permittedDts.add(dt);
    }

    public RestrictedTextDatatype(Datatype<ATermAppl> dt, boolean allowLang) {
        this.dt = dt;
        this.allowLang = allowLang;
    }

    @Override
    public RestrictedDatatype<ATermAppl> applyConstrainingFacet(ATermAppl facet, Object value) throws InvalidConstrainingFacetException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object value) {
        ATermAppl a;
        if (value instanceof ATermAppl && ATermUtils.isLiteral(a = (ATermAppl)value) && permittedDts.contains(a.getArgument(2))) {
            return this.allowLang || ATermUtils.EMPTY.equals(a.getArgument(1));
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        return true;
    }

    @Override
    public RestrictedDatatype<ATermAppl> exclude(Collection<?> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Datatype<? extends ATermAppl> getDatatype() {
        return this.dt;
    }

    @Override
    public ATermAppl getValue(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RestrictedDatatype<ATermAppl> intersect(RestrictedDatatype<?> other, boolean negated) {
        if (other instanceof RestrictedTextDatatype) {
            if (!this.allowLang) {
                return this;
            }
            return (RestrictedTextDatatype)other;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return false;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public int size() {
        throw new IllegalStateException();
    }

    @Override
    public RestrictedDatatype<ATermAppl> union(RestrictedDatatype<?> other) {
        if (other instanceof RestrictedTextDatatype) {
            if (this.allowLang) {
                return this;
            }
            return (RestrictedTextDatatype)other;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Iterator<ATermAppl> valueIterator() {
        throw new IllegalStateException();
    }
}

