/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.parser;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtomFactory;
import com.clarkparsia.pellet.sparqldl.model.QueryImpl;
import com.clarkparsia.pellet.sparqldl.parser.QueryParser;
import com.clarkparsia.pellet.sparqldl.parser.SparqldlExtensionsVocabulary;
import com.clarkparsia.pellet.utils.TermFactory;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.exceptions.UnsupportedQueryException;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.jena.vocabulary.OWL2;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARQParser
implements QueryParser {
    public static Logger log = Logger.getLogger(ARQParser.class.getName());
    private Set<Triple> triples;
    private Map<Node, ATerm> terms;
    private KnowledgeBase kb;
    private QuerySolution initialBinding;
    private boolean handleVariableSPO = true;

    public ARQParser() {
        this(true);
    }

    public ARQParser(boolean handleVariableSPO) {
        this.handleVariableSPO = handleVariableSPO;
    }

    @Override
    public Query parse(InputStream stream, KnowledgeBase kb) {
        try {
            return this.parse(new InputStreamReader(stream), kb);
        }
        catch (IOException e2) {
            String message = "Error creating a reader from the input stream.";
            log.severe("Error creating a reader from the input stream.");
            throw new RuntimeException("Error creating a reader from the input stream.");
        }
    }

    @Override
    public Query parse(String queryStr, KnowledgeBase kb) {
        com.hp.hpl.jena.query.Query sparql2 = QueryFactory.create(queryStr, Syntax.syntaxSPARQL);
        return this.parse(sparql2, kb);
    }

    private Query parse(Reader in, KnowledgeBase kb) throws IOException {
        StringBuffer queryString = new StringBuffer();
        BufferedReader r = new BufferedReader(in);
        String line = r.readLine();
        while (line != null) {
            queryString.append(line).append("\n");
            line = r.readLine();
        }
        return this.parse(queryString.toString(), kb);
    }

    @Override
    public Query parse(com.hp.hpl.jena.query.Query sparql2, KnowledgeBase kb) {
        this.kb = kb;
        if (sparql2.isDescribeType()) {
            throw new UnsupportedQueryException("DESCRIBE queries cannot be answered with PelletQueryEngine");
        }
        Element pattern = sparql2.getQueryPattern();
        if (!(pattern instanceof ElementGroup)) {
            throw new UnsupportedQueryException("ElementGroup was expected, but found '" + pattern.getClass() + "'.");
        }
        ElementGroup elementGroup = (ElementGroup)pattern;
        List<Element> elements = elementGroup.getElements();
        Element first = elements.get(0);
        if (elements.size() != 1 || !(first instanceof ElementTriplesBlock)) {
            throw new UnsupportedQueryException("Complex query patterns are not supported yet.");
        }
        sparql2.setResultVars();
        return this.parse(((ElementTriplesBlock)first).getPattern(), sparql2.getResultVars(), kb, sparql2.isDistinct());
    }

    private void initBuiltinTerms() {
        this.terms = new HashMap<Node, ATerm>();
        this.terms.put(OWL.Thing.asNode(), TermFactory.TOP);
        this.terms.put(OWL.Nothing.asNode(), TermFactory.BOTTOM);
        this.terms.put(OWL2.topObjectProperty.asNode(), TermFactory.TOP_OBJECT_PROPERTY);
        this.terms.put(OWL2.topDataProperty.asNode(), TermFactory.TOP_DATA_PROPERTY);
        this.terms.put(OWL2.bottomObjectProperty.asNode(), TermFactory.BOTTOM_OBJECT_PROPERTY);
        this.terms.put(OWL2.bottomDataProperty.asNode(), TermFactory.BOTTOM_DATA_PROPERTY);
    }

    public Query parse(BasicPattern basicPattern, Collection<?> resultVars, KnowledgeBase kb, boolean isDistinct) throws UnsupportedQueryException {
        this.kb = kb;
        HashSet<ATermAppl> variablePredicates = new HashSet<ATermAppl>();
        HashSet<ATermAppl> variableSubjects = new HashSet<ATermAppl>();
        this.initBuiltinTerms();
        this.triples = new LinkedHashSet<Triple>(this.resolveParameterization(basicPattern.getList()));
        QueryImpl query2 = new QueryImpl(kb, isDistinct);
        for (String var : resultVars) {
            query2.addResultVar(ATermUtils.makeVar(var));
        }
        for (Triple t : new ArrayList<Triple>(this.triples)) {
            if (!this.triples.contains(t)) continue;
            Node subj = t.getSubject();
            Node pred = t.getPredicate();
            Node obj = t.getObject();
            ATermAppl s1 = this.node2term(subj);
            ATermAppl p1 = this.node2term(pred);
            ATermAppl o1 = this.node2term(obj);
            this.terms.put(subj, s1);
            this.terms.put(pred, p1);
            this.terms.put(obj, o1);
        }
        HashSet<ATermAppl> possibleLiteralVars = new HashSet<ATermAppl>();
        for (Triple t : this.triples) {
            Node subj = t.getSubject();
            Node pred = t.getPredicate();
            Node obj = t.getObject();
            ATermAppl s = (ATermAppl)this.terms.get(subj);
            ATermAppl p = (ATermAppl)this.terms.get(pred);
            ATermAppl o = (ATermAppl)this.terms.get(obj);
            if (pred.equals(RDF.Nodes.type)) {
                if (obj.equals(OWL.Class.asNode())) {
                    query2.add(QueryAtomFactory.SubClassOfAtom(s, TermFactory.TOP));
                    if (!ATermUtils.isVar(s)) continue;
                    this.ensureDistinguished(subj);
                    query2.addDistVar(s, Query.VarType.CLASS);
                    if (!this.handleVariableSPO) continue;
                    variablePredicates.remove(s);
                    variableSubjects.add(s);
                    continue;
                }
                if (obj.equals(OWL2.NamedIndividual.asNode())) {
                    query2.add(QueryAtomFactory.TypeAtom(s, TermFactory.TOP));
                    if (!ATermUtils.isVar(s)) continue;
                    this.ensureDistinguished(subj);
                    query2.addDistVar(s, Query.VarType.CLASS);
                    if (!this.handleVariableSPO) continue;
                    variablePredicates.remove(s);
                    variableSubjects.add(s);
                    continue;
                }
                if (obj.equals(OWL.ObjectProperty.asNode())) {
                    query2.add(QueryAtomFactory.ObjectPropertyAtom(s));
                    if (ATermUtils.isVar(s)) {
                        this.ensureDistinguished(subj);
                        query2.addDistVar(s, Query.VarType.PROPERTY);
                        if (!this.handleVariableSPO) continue;
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                        continue;
                    }
                    this.ensureTypedProperty(s);
                    continue;
                }
                if (obj.equals(OWL.DatatypeProperty.asNode())) {
                    query2.add(QueryAtomFactory.DatatypePropertyAtom(s));
                    if (ATermUtils.isVar(s)) {
                        this.ensureDistinguished(subj);
                        query2.addDistVar(s, Query.VarType.PROPERTY);
                        if (!this.handleVariableSPO) continue;
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                        continue;
                    }
                    this.ensureTypedProperty(s);
                    continue;
                }
                if (obj.equals(RDF.Property.asNode())) {
                    if (ATermUtils.isVar(s)) {
                        this.ensureDistinguished(subj);
                        query2.addDistVar(s, Query.VarType.PROPERTY);
                        if (!this.handleVariableSPO) continue;
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                        continue;
                    }
                    this.ensureTypedProperty(s);
                    continue;
                }
                if (obj.equals(OWL.FunctionalProperty.asNode())) {
                    query2.add(QueryAtomFactory.FunctionalAtom(s));
                    if (ATermUtils.isVar(s)) {
                        this.ensureDistinguished(subj);
                        query2.addDistVar(s, Query.VarType.PROPERTY);
                        if (!this.handleVariableSPO) continue;
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                        continue;
                    }
                    this.ensureTypedProperty(s);
                    continue;
                }
                if (obj.equals(OWL.InverseFunctionalProperty.asNode())) {
                    query2.add(QueryAtomFactory.InverseFunctionalAtom(s));
                    if (ATermUtils.isVar(s)) {
                        this.ensureDistinguished(subj);
                        query2.addDistVar(s, Query.VarType.PROPERTY);
                        if (!this.handleVariableSPO) continue;
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                        continue;
                    }
                    this.ensureTypedProperty(s);
                    continue;
                }
                if (obj.equals(OWL.TransitiveProperty.asNode())) {
                    query2.add(QueryAtomFactory.TransitiveAtom(s));
                    if (ATermUtils.isVar(s)) {
                        this.ensureDistinguished(subj);
                        query2.addDistVar(s, Query.VarType.PROPERTY);
                        if (!this.handleVariableSPO) continue;
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                        continue;
                    }
                    this.ensureTypedProperty(s);
                    continue;
                }
                if (obj.equals(OWL.SymmetricProperty.asNode())) {
                    query2.add(QueryAtomFactory.SymmetricAtom(s));
                    if (ATermUtils.isVar(s)) {
                        this.ensureDistinguished(subj);
                        query2.addDistVar(s, Query.VarType.PROPERTY);
                        if (!this.handleVariableSPO) continue;
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                        continue;
                    }
                    this.ensureTypedProperty(s);
                    continue;
                }
                if (obj.equals(OWL2.AsymmetricProperty.asNode())) {
                    query2.add(QueryAtomFactory.AsymmetricAtom(s));
                    if (ATermUtils.isVar(s)) {
                        this.ensureDistinguished(subj);
                        query2.addDistVar(s, Query.VarType.PROPERTY);
                        if (!this.handleVariableSPO) continue;
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                        continue;
                    }
                    this.ensureTypedProperty(s);
                    continue;
                }
                if (obj.equals(OWL2.ReflexiveProperty.asNode())) {
                    query2.add(QueryAtomFactory.ReflexiveAtom(s));
                    if (ATermUtils.isVar(s)) {
                        this.ensureDistinguished(subj);
                        query2.addDistVar(s, Query.VarType.PROPERTY);
                        if (!this.handleVariableSPO) continue;
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                        continue;
                    }
                    this.ensureTypedProperty(s);
                    continue;
                }
                if (obj.equals(OWL2.IrreflexiveProperty.asNode())) {
                    query2.add(QueryAtomFactory.IrreflexiveAtom(s));
                    if (ATermUtils.isVar(s)) {
                        this.ensureDistinguished(subj);
                        query2.addDistVar(s, Query.VarType.PROPERTY);
                        if (!this.handleVariableSPO) continue;
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                        continue;
                    }
                    this.ensureTypedProperty(s);
                    continue;
                }
                if (this.hasObject(pred, RDF.type.asNode(), OWL.AnnotationProperty.asNode())) {
                    query2.add(QueryAtomFactory.AnnotationAtom(s, p, o));
                    if (ATermUtils.isVar(s) || ATermUtils.isVar(p) || ATermUtils.isVar(o)) {
                        throw new UnsupportedQueryException("Variables in annotation atom are not supported.");
                    }
                    this.ensureTypedProperty(p);
                    continue;
                }
                query2.add(QueryAtomFactory.TypeAtom(s, o));
                if (ATermUtils.isVar(o)) {
                    this.ensureDistinguished(obj);
                    query2.addDistVar(o, Query.VarType.CLASS);
                } else if (!kb.isClass(o) && log.isLoggable(Level.FINE)) {
                    log.fine("Class " + o + " used in the query is not defined in the KB.");
                }
                if (!ARQParser.isDistinguishedVariable(subj)) continue;
                query2.addDistVar(s, Query.VarType.INDIVIDUAL);
                continue;
            }
            if (pred.equals(OWL.sameAs.asNode())) {
                query2.add(QueryAtomFactory.SameAsAtom(s, o));
                if (ARQParser.isDistinguishedVariable(subj)) {
                    query2.addDistVar(s, Query.VarType.INDIVIDUAL);
                }
                if (!ARQParser.isDistinguishedVariable(obj)) continue;
                query2.addDistVar(o, Query.VarType.INDIVIDUAL);
                continue;
            }
            if (pred.equals(OWL.differentFrom.asNode())) {
                query2.add(QueryAtomFactory.DifferentFromAtom(s, o));
                if (ARQParser.isDistinguishedVariable(subj)) {
                    query2.addDistVar(s, Query.VarType.INDIVIDUAL);
                }
                if (!ARQParser.isDistinguishedVariable(obj)) continue;
                query2.addDistVar(o, Query.VarType.INDIVIDUAL);
                continue;
            }
            if (pred.equals(RDFS.subClassOf.asNode())) {
                query2.add(QueryAtomFactory.SubClassOfAtom(s, o));
                if (ATermUtils.isVar(s)) {
                    this.ensureDistinguished(subj);
                    query2.addDistVar(s, Query.VarType.CLASS);
                }
                if (!ATermUtils.isVar(o)) continue;
                this.ensureDistinguished(obj);
                query2.addDistVar(o, Query.VarType.CLASS);
                continue;
            }
            if (pred.equals(SparqldlExtensionsVocabulary.strictSubClassOf.asNode())) {
                query2.add(QueryAtomFactory.StrictSubClassOfAtom(s, o));
                if (ATermUtils.isVar(s)) {
                    this.ensureDistinguished(subj);
                    query2.addDistVar(s, Query.VarType.CLASS);
                }
                if (!ATermUtils.isVar(o)) continue;
                this.ensureDistinguished(obj);
                query2.addDistVar(o, Query.VarType.CLASS);
                continue;
            }
            if (pred.equals(SparqldlExtensionsVocabulary.directSubClassOf.asNode())) {
                query2.add(QueryAtomFactory.DirectSubClassOfAtom(s, o));
                if (ATermUtils.isVar(s)) {
                    this.ensureDistinguished(subj);
                    query2.addDistVar(s, Query.VarType.CLASS);
                }
                if (!ATermUtils.isVar(o)) continue;
                this.ensureDistinguished(obj);
                query2.addDistVar(o, Query.VarType.CLASS);
                continue;
            }
            if (pred.equals(OWL.equivalentClass.asNode())) {
                query2.add(QueryAtomFactory.EquivalentClassAtom(s, o));
                if (ATermUtils.isVar(s)) {
                    this.ensureDistinguished(subj);
                    query2.addDistVar(s, Query.VarType.CLASS);
                }
                if (!ATermUtils.isVar(o)) continue;
                this.ensureDistinguished(obj);
                query2.addDistVar(o, Query.VarType.CLASS);
                continue;
            }
            if (pred.equals(OWL.disjointWith.asNode())) {
                query2.add(QueryAtomFactory.DisjointWithAtom(s, o));
                if (ATermUtils.isVar(s)) {
                    this.ensureDistinguished(subj);
                    query2.addDistVar(s, Query.VarType.CLASS);
                }
                if (!ATermUtils.isVar(o)) continue;
                this.ensureDistinguished(obj);
                query2.addDistVar(o, Query.VarType.CLASS);
                continue;
            }
            if (pred.equals(OWL.complementOf.asNode())) {
                query2.add(QueryAtomFactory.ComplementOfAtom(s, o));
                if (ATermUtils.isVar(s)) {
                    this.ensureDistinguished(subj);
                    query2.addDistVar(s, Query.VarType.CLASS);
                }
                if (!ATermUtils.isVar(o)) continue;
                this.ensureDistinguished(obj);
                query2.addDistVar(o, Query.VarType.CLASS);
                continue;
            }
            if (pred.equals(RDFS.subPropertyOf.asNode())) {
                this.ensureTypedProperty(s);
                this.ensureTypedProperty(o);
                query2.add(QueryAtomFactory.SubPropertyOfAtom(s, o));
                if (ATermUtils.isVar(s)) {
                    this.ensureDistinguished(subj);
                    query2.addDistVar(s, Query.VarType.PROPERTY);
                    if (this.handleVariableSPO) {
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                    }
                }
                if (!ATermUtils.isVar(o)) continue;
                this.ensureDistinguished(obj);
                query2.addDistVar(o, Query.VarType.PROPERTY);
                if (!this.handleVariableSPO) continue;
                variablePredicates.remove(o);
                variableSubjects.add(o);
                continue;
            }
            if (pred.equals(SparqldlExtensionsVocabulary.directSubPropertyOf.asNode())) {
                this.ensureTypedProperty(s);
                this.ensureTypedProperty(o);
                query2.add(QueryAtomFactory.DirectSubPropertyOfAtom(s, o));
                if (ATermUtils.isVar(s)) {
                    this.ensureDistinguished(subj);
                    query2.addDistVar(s, Query.VarType.PROPERTY);
                    if (this.handleVariableSPO) {
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                    }
                }
                if (!ATermUtils.isVar(o)) continue;
                this.ensureDistinguished(obj);
                query2.addDistVar(o, Query.VarType.PROPERTY);
                if (!this.handleVariableSPO) continue;
                variablePredicates.remove(o);
                variableSubjects.add(o);
                continue;
            }
            if (pred.equals(SparqldlExtensionsVocabulary.strictSubPropertyOf.asNode())) {
                this.ensureTypedProperty(s);
                this.ensureTypedProperty(o);
                query2.add(QueryAtomFactory.StrictSubPropertyOfAtom(s, o));
                if (ATermUtils.isVar(s)) {
                    this.ensureDistinguished(subj);
                    query2.addDistVar(s, Query.VarType.PROPERTY);
                    if (this.handleVariableSPO) {
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                    }
                }
                if (!ATermUtils.isVar(o)) continue;
                this.ensureDistinguished(obj);
                query2.addDistVar(o, Query.VarType.PROPERTY);
                if (!this.handleVariableSPO) continue;
                variablePredicates.remove(o);
                variableSubjects.add(o);
                continue;
            }
            if (pred.equals(OWL.equivalentProperty.asNode())) {
                this.ensureTypedProperty(s);
                this.ensureTypedProperty(o);
                query2.add(QueryAtomFactory.EquivalentPropertyAtom(s, o));
                if (ATermUtils.isVar(s)) {
                    this.ensureDistinguished(subj);
                    query2.addDistVar(s, Query.VarType.PROPERTY);
                    if (this.handleVariableSPO) {
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                    }
                }
                if (!ATermUtils.isVar(o)) continue;
                this.ensureDistinguished(obj);
                query2.addDistVar(o, Query.VarType.PROPERTY);
                if (!this.handleVariableSPO) continue;
                variablePredicates.remove(o);
                variableSubjects.add(o);
                continue;
            }
            if (pred.equals(RDFS.domain.asNode())) {
                this.ensureTypedProperty(s);
                query2.add(QueryAtomFactory.DomainAtom(s, o));
                if (ATermUtils.isVar(s)) {
                    this.ensureDistinguished(subj);
                    query2.addDistVar(s, Query.VarType.PROPERTY);
                    if (this.handleVariableSPO) {
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                    }
                }
                if (!ATermUtils.isVar(o)) continue;
                this.ensureDistinguished(obj);
                query2.addDistVar(s, Query.VarType.CLASS);
                continue;
            }
            if (pred.equals(RDFS.range.asNode())) {
                this.ensureTypedProperty(s);
                query2.add(QueryAtomFactory.RangeAtom(s, o));
                if (ATermUtils.isVar(s)) {
                    this.ensureDistinguished(subj);
                    query2.addDistVar(s, Query.VarType.PROPERTY);
                    if (this.handleVariableSPO) {
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                    }
                }
                if (!ATermUtils.isVar(o)) continue;
                this.ensureDistinguished(obj);
                query2.addDistVar(s, Query.VarType.CLASS);
                continue;
            }
            if (pred.equals(OWL.inverseOf.asNode())) {
                this.ensureTypedProperty(s);
                this.ensureTypedProperty(o);
                query2.add(QueryAtomFactory.InverseOfAtom(s, o));
                if (ATermUtils.isVar(s)) {
                    this.ensureDistinguished(subj);
                    query2.addDistVar(s, Query.VarType.PROPERTY);
                    if (this.handleVariableSPO) {
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                    }
                }
                if (!ATermUtils.isVar(o)) continue;
                this.ensureDistinguished(obj);
                query2.addDistVar(o, Query.VarType.PROPERTY);
                if (!this.handleVariableSPO) continue;
                variablePredicates.remove(o);
                variableSubjects.add(o);
                continue;
            }
            if (pred.equals(SparqldlExtensionsVocabulary.directType.asNode())) {
                query2.add(QueryAtomFactory.DirectTypeAtom(s, o));
                if (ARQParser.isDistinguishedVariable(subj)) {
                    query2.addDistVar(s, Query.VarType.INDIVIDUAL);
                }
                if (!ATermUtils.isVar(o)) continue;
                this.ensureDistinguished(obj);
                query2.addDistVar(o, Query.VarType.CLASS);
                continue;
            }
            if (kb.isAnnotationProperty(p)) {
                if (!PelletOptions.USE_ANNOTATION_SUPPORT) {
                    throw new UnsupportedQueryException("Cannot answer annotation queries when PelletOptions.USE_ANNOTATION_SUPPORT is false!");
                }
                query2.add(QueryAtomFactory.AnnotationAtom(s, p, o));
                if (ATermUtils.isVar(s)) {
                    this.ensureDistinguished(subj);
                    query2.addDistVar(s, Query.VarType.PROPERTY);
                    if (this.handleVariableSPO) {
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                    }
                }
                if (!ATermUtils.isVar(o)) continue;
                this.ensureDistinguished(obj);
                query2.addDistVar(o, Query.VarType.PROPERTY);
                if (!this.handleVariableSPO) continue;
                variablePredicates.remove(o);
                variableSubjects.add(o);
                continue;
            }
            if (s == null || p == null || o == null) {
                throw new UnsupportedQueryException("Atom conversion incomplete for: " + t);
            }
            this.ensureTypedProperty(p);
            query2.add(QueryAtomFactory.PropertyValueAtom(s, p, o));
            if (ATermUtils.isVar(p)) {
                this.ensureDistinguished(pred);
                query2.addDistVar(p, Query.VarType.PROPERTY);
                if (!variableSubjects.contains(p)) {
                    variablePredicates.add(p);
                }
            } else if (kb.isOntologyProperty(p)) {
                throw new UnsupportedQueryException("Ontology properties are not supported in queries.");
            }
            if (ARQParser.isDistinguishedVariable(subj)) {
                query2.addDistVar(s, Query.VarType.INDIVIDUAL);
            }
            if (!ARQParser.isDistinguishedVariable(obj)) continue;
            if (ATermUtils.isVar(p)) {
                possibleLiteralVars.add(o);
                continue;
            }
            if (kb.isObjectProperty(p)) {
                query2.addDistVar(o, Query.VarType.INDIVIDUAL);
                continue;
            }
            if (!kb.isDatatypeProperty(p)) continue;
            query2.addDistVar(o, Query.VarType.LITERAL);
        }
        for (ATermAppl v : possibleLiteralVars) {
            if (!query2.getDistVars().contains(v)) {
                query2.addDistVar(v, Query.VarType.LITERAL);
            }
            query2.addDistVar(v, Query.VarType.INDIVIDUAL);
        }
        if (!this.handleVariableSPO) {
            return query2;
        }
        if (variablePredicates.isEmpty()) {
            return query2;
        }
        throw new UnsupportedQueryException("Queries with variable predicates are not supported (add the pattern {?p rdf:type owl:ObjectProperty} or {?p rdf:type owl:DatatypeProperty} to the query)");
    }

    public void setInitialBinding(QuerySolution initialBinding) {
        this.initialBinding = initialBinding;
    }

    private void ensureDistinguished(Node pred) {
        this.ensureDistinguished(pred, "Non-distinguished variables in class and predicate positions are not supported : ");
    }

    private void ensureDistinguished(Node pred, String errorNonDist) {
        if (!ARQParser.isDistinguishedVariable(pred)) {
            throw new UnsupportedQueryException(errorNonDist + pred);
        }
    }

    private void ensureTypedProperty(ATermAppl pred) {
        if (ATermUtils.isVar(pred)) {
            return;
        }
        Role r = this.kb.getRole(pred);
        if (r == null) {
            throw new UnsupportedQueryException("Unknown role: " + pred);
        }
        if (r.isUntypedRole()) {
            throw new UnsupportedQueryException("Untyped role: " + pred);
        }
    }

    public static boolean isDistinguishedVariable(Node node) {
        return Var.isVar(node) && (Var.isNamedVar(node) || PelletOptions.TREAT_ALL_VARS_DISTINGUISHED);
    }

    private Node getObject(Node subj, Node pred) {
        Iterator<Triple> i = this.triples.iterator();
        while (i.hasNext()) {
            Triple t = i.next();
            if (!subj.equals(t.getSubject()) || !pred.equals(t.getPredicate())) continue;
            i.remove();
            return t.getObject();
        }
        return null;
    }

    private boolean hasObject(Node subj, Node pred) {
        for (Triple t : this.triples) {
            if (!subj.equals(t.getSubject()) || !pred.equals(t.getPredicate())) continue;
            return true;
        }
        return false;
    }

    private boolean hasObject(Node subj, Node pred, Node obj) {
        Iterator<Triple> i = this.triples.iterator();
        while (i.hasNext()) {
            Triple t = i.next();
            if (!subj.equals(t.getSubject()) || !pred.equals(t.getPredicate())) continue;
            i.remove();
            if (obj.equals(t.getObject())) {
                return true;
            }
            throw new UnsupportedQueryException("Expecting rdf:type " + obj + " but found rdf:type " + t.getObject());
        }
        return false;
    }

    private ATermList createList(Node node) {
        if (node.equals(RDF.nil.asNode())) {
            return ATermUtils.EMPTY_LIST;
        }
        if (this.terms.containsKey(node)) {
            return (ATermList)this.terms.get(node);
        }
        this.hasObject(node, RDF.type.asNode(), RDF.List.asNode());
        Node first = this.getObject(node, RDF.first.asNode());
        Node rest = this.getObject(node, RDF.rest.asNode());
        if (first == null || rest == null) {
            throw new UnsupportedQueryException("Invalid list structure: List " + node + " does not have a " + (first == null ? "rdf:first" : "rdf:rest") + " property.");
        }
        ATermList list = ATermUtils.makeList(this.node2term(first), this.createList(rest));
        this.terms.put(node, list);
        return list;
    }

    private ATermAppl createRestriction(Node node) throws UnsupportedFeatureException {
        ATermAppl aTerm = ATermUtils.TOP;
        this.hasObject(node, RDF.type.asNode(), OWL.Restriction.asNode());
        Node p = this.getObject(node, OWL.onProperty.asNode());
        if (p == null) {
            return aTerm;
        }
        ATermAppl pt = this.node2term(p);
        if (!this.kb.isProperty(pt)) {
            throw new UnsupportedQueryException("Property " + pt + " is not present in KB.");
        }
        Node o = null;
        o = this.getObject(node, OWL.hasValue.asNode());
        if (o != null) {
            if (PelletOptions.USE_PSEUDO_NOMINALS) {
                if (o.isLiteral()) {
                    aTerm = ATermUtils.makeMin((ATerm)pt, 1, (ATerm)ATermUtils.TOP_LIT);
                } else {
                    ATermAppl ind = ATermUtils.makeTermAppl(o.getURI());
                    if (!this.kb.isIndividual(ind)) {
                        throw new UnsupportedQueryException("Individual " + ind + " is not present in KB.");
                    }
                    ATermAppl nom = ATermUtils.makeTermAppl(o.getURI() + "_nom");
                    aTerm = ATermUtils.makeSomeValues(pt, nom);
                }
            } else {
                ATermAppl ot = this.node2term(o);
                aTerm = ATermUtils.makeHasValue(pt, ot);
            }
        } else {
            o = this.getObject(node, OWL2.hasSelf.asNode());
            if (o != null) {
                ATermAppl ot = this.node2term(o);
                if (ATermUtils.isVar(ot)) {
                    throw new UnsupportedQueryException("Variables not supported in hasSelf restriction");
                }
                aTerm = ATermUtils.makeSelf(pt);
            } else {
                o = this.getObject(node, OWL.allValuesFrom.asNode());
                if (o != null) {
                    ATermAppl ot = this.node2term(o);
                    if (ATermUtils.isVar(ot)) {
                        throw new UnsupportedQueryException("Variables not supported in allValuesFrom restriction");
                    }
                    aTerm = ATermUtils.makeAllValues(pt, ot);
                } else {
                    o = this.getObject(node, OWL.someValuesFrom.asNode());
                    if (o != null) {
                        ATermAppl ot = this.node2term(o);
                        if (ATermUtils.isVar(ot)) {
                            throw new UnsupportedQueryException("Variables not supported in someValuesFrom restriction");
                        }
                        aTerm = ATermUtils.makeSomeValues(pt, ot);
                    } else {
                        o = this.getObject(node, OWL.minCardinality.asNode());
                        if (o != null) {
                            aTerm = this.createCardinalityRestriction(node, OWL.minCardinality.asNode(), pt, o);
                        } else {
                            o = this.getObject(node, OWL2.minQualifiedCardinality.asNode());
                            if (o != null) {
                                aTerm = this.createCardinalityRestriction(node, OWL2.minQualifiedCardinality.asNode(), pt, o);
                            } else {
                                o = this.getObject(node, OWL.maxCardinality.asNode());
                                if (o != null) {
                                    aTerm = this.createCardinalityRestriction(node, OWL.maxCardinality.asNode(), pt, o);
                                } else {
                                    o = this.getObject(node, OWL2.maxQualifiedCardinality.asNode());
                                    if (o != null) {
                                        aTerm = this.createCardinalityRestriction(node, OWL2.maxQualifiedCardinality.asNode(), pt, o);
                                    } else {
                                        o = this.getObject(node, OWL.cardinality.asNode());
                                        if (o != null) {
                                            aTerm = this.createCardinalityRestriction(node, OWL.cardinality.asNode(), pt, o);
                                        } else {
                                            o = this.getObject(node, OWL2.qualifiedCardinality.asNode());
                                            if (o != null) {
                                                aTerm = this.createCardinalityRestriction(node, OWL2.qualifiedCardinality.asNode(), pt, o);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return aTerm;
    }

    private ATermAppl createCardinalityRestriction(Node node, Node restrictionType, ATermAppl pt, Node card) throws UnsupportedQueryException {
        try {
            ATermAppl c = null;
            Node qualification = null;
            qualification = this.getObject(node, OWL2.onClass.asNode());
            if (qualification != null) {
                if (qualification.isVariable()) {
                    throw new UnsupportedQueryException("Variables not allowed in cardinality qualification");
                }
                if (!this.kb.isObjectProperty(pt)) {
                    return null;
                }
                c = this.node2term(qualification);
            } else {
                qualification = this.getObject(node, OWL2.onDataRange.asNode());
                if (qualification != null) {
                    if (qualification.isVariable()) {
                        throw new UnsupportedQueryException("Variables not allowed in cardinality qualification");
                    }
                    if (!this.kb.isDatatypeProperty(pt)) {
                        return null;
                    }
                    c = this.node2term(qualification);
                } else {
                    int propType = this.kb.getPropertyType(pt);
                    c = propType == 1 ? ATermUtils.TOP : (propType == 2 ? ATermUtils.TOP_LIT : ATermUtils.TOP);
                }
            }
            int cardinality = Integer.parseInt(card.getLiteralLexicalForm());
            if (restrictionType.equals(OWL.minCardinality.asNode()) || restrictionType.equals(OWL2.minQualifiedCardinality.asNode())) {
                return ATermUtils.makeMin((ATerm)pt, cardinality, (ATerm)c);
            }
            if (restrictionType.equals(OWL.maxCardinality.asNode()) || restrictionType.equals(OWL2.maxQualifiedCardinality.asNode())) {
                return ATermUtils.makeMax((ATerm)pt, cardinality, (ATerm)c);
            }
            return ATermUtils.makeCard(pt, cardinality, c);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Invalid cardinality", ex);
            return null;
        }
    }

    private ATermAppl node2term(Node node) {
        ATermAppl aTerm = (ATermAppl)this.terms.get(node);
        if (aTerm == null) {
            if (node.equals(RDF.type.asNode())) {
                return null;
            }
            if (node.isLiteral()) {
                return JenaUtils.makeLiteral(node.getLiteral());
            }
            if (this.hasObject(node, OWL.onProperty.asNode())) {
                aTerm = this.createRestriction(node);
                this.terms.put(node, aTerm);
            } else if (node.isBlank() || node.isVariable()) {
                Node o = null;
                o = this.getObject(node, OWL.intersectionOf.asNode());
                if (o != null) {
                    ATermList list = this.createList(o);
                    this.hasObject(node, RDF.type.asNode(), OWL.Class.asNode());
                    aTerm = ATermUtils.makeAnd(list);
                } else {
                    o = this.getObject(node, OWL.unionOf.asNode());
                    if (o != null) {
                        ATermList list = this.createList(o);
                        this.hasObject(node, RDF.type.asNode(), OWL.Class.asNode());
                        aTerm = ATermUtils.makeOr(list);
                    } else {
                        o = this.getObject(node, OWL.oneOf.asNode());
                        if (o != null) {
                            ATermList list = this.createList(o);
                            this.hasObject(node, RDF.type.asNode(), OWL.Class.asNode());
                            ATermList result = ATermUtils.EMPTY_LIST;
                            ATermList l = list;
                            while (!l.isEmpty()) {
                                ATermAppl nominal;
                                ATermAppl c = (ATermAppl)l.getFirst();
                                if (PelletOptions.USE_PSEUDO_NOMINALS) {
                                    nominal = ATermUtils.makeTermAppl(c.getName() + "_nominal");
                                    result = result.insert(nominal);
                                } else {
                                    nominal = ATermUtils.makeValue(c);
                                    result = result.insert(nominal);
                                }
                                l = l.getNext();
                            }
                            aTerm = ATermUtils.makeOr(result);
                        } else if (Var.isBlankNodeVar(node) && (o = this.getObject(node, OWL.complementOf.asNode())) != null) {
                            ATermAppl complement = this.node2term(o);
                            this.hasObject(node, RDF.type.asNode(), OWL.Class.asNode());
                            aTerm = ATermUtils.makeNot(complement);
                        } else {
                            if (node.isVariable()) {
                                return ATermUtils.makeVar(node.getName());
                            }
                            o = this.getObject(node, OWL.complementOf.asNode());
                            if (o != null) {
                                log.info("Blank nodes in class variable positions are not supported");
                            }
                            aTerm = ATermUtils.makeBnode(node.getBlankNodeId().toString());
                        }
                    }
                }
            } else {
                String uri = node.getURI();
                aTerm = ATermUtils.makeTermAppl(uri);
            }
            this.terms.put(node, aTerm);
        }
        return aTerm;
    }

    private List<Triple> resolveParameterization(List<?> triples) {
        if (triples == null) {
            throw new NullPointerException("The set of triples cannot be null");
        }
        if (this.initialBinding == null) {
            this.initialBinding = new QuerySolutionMap();
        }
        ArrayList<Triple> ret = new ArrayList<Triple>();
        for (Triple t : triples.toArray(new Triple[triples.size()])) {
            if (!triples.contains(t)) continue;
            Node s = this.resolveParameterization(t.getSubject());
            Node p = this.resolveParameterization(t.getPredicate());
            Node o = this.resolveParameterization(t.getObject());
            ret.add(Triple.create(s, p, o));
        }
        return ret;
    }

    private Node resolveParameterization(Node node) {
        if (node == null) {
            throw new NullPointerException("Node is null");
        }
        if (this.initialBinding == null) {
            throw new NullPointerException("Initial binding is null");
        }
        if (node.isConcrete()) {
            return node;
        }
        RDFNode binding = this.initialBinding.get(node.getName());
        if (binding == null) {
            return node;
        }
        return binding.asNode();
    }
}

