/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.model;

import java.util.Collections;
import java.util.Set;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LintFixer {
    private Set<? extends OWLAxiom> m_AxiomsToRemove;
    private Set<? extends OWLAxiom> m_AxiomsToAdd;

    public LintFixer(Set<? extends OWLAxiom> axiomsToRemove, Set<? extends OWLAxiom> axiomsToAdd) {
        this.m_AxiomsToRemove = axiomsToRemove;
        this.m_AxiomsToAdd = axiomsToAdd;
    }

    public LintFixer(OWLAxiom axiomToRemove, OWLAxiom axiomToAdd) {
        this(Collections.singleton(axiomToRemove), Collections.singleton(axiomToAdd));
    }

    public Set<? extends OWLAxiom> getAxiomsToRemove() {
        return this.m_AxiomsToRemove;
    }

    public Set<? extends OWLAxiom> getAxiomsToAdd() {
        return this.m_AxiomsToAdd;
    }

    public boolean apply(OWLOntologyManager manager, OWLOntology ontology) throws OWLOntologyChangeException {
        Set ALL_AXIOMS = ontology.getAxioms();
        if (!ALL_AXIOMS.containsAll(this.m_AxiomsToRemove)) {
            return false;
        }
        for (OWLAxiom oWLAxiom : this.m_AxiomsToRemove) {
            RemoveAxiom remove = new RemoveAxiom(ontology, oWLAxiom);
            manager.applyChange((OWLOntologyChange)remove);
        }
        for (OWLAxiom oWLAxiom : this.m_AxiomsToAdd) {
            if (ALL_AXIOMS.contains(oWLAxiom)) continue;
            AddAxiom add = new AddAxiom(ontology, oWLAxiom);
            manager.applyChange((OWLOntologyChange)add);
        }
        return true;
    }
}

