/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.opt;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpWalker;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.algebra.opt.OpVisitorExprPrepare;
import com.hp.hpl.jena.sparql.algebra.opt.Rewrite;
import com.hp.hpl.jena.sparql.algebra.opt.TransformFilterDisjunction;
import com.hp.hpl.jena.sparql.algebra.opt.TransformFilterEquality;
import com.hp.hpl.jena.sparql.algebra.opt.TransformFilterImprove;
import com.hp.hpl.jena.sparql.algebra.opt.TransformFilterPlacement;
import com.hp.hpl.jena.sparql.algebra.opt.TransformJoinStrategy;
import com.hp.hpl.jena.sparql.algebra.opt.TransformPathFlattern;
import com.hp.hpl.jena.sparql.algebra.opt.TransformPropertyFunction;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Optimize
implements Rewrite {
    private static Logger log = LoggerFactory.getLogger(Optimize.class);
    public static Factory noOptimizationFactory = new Factory(){

        public Rewrite create(Context context) {
            return new Rewrite(){

                public Op rewrite(Op op) {
                    return op;
                }
            };
        }
    };
    public static Factory stdOptimizationFactory;
    private static Factory factory;
    private final Context context;
    public static boolean disjunctionOptimization;

    public static Op optimize(Op op, ExecutionContext execCxt) {
        return Optimize.optimize(op, execCxt.getContext());
    }

    public static Op optimize(Op op, Context context) {
        Rewrite opt = Optimize.decideOptimizer(context);
        return opt.rewrite(op);
    }

    public static void noOptimizer() {
        Optimize.setFactory(noOptimizationFactory);
    }

    private static Rewrite decideOptimizer(Context context) {
        Factory f = (Factory)context.get(ARQConstants.sysOptimizer);
        if (f == null) {
            f = factory;
        }
        if (f == null) {
            f = stdOptimizationFactory;
        }
        return f.create(context);
    }

    public static void setFactory(Factory aFactory) {
        factory = aFactory;
    }

    public static Factory getFactory(Factory aFactory) {
        return factory;
    }

    private Optimize(ExecutionContext execCxt) {
        this(execCxt.getContext());
    }

    private Optimize(Context context) {
        this.context = context;
    }

    public Op rewrite(Op op) {
        OpWalker.walk(op, new OpVisitorExprPrepare(this.context));
        op = Optimize.apply("Property Functions", new TransformPropertyFunction(this.context), op);
        op = Optimize.apply("Break up conjunctions", new TransformFilterImprove(), op);
        op = Optimize.apply("Filter Equality", new TransformFilterEquality(), op);
        if (disjunctionOptimization) {
            op = Optimize.apply("Filter Disjunction", new TransformFilterDisjunction(), op);
        }
        op = Optimize.apply("Join strategy", new TransformJoinStrategy(this.context), op);
        if (this.context.isTrueOrUndef(ARQ.filterPlacement)) {
            op = Optimize.apply("Filter Placement", new TransformFilterPlacement(), op);
        }
        op = Optimize.apply("Path flattening", new TransformPathFlattern(), op);
        return op;
    }

    private static Op apply(String label, Transform transform, Op op) {
        Op op2 = Transformer.transform(transform, op);
        boolean debug2 = false;
        return op2;
    }

    static {
        factory = stdOptimizationFactory = new Factory(){

            public Rewrite create(Context context) {
                return new Optimize(context);
            }
        };
        disjunctionOptimization = true;
    }

    public static interface Factory {
        public Rewrite create(Context var1);
    }
}

