/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.NodeConst;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregateFactory;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;

public class AggCount
implements AggregateFactory {
    private static AggCount singleton = new AggCount();

    public static AggregateFactory get() {
        return singleton;
    }

    private AggCount() {
    }

    public Aggregator create() {
        return new AggCountWorker();
    }

    static class AccCount
    implements Accumulator {
        private long count = 0L;

        public void accumulate(Binding binding, FunctionEnv functionEnv) {
            ++this.count;
        }

        public NodeValue getValue() {
            return NodeValue.makeInteger(this.count);
        }
    }

    static class AggCountWorker
    extends AggregatorBase {
        public String toString() {
            return "count(*)";
        }

        public String toPrefixString() {
            return "(count)";
        }

        protected Accumulator createAccumulator() {
            return new AccCount();
        }

        public boolean equalsAsExpr(Aggregator other) {
            return other instanceof AggCountWorker;
        }

        public Node getValueEmpty() {
            return NodeConst.nodeZero;
        }
    }
}

