/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.lang.ParserBase;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.syntax.TemplateGroup;
import com.hp.hpl.jena.sparql.syntax.TemplateTriple;
import com.hp.hpl.jena.sparql.syntax.TemplateVisitor;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriplesDataCollector
implements TemplateVisitor {
    private Collection<Triple> acc;
    private int line;
    private int col;

    public TriplesDataCollector(Collection<Triple> acc, int line, int col) {
        this.acc = acc;
        this.line = line;
        this.col = col;
    }

    @Override
    public void visit(TemplateTriple template) {
        Triple t = template.getTriple();
        if (t.getSubject().isVariable() || t.getPredicate().isVariable() || t.getObject().isVariable()) {
            ParserBase.throwParseException("Triples may not contain variables in ADD or REMOVE", this.line, this.col);
        }
        this.acc.add(t);
    }

    @Override
    public void visit(TemplateGroup template) {
        for (Template t : template.getTemplates()) {
            t.visit(this);
        }
    }
}

