/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lib.cache;

import com.hp.hpl.jena.sparql.lib.ActionKeyValue;
import com.hp.hpl.jena.sparql.lib.Cache;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheLRU<K, V>
implements Cache<K, V> {
    private CacheImpl<K, V> cache;

    public CacheLRU(float loadFactor, int maxSize) {
        this.cache = new CacheImpl(loadFactor, maxSize);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    @Override
    public V get(K key) {
        return this.cache.get(key);
    }

    @Override
    public V put(K key, V thing) {
        return this.cache.put(key, thing);
    }

    @Override
    public boolean remove(K key) {
        Object old = this.cache.remove(key);
        return old != null;
    }

    @Override
    public long size() {
        return this.cache.size();
    }

    @Override
    public Iterator<K> keys() {
        return this.cache.keySet().iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public void setDropHandler(ActionKeyValue<K, V> dropHandler) {
        this.cache.setDropHandler(dropHandler);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CacheImpl<K, V>
    extends LinkedHashMap<K, V> {
        int maxEntries;
        ActionKeyValue<K, V> dropHandler = null;

        public CacheImpl(int maxSize) {
            this(0.75f, maxSize);
        }

        public CacheImpl(float loadFactor, int maxSize) {
            super(Math.round((float)maxSize / loadFactor + 0.5f) + 1, loadFactor, true);
            this.maxEntries = maxSize;
        }

        public void setDropHandler(ActionKeyValue<K, V> dropHandler) {
            this.dropHandler = dropHandler;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            boolean b;
            boolean bl = b = this.size() > this.maxEntries;
            if (b && this.dropHandler != null) {
                this.dropHandler.apply(eldest.getKey(), eldest.getValue());
            }
            return b;
        }
    }
}

