/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.dig;

import java.util.Arrays;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementList {
    private Element[] nodes;
    private int size;

    public ElementList(NodeList nodeList) {
        this(nodeList, Integer.MAX_VALUE);
    }

    public ElementList(NodeList nodeList, int limit) {
        int capacity = Math.min(limit, nodeList.getLength());
        this.nodes = new Element[capacity];
        this.size = 0;
        for (int i = 0; i < capacity; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                String trimmedText = node.getNodeValue().trim();
                if (trimmedText.equals("")) continue;
                throw new RuntimeException("Expecting an XML element. Found: " + node.getNodeValue());
            }
            if (node instanceof Element) {
                this.nodes[this.size++] = (Element)node;
                continue;
            }
            if (node instanceof Comment) continue;
            throw new RuntimeException("Expecting an XML element. Found: " + node);
        }
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int getLength() {
        return this.size;
    }

    public Element item(int index) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.nodes[index];
    }

    public Element[] getNodeArray() {
        return this.nodes;
    }

    public String toString() {
        return Arrays.toString(this.nodes);
    }
}

