/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.actions;

import java.io.IOException;
import junit.framework.TestCase;
import org.eaglei.network.actions.SearchProviderOperations;
import org.eaglei.network.actions.SearchProviderQueryAction;
import org.eaglei.network.actions.Shared;
import org.eaglei.search.common.Serializer;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;

public class SearchProviderQueryActionTest
extends TestCase {
    public void testInitIsCalledLazily() throws Exception {
        MockSearchProvider mockProvider = new MockSearchProvider();
        Shared.setSearchProvider((SearchProvider)mockProvider);
        Shared.setIsProviderInitialized((boolean)false);
        SearchProviderQueryAction<SearchRequest, SearchResultSet> queryAction = new SearchProviderQueryAction<SearchRequest, SearchResultSet>(Serializer.SearchRequestSerializer, Serializer.SearchResultSetSerializer, SearchProviderOperations.invokesQuery((SearchProvider)mockProvider)){};
        SearchProviderQueryActionTest.assertFalse((boolean)mockProvider.isInitialized);
        queryAction.perform(null, (Object)new SearchRequest());
        SearchProviderQueryActionTest.assertTrue((boolean)mockProvider.isInitialized);
    }

    static final class MockSearchProvider
    implements SearchProvider {
        volatile boolean isInitialized = false;

        MockSearchProvider() {
        }

        public SearchResultSet query(SearchRequest request) throws IOException {
            return new SearchResultSet(request);
        }

        public SearchCounts count(SearchCountRequest request) throws IOException {
            return new SearchCounts(request.getRequest());
        }

        public void init() throws IOException {
            this.isInitialized = true;
        }
    }
}

