package org.eaglei.network.actions;

import org.apache.log4j.Logger;
import org.spin.node.QueryContext;
import org.spin.node.actions.AbstractQueryAction;
import org.spin.node.actions.QueryException;
import org.spin.query.message.serializer.SerializationException;
import org.spin.tools.Util;

/**
 * 
 * @author Clint Gilbert
 * 
 * Nov 22, 2010
 *
 * Center for Biomedical Informatics (CBMI)
 * @link https://cbmi.med.harvard.edu/
 *
 * A QueryAction that does nothing
 * TODO: move to Spin-base
 */
public final class NoopQueryAction<T> extends AbstractQueryAction<T>
{
    private static final Logger log = Logger.getLogger(NoopQueryAction.class);
    
    private static final boolean INFO = log.isInfoEnabled();
    
    @SuppressWarnings("rawtypes")
    private static final NoopQueryAction Instance = new NoopQueryAction();
    
    /**
     * Type-inferring factory method; always returns the singleton instance
     * @param <T>
     * @return
     */
    @SuppressWarnings("unchecked")
    public static <T> NoopQueryAction<T> instance()
    {
        return Instance;
    }
    
    //TODO: make this private
    public NoopQueryAction()
    {
        super();
    }
    
    @Override
    public String perform(final QueryContext context, final Object criteria) throws QueryException
    {
        return null;
    }

    @Override
    public T unmarshal(final String serializedCriteria) throws SerializationException
    {
        return null;
    }
}
