/*
 * Decompiled with CFR 0.152.
 */
package aterm.pure;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermBlob;
import aterm.ATermFactory;
import aterm.ATermInt;
import aterm.ATermList;
import aterm.ATermPlaceholder;
import aterm.ATermReal;
import aterm.ParseError;
import aterm.pure.AFunImpl;
import aterm.pure.ATermApplImpl;
import aterm.pure.ATermBlobImpl;
import aterm.pure.ATermImpl;
import aterm.pure.ATermIntImpl;
import aterm.pure.ATermListImpl;
import aterm.pure.ATermPlaceholderImpl;
import aterm.pure.ATermReader;
import aterm.pure.ATermRealImpl;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import shared.HashFunctions;
import shared.SharedObjectFactory;

public class PureFactory
extends SharedObjectFactory
implements ATermFactory {
    private static int DEFAULT_TERM_TABLE_SIZE = 16;
    private ATermListImpl protoList = new ATermListImpl(this);
    private ATermApplImpl protoAppl = new ATermApplImpl(this);
    private ATermIntImpl protoInt = new ATermIntImpl(this);
    private ATermRealImpl protoReal = new ATermRealImpl(this);
    private ATermBlobImpl protoBlob = new ATermBlobImpl(this);
    private ATermPlaceholderImpl protoPlaceholder = new ATermPlaceholderImpl(this);
    private AFunImpl protoAFun = new AFunImpl(this);
    private ATermList empty;
    private static ATerm[] array0 = new ATerm[0];

    static boolean isBase64(int c) {
        return Character.isLetterOrDigit((char)c) || c == 43 || c == 47;
    }

    /*
     * Unable to fully structure code
     */
    public static int abbrevSize(int abbrev) {
        size = 1;
        if (abbrev != 0) ** GOTO lbl6
        return 2;
lbl-1000:
        // 1 sources

        {
            ++size;
            abbrev /= 64;
lbl6:
            // 2 sources

            ** while (abbrev > 0)
        }
lbl7:
        // 1 sources

        return size;
    }

    public PureFactory() {
        this(DEFAULT_TERM_TABLE_SIZE);
    }

    public PureFactory(int termTableSize) {
        super(termTableSize);
        this.protoList.init(42, null, null, null);
        this.empty = (ATermList)((Object)this.build(this.protoList));
        ((ATermListImpl)this.empty).init(42, this.empty, null, null);
    }

    public ATermInt makeInt(int val) {
        return this.makeInt(val, this.empty);
    }

    public ATermReal makeReal(double val) {
        return this.makeReal(val, this.empty);
    }

    public ATermList makeList() {
        return this.empty;
    }

    public ATermList makeList(ATerm singleton) {
        return this.makeList(singleton, this.empty, this.empty);
    }

    public ATermList makeList(ATerm first, ATermList next) {
        return this.makeList(first, next, this.empty);
    }

    public ATermPlaceholder makePlaceholder(ATerm type) {
        return this.makePlaceholder(type, this.empty);
    }

    public ATermBlob makeBlob(byte[] data) {
        return this.makeBlob(data, this.empty);
    }

    public AFun makeAFun(String name, int arity, boolean isQuoted) {
        AFunImpl aFunImpl = this.protoAFun;
        synchronized (aFunImpl) {
            this.protoAFun.initHashCode(name, arity, isQuoted);
            return (AFun)((Object)this.build(this.protoAFun));
        }
    }

    public ATermInt makeInt(int value, ATermList annos) {
        ATermIntImpl aTermIntImpl = this.protoInt;
        synchronized (aTermIntImpl) {
            this.protoInt.initHashCode(annos, value);
            return (ATermInt)((Object)this.build(this.protoInt));
        }
    }

    public ATermReal makeReal(double value, ATermList annos) {
        ATermRealImpl aTermRealImpl = this.protoReal;
        synchronized (aTermRealImpl) {
            this.protoReal.init(PureFactory.hashReal(annos, value), annos, value);
            return (ATermReal)((Object)this.build(this.protoReal));
        }
    }

    private static int hashReal(ATermList annos, double value) {
        return HashFunctions.doobs(new Object[]{annos, new Double(value)});
    }

    public ATermPlaceholder makePlaceholder(ATerm type, ATermList annos) {
        ATermPlaceholderImpl aTermPlaceholderImpl = this.protoPlaceholder;
        synchronized (aTermPlaceholderImpl) {
            this.protoPlaceholder.init(PureFactory.hashPlaceholder(annos, type), annos, type);
            return (ATermPlaceholder)((Object)this.build(this.protoPlaceholder));
        }
    }

    private static int hashPlaceholder(ATermList annos, ATerm type) {
        return HashFunctions.doobs(new Object[]{annos, type});
    }

    public ATermBlob makeBlob(byte[] data, ATermList annos) {
        ATermBlobImpl aTermBlobImpl = this.protoBlob;
        synchronized (aTermBlobImpl) {
            this.protoBlob.init(PureFactory.hashBlob(annos, data), annos, data);
            return (ATermBlob)((Object)this.build(this.protoBlob));
        }
    }

    private static int hashBlob(ATermList annos, byte[] data) {
        return HashFunctions.doobs(new Object[]{annos, data});
    }

    public ATermList makeList(ATerm first, ATermList next, ATermList annos) {
        ATermListImpl aTermListImpl = this.protoList;
        synchronized (aTermListImpl) {
            this.protoList.initHashCode(annos, first, next);
            return (ATermList)((Object)this.build(this.protoList));
        }
    }

    public ATermAppl makeAppl(AFun fun, ATerm[] args) {
        return this.makeAppl(fun, args, this.empty);
    }

    public ATermAppl makeAppl(AFun fun, ATerm[] args, ATermList annos) {
        ATermApplImpl aTermApplImpl = this.protoAppl;
        synchronized (aTermApplImpl) {
            this.protoAppl.initHashCode(annos, fun, args);
            return (ATermAppl)((Object)this.build(this.protoAppl));
        }
    }

    public ATermAppl makeApplList(AFun fun, ATermList list) {
        return this.makeApplList(fun, list, this.empty);
    }

    public ATermAppl makeApplList(AFun fun, ATermList list, ATermList annos) {
        ATerm[] arg_array = new ATerm[list.getLength()];
        int i = 0;
        while (!list.isEmpty()) {
            arg_array[i++] = list.getFirst();
            list = list.getNext();
        }
        return this.makeAppl(fun, arg_array, annos);
    }

    public ATermAppl makeAppl(AFun fun) {
        return this.makeAppl(fun, array0);
    }

    public ATermAppl makeAppl(AFun fun, ATerm arg) {
        ATerm[] argarray1 = new ATerm[]{arg};
        return this.makeAppl(fun, argarray1);
    }

    public ATermAppl makeAppl(AFun fun, ATerm arg1, ATerm arg2) {
        ATerm[] argarray2 = new ATerm[]{arg1, arg2};
        return this.makeAppl(fun, argarray2);
    }

    public ATermAppl makeAppl(AFun fun, ATerm arg1, ATerm arg2, ATerm arg3) {
        ATerm[] argarray3 = new ATerm[]{arg1, arg2, arg3};
        return this.makeAppl(fun, argarray3);
    }

    public ATermAppl makeAppl(AFun fun, ATerm arg1, ATerm arg2, ATerm arg3, ATerm arg4) {
        ATerm[] argarray4 = new ATerm[]{arg1, arg2, arg3, arg4};
        return this.makeAppl(fun, argarray4);
    }

    public ATermAppl makeAppl(AFun fun, ATerm arg1, ATerm arg2, ATerm arg3, ATerm arg4, ATerm arg5) {
        ATerm[] argarray5 = new ATerm[]{arg1, arg2, arg3, arg4, arg5};
        return this.makeAppl(fun, argarray5);
    }

    public ATermAppl makeAppl(AFun fun, ATerm arg1, ATerm arg2, ATerm arg3, ATerm arg4, ATerm arg5, ATerm arg6) {
        ATerm[] args = new ATerm[]{arg1, arg2, arg3, arg4, arg5, arg6};
        return this.makeAppl(fun, args);
    }

    public ATermAppl makeAppl(AFun fun, ATerm arg1, ATerm arg2, ATerm arg3, ATerm arg4, ATerm arg5, ATerm arg6, ATerm arg7) {
        ATerm[] args = new ATerm[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7};
        return this.makeAppl(fun, args);
    }

    public ATermList getEmpty() {
        return this.empty;
    }

    private ATerm parseAbbrev(ATermReader reader) throws IOException {
        int c = reader.read();
        int abbrev = 0;
        while (PureFactory.isBase64(c)) {
            abbrev *= 64;
            if (c >= 65 && c <= 90) {
                abbrev += c - 65;
            } else if (c >= 97 && c <= 122) {
                abbrev += c - 97 + 26;
            } else if (c >= 48 && c <= 57) {
                abbrev += c - 48 + 52;
            } else if (c == 43) {
                abbrev += 62;
            } else if (c == 47) {
                abbrev += 63;
            } else {
                throw new RuntimeException("not a base-64 digit: " + c);
            }
            c = reader.read();
        }
        ATerm result = reader.getTerm(abbrev);
        return result;
    }

    private ATerm parseNumber(ATermReader reader) throws IOException {
        ATerm result;
        StringBuffer str2 = new StringBuffer();
        do {
            str2.append((char)reader.getLastChar());
        } while (Character.isDigit((char)reader.read()));
        if (reader.getLastChar() != 46 && reader.getLastChar() != 101 && reader.getLastChar() != 69) {
            int val;
            try {
                val = Integer.parseInt(str2.toString());
            }
            catch (NumberFormatException e2) {
                throw new ParseError("malformed int");
            }
            result = this.makeInt(val);
        } else {
            double val;
            if (reader.getLastChar() == 46) {
                str2.append('.');
                reader.read();
                if (!Character.isDigit((char)reader.getLastChar())) {
                    throw new ParseError("digit expected");
                }
                do {
                    str2.append((char)reader.getLastChar());
                } while (Character.isDigit((char)reader.read()));
            }
            if (reader.getLastChar() == 101 || reader.getLastChar() == 69) {
                str2.append((char)reader.getLastChar());
                reader.read();
                if (reader.getLastChar() == 45 || reader.getLastChar() == 43) {
                    str2.append((char)reader.getLastChar());
                    reader.read();
                }
                if (!Character.isDigit((char)reader.getLastChar())) {
                    throw new ParseError("digit expected!");
                }
                do {
                    str2.append((char)reader.getLastChar());
                } while (Character.isDigit((char)reader.read()));
            }
            try {
                val = Double.valueOf(str2.toString());
            }
            catch (NumberFormatException e3) {
                throw new ParseError("malformed real");
            }
            result = this.makeReal(val);
        }
        return result;
    }

    private String parseId(ATermReader reader) throws IOException {
        int c = reader.getLastChar();
        StringBuffer buf = new StringBuffer(32);
        do {
            buf.append((char)c);
        } while (Character.isLetterOrDigit((char)(c = reader.read())) || c == 95 || c == 45);
        return buf.toString();
    }

    private String parseString(ATermReader reader) throws IOException {
        boolean escaped;
        StringBuffer str2 = new StringBuffer();
        do {
            escaped = false;
            if (reader.read() == 92) {
                reader.read();
                escaped = true;
            }
            if (escaped) {
                switch (reader.getLastChar()) {
                    case 110: {
                        str2.append('\n');
                        break;
                    }
                    case 116: {
                        str2.append('\t');
                        break;
                    }
                    case 98: {
                        str2.append('\b');
                        break;
                    }
                    case 114: {
                        str2.append('\r');
                        break;
                    }
                    case 102: {
                        str2.append('\f');
                        break;
                    }
                    case 92: {
                        str2.append('\\');
                        break;
                    }
                    case 39: {
                        str2.append('\'');
                        break;
                    }
                    case 34: {
                        str2.append('\"');
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        str2.append(reader.readOct());
                        break;
                    }
                    default: {
                        str2.append('\\').append((char)reader.getLastChar());
                        break;
                    }
                }
                continue;
            }
            if (reader.getLastChar() == 34) continue;
            str2.append((char)reader.getLastChar());
        } while (escaped || reader.getLastChar() != 34);
        return str2.toString();
    }

    private ATermList parseATerms(ATermReader reader) throws IOException {
        ATerm[] terms = this.parseATermsArray(reader);
        ATermList result = this.empty;
        int i = terms.length - 1;
        while (i >= 0) {
            result = this.makeList(terms[i], result);
            --i;
        }
        return result;
    }

    private ATerm[] parseATermsArray(ATermReader reader) throws IOException {
        Vector<ATerm> list = new Vector<ATerm>();
        ATerm term = this.parseFromReader(reader);
        list.add(term);
        while (reader.getLastChar() == 44) {
            reader.readSkippingWS();
            term = this.parseFromReader(reader);
            list.add(term);
        }
        ATerm[] array = new ATerm[list.size()];
        ListIterator iter = list.listIterator();
        int index = 0;
        while (iter.hasNext()) {
            array[index++] = (ATerm)iter.next();
        }
        return array;
    }

    private synchronized ATerm parseFromReader(ATermReader reader) throws IOException {
        ATerm result;
        int start = reader.getPosition();
        switch (reader.getLastChar()) {
            case -1: {
                throw new ParseError("premature EOF encountered.");
            }
            case 35: {
                return this.parseAbbrev(reader);
            }
            case 91: {
                int c = reader.readSkippingWS();
                if (c == -1) {
                    throw new ParseError("premature EOF encountered.");
                }
                if (c == 93) {
                    c = reader.readSkippingWS();
                    result = this.empty;
                    break;
                }
                result = this.parseATerms(reader);
                if (reader.getLastChar() != 93) {
                    throw new ParseError("expected ']' but got '" + (char)reader.getLastChar() + "'");
                }
                c = reader.readSkippingWS();
                break;
            }
            case 60: {
                int c = reader.readSkippingWS();
                ATerm ph = this.parseFromReader(reader);
                if (reader.getLastChar() != 62) {
                    throw new ParseError("expected '>' but got '" + (char)reader.getLastChar() + "'");
                }
                c = reader.readSkippingWS();
                result = this.makePlaceholder(ph);
                break;
            }
            case 34: {
                String funname = this.parseString(reader);
                int c = reader.readSkippingWS();
                if (reader.getLastChar() == 40) {
                    c = reader.readSkippingWS();
                    if (c == -1) {
                        throw new ParseError("premature EOF encountered.");
                    }
                    if (reader.getLastChar() == 41) {
                        result = this.makeAppl(this.makeAFun(funname, 0, true));
                    } else {
                        ATerm[] list = this.parseATermsArray(reader);
                        if (reader.getLastChar() != 41) {
                            throw new ParseError("expected ')' but got '" + reader.getLastChar() + "'");
                        }
                        result = this.makeAppl(this.makeAFun(funname, list.length, true), list);
                    }
                    c = reader.readSkippingWS();
                    if (c != -1) break;
                    throw new ParseError("premature EOF encountered.");
                }
                result = this.makeAppl(this.makeAFun(funname, 0, true));
                break;
            }
            case 40: {
                int c = reader.readSkippingWS();
                if (c == -1) {
                    throw new ParseError("premature EOF encountered.");
                }
                if (reader.getLastChar() == 41) {
                    result = this.makeAppl(this.makeAFun("", 0, false));
                } else {
                    ATerm[] list = this.parseATermsArray(reader);
                    if (reader.getLastChar() != 41) {
                        throw new ParseError("expected ')' but got '" + reader.getLastChar() + "'");
                    }
                    result = this.makeAppl(this.makeAFun("", list.length, false), list);
                }
                c = reader.readSkippingWS();
                if (c != -1) break;
                throw new ParseError("premature EOF encountered.");
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                result = this.parseNumber(reader);
                int c = reader.skipWS();
                break;
            }
            default: {
                int c = reader.getLastChar();
                if (Character.isLetter((char)c)) {
                    String funname = this.parseId(reader);
                    c = reader.skipWS();
                    if (reader.getLastChar() == 40) {
                        c = reader.readSkippingWS();
                        if (c == -1) {
                            throw new ParseError("premature EOF encountered.");
                        }
                        if (reader.getLastChar() == 41) {
                            result = this.makeAppl(this.makeAFun(funname, 0, false));
                        } else {
                            ATerm[] list = this.parseATermsArray(reader);
                            if (reader.getLastChar() != 41) {
                                throw new ParseError("expected ')' but got '" + reader.getLastChar() + "'");
                            }
                            result = this.makeAppl(this.makeAFun(funname, list.length, false), list);
                        }
                        c = reader.readSkippingWS();
                        break;
                    }
                    result = this.makeAppl(this.makeAFun(funname, 0, false));
                    break;
                }
                throw new ParseError("illegal character: " + reader.getLastChar());
            }
        }
        if (reader.getLastChar() == 123) {
            ATermList annos;
            if (reader.readSkippingWS() == 125) {
                reader.readSkippingWS();
                annos = this.empty;
            } else {
                annos = this.parseATerms(reader);
                if (reader.getLastChar() != 125) {
                    throw new ParseError("'}' expected");
                }
                reader.readSkippingWS();
            }
            result = result.setAnnotations(annos);
        }
        if (reader.getLastChar() == 58) {
            reader.read();
            ATerm anno = this.parseFromReader(reader);
            result = result.setAnnotation(this.parse("type"), anno);
        }
        if (reader.getLastChar() == 63) {
            reader.readSkippingWS();
            result = result.setAnnotation(this.parse("result"), this.parse("true"));
        }
        int end = reader.getPosition();
        reader.storeNextTerm(result, end - start);
        return result;
    }

    public ATerm parse(String trm) {
        try {
            ATermReader reader = new ATermReader(new StringReader(trm));
            reader.readSkippingWS();
            ATerm result = this.parseFromReader(reader);
            return result;
        }
        catch (IOException e2) {
            throw new ParseError("premature end of string");
        }
    }

    public ATerm make(String trm) {
        return this.parse(trm);
    }

    public ATerm make(String pattern, List args) {
        return this.make(this.parse(pattern), args);
    }

    public ATerm make(String pattern, Object arg1) {
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(arg1);
        return this.make(pattern, args);
    }

    public ATerm make(String pattern, Object arg1, Object arg2) {
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(arg1);
        args.add(arg2);
        return this.make(pattern, args);
    }

    public ATerm make(String pattern, Object arg1, Object arg2, Object arg3) {
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(arg1);
        args.add(arg2);
        args.add(arg3);
        return this.make(pattern, args);
    }

    public ATerm make(String pattern, Object arg1, Object arg2, Object arg3, Object arg4) {
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(arg1);
        args.add(arg2);
        args.add(arg3);
        args.add(arg4);
        return this.make(pattern, args);
    }

    public ATerm make(String pattern, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(arg1);
        args.add(arg2);
        args.add(arg3);
        args.add(arg4);
        args.add(arg5);
        return this.make(pattern, args);
    }

    public ATerm make(String pattern, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(arg1);
        args.add(arg2);
        args.add(arg3);
        args.add(arg4);
        args.add(arg5);
        args.add(arg6);
        return this.make(pattern, args);
    }

    public ATerm make(String pattern, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) {
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(arg1);
        args.add(arg2);
        args.add(arg3);
        args.add(arg4);
        args.add(arg5);
        args.add(arg6);
        args.add(arg7);
        return this.make(pattern, args);
    }

    public ATerm make(ATerm pattern, List args) {
        return pattern.make(args);
    }

    ATerm parsePattern(String pattern) throws ParseError {
        return this.parse(pattern);
    }

    protected boolean isDeepEqual(ATermImpl t1, ATerm t2) {
        throw new UnsupportedOperationException("not yet implemented!");
    }

    private ATerm readFromSharedTextFile(ATermReader reader) throws IOException {
        reader.initializeSharing();
        return this.parseFromReader(reader);
    }

    private ATerm readFromTextFile(ATermReader reader) throws IOException {
        return this.parseFromReader(reader);
    }

    public ATerm readFromTextFile(InputStream stream) throws IOException {
        ATermReader reader = new ATermReader(new InputStreamReader(stream));
        reader.readSkippingWS();
        return this.readFromTextFile(reader);
    }

    public ATerm readFromSharedTextFile(InputStream stream) throws IOException {
        ATermReader reader = new ATermReader(new InputStreamReader(stream));
        reader.readSkippingWS();
        if (reader.getLastChar() != 33) {
            throw new IOException("not a shared text file!");
        }
        reader.readSkippingWS();
        return this.readFromSharedTextFile(reader);
    }

    public ATerm readFromBinaryFile(InputStream stream) {
        throw new RuntimeException("not yet implemented!");
    }

    public ATerm readFromFile(InputStream stream) throws IOException {
        ATermReader reader = new ATermReader(new InputStreamReader(stream));
        reader.readSkippingWS();
        int last_char = reader.getLastChar();
        if (last_char == 33) {
            reader.readSkippingWS();
            return this.readFromSharedTextFile(reader);
        }
        if (Character.isLetterOrDigit((char)last_char) || last_char == 95 || last_char == 91 || last_char == 45) {
            return this.readFromTextFile(reader);
        }
        throw new RuntimeException("BAF files are not supported by this factory.");
    }

    public ATerm readFromFile(String file) throws IOException {
        return this.readFromFile(new FileInputStream(file));
    }

    public ATerm importTerm(ATerm term) {
        throw new RuntimeException("not yet implemented!");
    }
}

