/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation;

import aterm.ATermAppl;
import com.clarkparsia.owlapi.explanation.SingleExplanationGeneratorImpl;
import com.clarkparsia.owlapi.explanation.util.DefinitionTracker;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.OntologyUtils;
import com.clarkparsia.pellet.owlapiv3.AxiomConverter;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.utils.Pair;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.TaxonomyUtils;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassBoxExplanation
extends SingleExplanationGeneratorImpl {
    public static final Logger log;
    private PelletReasoner altReasoner = null;
    private boolean altReasonerEnabled = false;
    private AxiomConverter axiomConverter;

    public static void setup() {
        PelletOptions.USE_TRACING = true;
    }

    public GlassBoxExplanation(OWLOntology ontology, PelletReasonerFactory factory) {
        this(factory, factory.createReasoner(ontology));
    }

    public GlassBoxExplanation(PelletReasoner reasoner) {
        this(new PelletReasonerFactory(), reasoner);
    }

    public GlassBoxExplanation(PelletReasonerFactory factory, PelletReasoner reasoner) {
        super(reasoner.getRootOntology(), (OWLReasonerFactory)factory, (OWLReasoner)reasoner);
        this.axiomConverter = new AxiomConverter(reasoner);
    }

    private void setAltReasonerEnabled(boolean enabled) {
        if (enabled && this.altReasoner == null) {
            log.fine("Create alt reasoner");
            this.altReasoner = this.getReasonerFactory().createNonBufferingReasoner(this.getOntology());
        }
        this.altReasonerEnabled = enabled;
    }

    private OWLClass getNegation(OWLClassExpression desc) {
        if (!(desc instanceof OWLObjectComplementOf)) {
            return null;
        }
        OWLClassExpression not2 = ((OWLObjectComplementOf)desc).getOperand();
        if (not2.isAnonymous()) {
            return null;
        }
        return (OWLClass)not2;
    }

    private Pair<OWLClass, OWLClass> getSubClassAxiom(OWLClassExpression desc) {
        if (!(desc instanceof OWLObjectIntersectionOf)) {
            return null;
        }
        OWLObjectIntersectionOf conj = (OWLObjectIntersectionOf)desc;
        if (conj.getOperands().size() != 2) {
            return null;
        }
        Iterator conjuncts = conj.getOperands().iterator();
        OWLClassExpression c1 = (OWLClassExpression)conjuncts.next();
        OWLClassExpression c2 = (OWLClassExpression)conjuncts.next();
        OWLClass sub = null;
        OWLClass sup = null;
        if (!c1.isAnonymous()) {
            sub = (OWLClass)c1;
            sup = this.getNegation(c2);
        } else if (!c2.isAnonymous()) {
            sub = (OWLClass)c2;
            sup = this.getNegation(c2);
        }
        if (sup == null) {
            return null;
        }
        return new Pair<OWLClass, OWLClass>(sub, sup);
    }

    private Set<OWLAxiom> getCachedExplanation(OWLClassExpression unsatClass) {
        Set<Set<ATermAppl>> exps;
        PelletReasoner pellet = this.getReasoner();
        if (!pellet.getKB().isClassified()) {
            return null;
        }
        Pair<OWLClass, OWLClass> pair = this.getSubClassAxiom(unsatClass);
        if (pair != null && (exps = TaxonomyUtils.getSuperExplanations(pellet.getKB().getTaxonomy(), pellet.term((OWLObject)pair.first), pellet.term((OWLObject)pair.second))) != null) {
            Set<OWLAxiom> result = this.convertExplanation(exps.iterator().next());
            if (log.isLoggable(Level.FINE)) {
                log.fine("Cached explanation: " + result);
            }
            return result;
        }
        return null;
    }

    public Set<OWLAxiom> getExplanation(OWLClassExpression unsatClass) {
        Set<OWLAxiom> result = null;
        boolean firstExplanation = this.isFirstExplanation();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Explain: " + unsatClass + " " + "First: " + firstExplanation);
        }
        if (firstExplanation) {
            this.altReasoner = null;
            result = this.getCachedExplanation(unsatClass);
            if (result == null) {
                result = this.getPelletExplanation(unsatClass);
            }
        } else {
            this.setAltReasonerEnabled(true);
            try {
                result = this.getPelletExplanation(unsatClass);
            }
            catch (RuntimeException e2) {
                log.log(Level.SEVERE, "Unexpected error while trying to get explanation set from Pellet", e2);
                throw new OWLRuntimeException((Throwable)e2);
            }
            finally {
                this.setAltReasonerEnabled(false);
            }
        }
        return result;
    }

    private Set<OWLAxiom> getPelletExplanation(OWLClassExpression unsatClass) {
        boolean sat;
        PelletReasoner pellet = this.getReasoner();
        pellet.getKB().prepare();
        boolean bl = sat = !this.getDefinitionTracker().isDefined(unsatClass);
        if (!sat) {
            sat = this.isSatisfiable(pellet, unsatClass, true);
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("Undefined entity in " + unsatClass);
        }
        if (sat) {
            return Collections.emptySet();
        }
        Set<OWLAxiom> explanation = this.convertExplanation(pellet.getKB().getExplanationSet());
        if (log.isLoggable(Level.FINE)) {
            log.fine("Explanation " + explanation);
        }
        Set<OWLAxiom> prunedExplanation = this.pruneExplanation(unsatClass, explanation, true);
        int prunedAxiomCount = explanation.size() - prunedExplanation.size();
        if (log.isLoggable(Level.FINE) && prunedAxiomCount > 0) {
            log.fine("Pruned " + prunedAxiomCount + " axioms from the explanation: " + SetUtils.difference(explanation, prunedExplanation));
            log.fine("New explanation " + prunedExplanation);
        }
        return prunedExplanation;
    }

    private boolean isSatisfiable(PelletReasoner pellet, OWLClassExpression unsatClass, boolean doExplanation) {
        pellet.getKB().setDoExplanation(doExplanation);
        boolean sat = unsatClass.isOWLThing() ? pellet.isConsistent() : pellet.isSatisfiable(unsatClass);
        pellet.getKB().setDoExplanation(false);
        return sat;
    }

    private Set<OWLAxiom> convertExplanation(Set<ATermAppl> explanation) {
        if (explanation == null || explanation.isEmpty()) {
            throw new OWLRuntimeException("No explanation computed");
        }
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        for (ATermAppl term : explanation) {
            OWLAxiom axiom = this.axiomConverter.convert(term);
            if (axiom == null) {
                throw new OWLRuntimeException("Cannot convert: " + term);
            }
            result.add(axiom);
        }
        return result;
    }

    private Set<OWLAxiom> pruneExplanation(OWLClassExpression unsatClass, Set<OWLAxiom> explanation, boolean incremental) {
        try {
            HashSet<OWLAxiom> prunedExplanation = new HashSet<OWLAxiom>(explanation);
            if (prunedExplanation.size() <= 1) {
                return prunedExplanation;
            }
            OWLOntology debuggingOntology = OWL.Ontology(explanation);
            DefinitionTracker defTracker = new DefinitionTracker(debuggingOntology);
            PelletReasoner reasoner = this.getReasonerFactory().createNonBufferingReasoner(debuggingOntology);
            if (!defTracker.isDefined(unsatClass)) {
                log.warning("Some of the entities in " + unsatClass + " are not defined in the explanation " + explanation);
            }
            if (this.isSatisfiable(reasoner, unsatClass, true)) {
                log.warning("Explanation incomplete: Concept " + unsatClass + " is satisfiable in the explanation " + explanation);
            }
            for (OWLAxiom axiom : explanation) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Try pruning " + axiom);
                }
                OntologyUtils.removeAxioms(debuggingOntology, axiom);
                if (!incremental) {
                    reasoner = this.getReasonerFactory().createNonBufferingReasoner(debuggingOntology);
                }
                reasoner.getKB().prepare();
                if (defTracker.isDefined(unsatClass) && !this.isSatisfiable(reasoner, unsatClass, false)) {
                    prunedExplanation.remove(axiom);
                    if (!log.isLoggable(Level.FINER)) continue;
                    log.finer("Pruned " + axiom);
                    continue;
                }
                OntologyUtils.addAxioms(debuggingOntology, axiom);
            }
            if (incremental) {
                reasoner.dispose();
            }
            OWL.manager.removeOntology(debuggingOntology);
            OWL.manager.removeOntologyChangeListener((OWLOntologyChangeListener)defTracker);
            return prunedExplanation;
        }
        catch (OWLOntologyChangeException e2) {
            throw new OWLRuntimeException((Throwable)e2);
        }
    }

    public PelletReasoner getReasoner() {
        return this.altReasonerEnabled ? this.altReasoner : (PelletReasoner)super.getReasoner();
    }

    public PelletReasonerFactory getReasonerFactory() {
        return (PelletReasonerFactory)super.getReasonerFactory();
    }

    public void dispose() {
        this.getOntologyManager().removeOntologyChangeListener((OWLOntologyChangeListener)this.getDefinitionTracker());
        if (this.altReasoner != null) {
            this.altReasoner.dispose();
        }
    }

    public String toString() {
        return "GlassBox";
    }

    static {
        GlassBoxExplanation.setup();
        log = Logger.getLogger(GlassBoxExplanation.class.getName());
    }
}

