/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.engine;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import com.clarkparsia.pellet.sparqldl.model.ResultBindingImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BindingIterator
implements Iterator<ResultBinding> {
    private final List<List<ATermAppl>> varB = new ArrayList<List<ATermAppl>>();
    private final List<ATermAppl> vars = new ArrayList<ATermAppl>();
    private int[] indices;
    private boolean more = true;

    public BindingIterator(Map<ATermAppl, Set<ATermAppl>> bindings) {
        this.vars.addAll(bindings.keySet());
        for (ATermAppl var : this.vars) {
            Set<ATermAppl> values = bindings.get(var);
            if (values.isEmpty()) {
                this.more = false;
                break;
            }
            this.varB.add(new ArrayList<ATermAppl>(values));
        }
        this.indices = new int[this.vars.size()];
    }

    private boolean incIndex(int index) {
        if (this.indices[index] + 1 >= this.varB.get(index).size()) {
            if (index == this.indices.length - 1) {
                return false;
            }
            this.indices[index] = 0;
            return this.incIndex(index + 1);
        }
        int n = index;
        this.indices[n] = this.indices[n] + 1;
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.more;
    }

    @Override
    public ResultBinding next() {
        if (!this.more) {
            return null;
        }
        ResultBindingImpl next = new ResultBindingImpl();
        for (int i = 0; i < this.indices.length; ++i) {
            next.setValue(this.vars.get(i), this.varB.get(i).get(this.indices[i]));
        }
        this.more = this.incIndex(0);
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removal from this iterator is not supported.");
    }
}

