/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.sparql.util.TranslationTable;

public class ResultSetFormat
extends Symbol {
    public static final ResultSetFormat syntaxXML = new ResultSetFormat("RS_XML");
    public static final ResultSetFormat syntaxRDF_XML = new ResultSetFormat("RS_RDF");
    public static final ResultSetFormat syntaxRDF_N3 = new ResultSetFormat("RS_RDF/N3");
    public static final ResultSetFormat syntaxRDF_TURTLE = new ResultSetFormat("RS_RDF/TTL");
    public static final ResultSetFormat syntaxRDF_NT = new ResultSetFormat("RS_RDF/NT");
    public static final ResultSetFormat syntaxText = new ResultSetFormat("RS_TEXT");
    public static final ResultSetFormat syntaxJSON = new ResultSetFormat("RS_JSON");
    public static final ResultSetFormat syntaxSSE = new ResultSetFormat("RS_SSE");
    public static final ResultSetFormat syntaxCSV = new ResultSetFormat("RS_CSV");
    protected static TranslationTable syntaxNames = new TranslationTable(true);

    protected ResultSetFormat(String symbol) {
        super(symbol);
    }

    protected ResultSetFormat(ResultSetFormat fmt) {
        super(fmt);
    }

    public static ResultSetFormat guessSyntax(String url) {
        return ResultSetFormat.guessSyntax(url, syntaxXML);
    }

    public boolean isCompatibleWith(ResultSetFormat other) {
        if (this.equals(other)) {
            return true;
        }
        return other.equals(syntaxRDF_XML) && (this.equals(syntaxRDF_N3) || this.equals(syntaxRDF_TURTLE) || this.equals(syntaxRDF_NT));
    }

    public static ResultSetFormat guessSyntax(String url, ResultSetFormat defaultFormat) {
        if (url.endsWith(".srx")) {
            return syntaxXML;
        }
        if (url.endsWith(".xml")) {
            return syntaxXML;
        }
        if (url.endsWith(".rdf")) {
            return syntaxRDF_XML;
        }
        if (url.endsWith(".n3")) {
            return syntaxRDF_N3;
        }
        if (url.endsWith(".ttl")) {
            return syntaxRDF_N3;
        }
        if (url.endsWith(".srj")) {
            return syntaxJSON;
        }
        if (url.endsWith(".json")) {
            return syntaxJSON;
        }
        if (url.endsWith(".yml")) {
            return syntaxJSON;
        }
        if (url.endsWith(".sse")) {
            return syntaxSSE;
        }
        if (url.endsWith(".csv")) {
            return syntaxCSV;
        }
        return defaultFormat;
    }

    public static ResultSetFormat lookup(String s) {
        return (ResultSetFormat)syntaxNames.lookup(s);
    }

    static {
        syntaxNames.put("srx", syntaxXML);
        syntaxNames.put("xml", syntaxXML);
        syntaxNames.put("rdf", syntaxRDF_XML);
        syntaxNames.put("rdf/n3", syntaxRDF_N3);
        syntaxNames.put("rdf/xml", syntaxRDF_XML);
        syntaxNames.put("n3", syntaxRDF_N3);
        syntaxNames.put("ttl", syntaxRDF_TURTLE);
        syntaxNames.put("turtle", syntaxRDF_TURTLE);
        syntaxNames.put("text", syntaxText);
        syntaxNames.put("json", syntaxJSON);
        syntaxNames.put("yaml", syntaxJSON);
        syntaxNames.put("sse", syntaxSSE);
        syntaxNames.put("csv", syntaxCSV);
    }
}

